/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import java.util.HashSet;
import java.util.List;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentNotificationsThread
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(CommentNotificationsThread.class);
    String commenterUserId;
    String commentedFeedId;
    private String commentText;
    private String feedOwnerId;
    private NotificationsManager nm;
    private HashSet<String> userIdsToNotify;

    public CommentNotificationsThread(DatabookStore storeInstance, String commenterUserId, String commentedFeedId, String commentText, NotificationsManager nm, String feedOwnerId) {
        this.nm = nm;
        this.commenterUserId = commenterUserId;
        this.commentedFeedId = commentedFeedId;
        this.commentText = commentText;
        this.feedOwnerId = feedOwnerId;
        this.userIdsToNotify = new HashSet();
        List feedComments = storeInstance.getAllCommentByFeed(commentedFeedId);
        for (Comment comment : feedComments) {
            if (comment.getUserid().compareTo(commenterUserId) == 0) continue;
            this.userIdsToNotify.add(comment.getUserid());
        }
    }

    @Override
    public void run() {
        String feedOwnerFullName = "";
        LiferayUserManager um = new LiferayUserManager();
        try {
            feedOwnerFullName = um.getUserByScreenName(this.feedOwnerId).getFullname();
        }
        catch (Exception e) {
            feedOwnerFullName = this.feedOwnerId;
        }
        if (this.userIdsToNotify != null) {
            for (String userId : this.userIdsToNotify) {
                boolean result = this.nm.notifyCommentReply(userId, this.commentedFeedId, this.commentText, feedOwnerFullName);
                _log.trace("Sending Notification for also commented to: " + feedOwnerFullName + " result?" + result);
            }
        }
    }
}

