/**
 * 
 */
package org.gcube.portlets.user.messages.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourcePluginNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.util.Extensions;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;
import org.gcube.portlets.user.homelibrary.util.zip.ZipUtil;
import org.gcube.portlets.user.messages.server.util.SessionUtil;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class DownloadServlet extends HttpServlet{

	private static final long serialVersionUID = -8423345575690165644L;
	
	public static Logger logger = Logger.getLogger(DownloadServlet.class);




	/**
	 * {@inheritDoc}
	 */
	@Override
	public void init() throws ServletException {
		super.init();
		System.out.println("Workspace DownloadServlet ready.");
	}




	public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {

		String itemId = req.getParameter("id");
		boolean viewContent =  (req.getParameter("viewContent")==null)?false:req.getParameter("viewContent").equals("true");

		System.out.println("FILE REQUEST "+itemId);

		Workspace wa = null;
		try {
			wa = SessionUtil.getWorkspace(req.getSession());
		} catch (Exception e) {
			resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during workspace retrieving");
			return;
		}

		if (wa == null) {
			resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error, no workspace in session");
			return;
		}

		WorkspaceItem item;
		try {
			item = wa.getItem(itemId);
		} catch (ItemNotFoundException e) {
			logger.error("Requested item "+itemId+" not found",e);
			resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error, no items found");
			return;
		}

		switch (item.getType()) {
			case FOLDER:{
				try {
					File tmpZip = ZipUtil.zipFolder((WorkspaceFolder) item);
					resp.setHeader( "Content-Disposition", "attachment; filename=\"" + item.getName() + ".zip\"" );
					resp.setContentType("application/zip");
					resp.setContentLength((int) tmpZip.length());
					OutputStream out = resp.getOutputStream();
					IOUtils.copy(new FileInputStream(tmpZip), resp.getOutputStream());
					out.close();
					tmpZip.delete();
					return;

				} catch (InternalErrorException e) {
					logger.error("Error during folder compression "+itemId,e);
					resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during folder compression: "+e.getMessage());
					return;
				}
			}
			case FOLDER_ITEM:{
				FolderItem folderItem = (FolderItem) item;

				switch (folderItem.getFolderItemType()) {
					case REPORT_TEMPLATE:{
						try{
							ReportTemplate reportTemplate = (ReportTemplate)folderItem;
							String itemName = item.getName() + "." + Extensions.REPORT_TEMPLATE.getValue();

							String contentDisposition = (viewContent)?"inline":"attachment";
							resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + itemName + "\"" );

							resp.setContentType("application/zip");
							resp.setContentLength((int) reportTemplate.getLength());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(reportTemplate.getData(), resp.getOutputStream());
							out.close();
						} catch (InternalErrorException e) {
							logger.error("Error during external item sending "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
						return;

					}
					case REPORT:{
						try{
							Report report = (Report)folderItem;

							String itemName = item.getName() + "." + Extensions.REPORT.getValue();

							String contentDisposition = (viewContent)?"inline":"attachment";
							resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + itemName + "\"" );

							resp.setContentType("application/zip");
							resp.setContentLength((int) report.getLength());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(report.getData(), resp.getOutputStream());
							out.close();
						} catch (InternalErrorException e) {
							logger.error("Error during external item sending "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
						return;

					}
					case EXTERNAL_PDF_FILE:
					case EXTERNAL_FILE:{
						try{
							ExternalFile externalFile = (ExternalFile)folderItem;

							String mimeType = externalFile.getMimeType();
							String itemName = MimeTypeUtil.getNameWithExtension(item.getName(), mimeType);

							String contentDisposition = (viewContent)?"inline":"attachment";
							resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + itemName + "\"" );
							resp.setContentType(externalFile.getMimeType());

							resp.setContentLength((int) externalFile.getLength());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(externalFile.getData(), resp.getOutputStream());
							out.close();
						} catch (InternalErrorException e) {
							logger.error("Error during external item sending "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
						return;

					}
					case EXTERNAL_IMAGE:{
						try{
							ExternalImage externalImage = (ExternalImage)folderItem;

							String mimeType = externalImage.getMimeType();
							String itemName = MimeTypeUtil.getNameWithExtension(item.getName(), mimeType);

							String contentDisposition = (viewContent)?"inline":"attachment";
							resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + itemName + "\"" );
							resp.setContentType(externalImage.getMimeType());

							resp.setContentLength((int) externalImage.getLength());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(externalImage.getData(), resp.getOutputStream());
							out.close();
							return;
						} catch (InternalErrorException e) {
							logger.error("Error during item compression "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
					}
					case EXTERNAL_URL:{
						try{
							ExternalUrl externalUrl = (ExternalUrl)folderItem;
							resp.setContentType("text/uri-list");
							resp.setContentLength((int) externalUrl.getLength());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(new StringReader(externalUrl.getUrl()), resp.getOutputStream());
							out.close();
							return;
						} catch (InternalErrorException e) {
							logger.error("Error during item compression "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
					}
					case QUERY:{

						Query query = (Query)folderItem;
						resp.setContentType("text/plain");
						try {
							resp.setContentLength((int) query.getLength());
						} catch (InternalErrorException e) {
							logger.error("Error getting item lenght "+query,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
						OutputStream out = resp.getOutputStream();
						IOUtils.copy(new StringReader(query.getQuery()), resp.getOutputStream());
						out.close();
						return;

					}
					case TIME_SERIES:{
						try{
							TimeSeries ts = (TimeSeries)folderItem;
							File tmpZip = ZipUtil.zipTimeSeries(ts);

							String contentDisposition = (viewContent)?"inline":"attachment";
							resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + item.getName() + ".zip\"" );

							resp.setContentType("application/zip");
							resp.setContentLength((int) tmpZip.length());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(new FileInputStream(tmpZip), resp.getOutputStream());
							out.close();
							tmpZip.delete();
							return;
						} catch (InternalErrorException e) {
							logger.error("Error during item compression "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
					}
					case AQUAMAPS_ITEM:{
						try{
							AquaMapsItem aquamaps = (AquaMapsItem)folderItem;
							File tmpZip = ZipUtil.zipAquaMapsItem(aquamaps);

							String contentDisposition = (viewContent)?"inline":"attachment";
							resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + item.getName() + ".zip\"" );

							resp.setContentType("application/zip");
							resp.setContentLength((int) tmpZip.length());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(new FileInputStream(tmpZip), resp.getOutputStream());
							out.close();
							tmpZip.delete();
							return;
						} catch (InternalErrorException e) {
							logger.error("Error during item compression "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
					}
					case IMAGE_DOCUMENT:
					case PDF_DOCUMENT:
					case URL_DOCUMENT:
					case DOCUMENT:{
						try{
							Document document = (Document)item;


							if (!viewContent){
								File tmpZip = ZipUtil.zipDocument(document);

								resp.setHeader( "Content-Disposition", "attachment; filename=\"" + item.getName() + ".zip\"" );
								resp.setContentType("application/zip");
								resp.setContentLength((int) tmpZip.length());
								OutputStream out = resp.getOutputStream();
								IOUtils.copy(new FileInputStream(tmpZip), resp.getOutputStream());
								out.close();
								tmpZip.delete();
							}
							else{
								String mimeType = document.getMimeType();
								String itemName = MimeTypeUtil.getNameWithExtension(item.getName(), mimeType);
								resp.setHeader( "Content-Disposition", "inline; filename=\"" + itemName + "\"" );
								resp.setContentType(document.getMimeType());
								resp.setContentLength((int) document.getLength());
								OutputStream out = resp.getOutputStream();
								IOUtils.copy(document.getData(), resp.getOutputStream());
								out.close();
							}
							return;
						} catch (InternalErrorException e) {
							logger.error("Error during item compression "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}
					}

					case METADATA:{
						try{
							Metadata document = (Metadata)item;

							resp.setContentType("text/html");
							resp.setContentLength((int) document.getLength());
							OutputStream out = resp.getOutputStream();
							IOUtils.copy(new StringReader(document.getData()), resp.getOutputStream());
							out.close();

							return;
						} catch (InternalErrorException e) {
							logger.error("Error during item compression "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						}


					}
					
					case EXTERNAL_RESOURCE_LINK:{ //IT'S SAME OF EXTERNAL FILE
						
						try{
							ExternalResourceLink externalResourceLink = (ExternalResourceLink) folderItem;
							OutputStream out = resp.getOutputStream();
							
							try {
								String mimeType = externalResourceLink.getMimeType();
								if(mimeType == null){
									System.out.println("mimeType is null... recover from MimeTypeUtil by BufferedInputStream");
									
									BufferedInputStream bufferedStream = new BufferedInputStream(externalResourceLink.getData(), (int) externalResourceLink.getLength());
									mimeType  = MimeTypeUtil.getMimeType(bufferedStream);
								}
								
								System.out.println("setContentType with mimeType " + mimeType);
								String itemName = MimeTypeUtil.getNameWithExtension(item.getName(), mimeType);

								String contentDisposition = (viewContent)?"inline":"attachment";
								resp.setHeader( "Content-Disposition", contentDisposition+"; filename=\"" + itemName + "\"" );
								resp.setContentType(mimeType);
	
								
								System.out.println("resoure link lenght: " +externalResourceLink.getLength());

								resp.setContentLength((int) externalResourceLink.getLength());

								if(externalResourceLink.getData()!=null){
									System.out.println("Input stream is not null");
									IOUtils.copy(externalResourceLink.getData(), resp.getOutputStream());
								}
								else{
									logger.error("Input stream is null "+itemId);
									resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during inpunt stream retrieving, it's null");
								}
								
							} catch (ExternalResourceBrokenLinkException e) {
								logger.error("Error during link resource retrieving "+itemId,e);
								resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during link retrieving, link broken!: "+e.getMessage());
							} catch (ExternalResourcePluginNotFoundException e) {
								logger.error("Error during link resource retrieving "+itemId,e);
								resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during link retrieving, plugin not found!: "+e.getMessage());
							}
							out.close();
						} catch (InternalErrorException e) {
							logger.error("Error during external item sending "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving: "+e.getMessage());
							return;
						} catch (Exception e) {
							logger.error("Error during resource retrieving "+itemId,e);
							resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during resource retrieving, plugin not found!: "+e.getMessage());
							e.printStackTrace();
						}
						
						
						return;

						
						
					}
				}

			}
		}

		resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Error during data retrieving");
		return;

	}
}
