/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.sharing;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class JCRWorkspaceMessage
implements WorkspaceMessage {
    private static final String CREATED = "jcr:created";
    private static final String SUBJECT = "hl:subject";
    private static final String BODY = "hl:body";
    private static final String ATTACHMENTS = "hl:attachments";
    private static final String ADDRESSES = "hl:addresses";
    private static final String TITLE = "jcr:title";
    private static final String OWNER = "hl:owner";
    private static final String SCOPE = "hl:scope";
    private static final String PORTAL_LOGIN = "hl:portalLogin";
    private static final String USER_ID = "hl:uuid";
    private static final String READ = "hl:read";
    private static final String OPEN = "hl:open";
    private final JCRWorkspace workspace;
    private final String id;
    private final String subject;
    private final String body;
    private final User user;
    private final Calendar date;
    private List<String> attachments;
    private final List<String> addresses;
    private boolean isRead;
    private boolean isOpened;
    private final WorkspaceMessageType type;

    public JCRWorkspaceMessage(JCRWorkspace workspace, Node node, WorkspaceMessageType type) throws RepositoryException {
        this.type = type;
        this.workspace = workspace;
        this.id = node.getName();
        this.subject = node.getProperty(SUBJECT).getString();
        this.body = node.getProperty(BODY).getString();
        this.isRead = node.getProperty(READ).getBoolean();
        this.isOpened = node.getProperty(OPEN).getBoolean();
        this.date = node.getProperty(CREATED).getDate();
        Node userNode = node.getNode(OWNER);
        this.user = new JCRUser(userNode.getProperty(USER_ID).getString(), userNode.getProperty(PORTAL_LOGIN).getString(), GCUBEScope.getScope((String)userNode.getProperty(SCOPE).getString()));
        LinkedList<String> attachments = new LinkedList<String>();
        Node attachmentsNode = node.getNode(ATTACHMENTS);
        NodeIterator iterator = attachmentsNode.getNodes();
        while (iterator.hasNext()) {
            attachments.add(iterator.nextNode().getIdentifier());
        }
        this.attachments = attachments;
        LinkedList<String> addresses = new LinkedList<String>();
        for (Value user : node.getProperty(ADDRESSES).getValues()) {
            addresses.add(user.getString());
        }
        this.addresses = addresses;
    }

    public JCRWorkspaceMessage(JCRWorkspace workspace, Node node, WorkspaceMessageType type, String messageId, String subject, String body, User sender, List<String> attachmentIds, List<String> addresses) throws RepositoryException, InternalErrorException {
        this.type = type;
        this.workspace = workspace;
        this.id = messageId;
        this.subject = subject;
        this.body = body;
        this.user = sender;
        this.isRead = false;
        this.isOpened = false;
        this.date = Calendar.getInstance();
        this.addresses = addresses;
        node.setProperty(SUBJECT, subject);
        node.setProperty(BODY, body);
        node.setProperty(READ, false);
        node.setProperty(OPEN, false);
        Node ownerNode = node.getNode(OWNER);
        ownerNode.setProperty(USER_ID, this.user.getId());
        ownerNode.setProperty(SCOPE, this.user.getScope().toString());
        ownerNode.setProperty(PORTAL_LOGIN, this.user.getPortalLogin());
        node.setProperty(ADDRESSES, addresses.toArray(new String[addresses.size()]));
        Node rootAttachments = node.getNode(ATTACHMENTS);
        node.getSession().save();
        Session session = node.getSession();
        LinkedList<User> users = new LinkedList<User>();
        for (String address : addresses) {
            User user = workspace.getHome().getHomeManager().getUser(address);
            if (user == null) continue;
            users.add(user);
        }
        for (String attachmentId : attachmentIds) {
            Node nodeItem = session.getNodeByIdentifier(attachmentId);
            JCRWorkspaceItem item = workspace.getWorkspaceItem(nodeItem);
            try {
                item.internalCopy(rootAttachments, nodeItem.getName());
                workspace.fireItemSentEvent(item, users);
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public User getSender() {
        return this.user;
    }

    public Calendar getSendTime() {
        return this.date;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getAttachmentsIds() {
        return this.attachments;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void open() throws InternalErrorException {
        this.isOpened = true;
        Session session = JCRRepository.getSession();
        Node root = null;
        try {
            switch (this.type) {
                case RECEIVED: {
                    root = this.workspace.getRepository().getOwnInBoxFolder(session);
                    break;
                }
                case SENT: {
                    root = this.workspace.getRepository().getOutBoxFolder(session);
                }
            }
            Node node = root.getNode(this.id);
            node.setProperty(OPEN, true);
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setStatus(boolean status) throws InternalErrorException {
        this.isRead = status;
        Session session = JCRRepository.getSession();
        Node root = null;
        try {
            switch (this.type) {
                case RECEIVED: {
                    root = this.workspace.getRepository().getOwnInBoxFolder(session);
                    break;
                }
                case SENT: {
                    root = this.workspace.getRepository().getOutBoxFolder(session);
                }
            }
            Node node = root.getNode(this.id);
            node.setProperty(READ, status);
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachments(String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            WorkspaceFolder folder;
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(destinationFolderId);
                folder = (WorkspaceFolder)this.workspace.getItem(session, destinationFolderId);
            }
            catch (RepositoryException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (InternalErrorException e) {
                throw new WrongDestinationException(e.getMessage());
            }
            for (String attachmentId : this.attachments) {
                this.saveAttachment(session, attachmentId, folder, folderNode);
            }
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceItem saveAttachment(String attachmentId, String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            WorkspaceItem workspaceItem = this.saveAttachment(session, attachmentId, destinationFolderId);
            return workspaceItem;
        }
        finally {
            session.logout();
        }
    }

    private WorkspaceItem saveAttachment(Session session, String attachmentId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException {
        WorkspaceFolder folder;
        Node folderNode;
        try {
            folderNode = session.getNodeByIdentifier(destinationFolderId);
            folder = (WorkspaceFolder)this.workspace.getItem(session, destinationFolderId);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (InternalErrorException e) {
            throw new WrongDestinationException(e.getMessage());
        }
        return this.saveAttachment(session, attachmentId, folder, folderNode);
    }

    private WorkspaceItem saveAttachment(Session session, String attachmentId, WorkspaceFolder folder, Node folderNode) throws ItemNotFoundException, WrongDestinationException, InternalErrorException {
        try {
            Node attachment = session.getNodeByIdentifier(attachmentId);
            String name = WorkspaceUtil.getUniqueName((String)attachment.getProperty(TITLE).getString(), (WorkspaceFolder)folder);
            String pathDestination = folderNode.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)name);
            session.getWorkspace().copy(attachment.getPath(), pathDestination);
            Node itemSaved = session.getNode(pathDestination);
            itemSaved.setProperty(TITLE, name);
            session.save();
            return this.workspace.getItem(session, itemSaved.getIdentifier());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<WorkspaceItem> getAttachments() throws InternalErrorException {
        LinkedList<WorkspaceItem> list = new LinkedList<WorkspaceItem>();
        Session session = JCRRepository.getSession();
        try {
            for (String id : this.attachments) {
                list.add(this.workspace.getItem(session, id));
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public static enum WorkspaceMessageType {
        RECEIVED,
        SENT;

    }
}

