/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.collectionsviewer.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.collectionsviewer.client.ViewerService;
import org.gcube.portlets.user.collectionsviewer.shared.CollectionBean;

public class ViewerServiceImpl
extends RemoteServiceServlet
implements ViewerService {
    private static GCUBEClientLog log = new GCUBEClientLog(ViewerServiceImpl.class, new Properties[0]);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        System.out.println("getASLSession COLLECTIONS");
        if (user == null) {
            user = "massimiliano.assante";
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
            session.setScope("/gcube/devsec");
            return session;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public List<CollectionBean> getAvailableCollections() {
        ArrayList<CollectionBean> toReturn = new ArrayList<CollectionBean>();
        log.debug((Object)"GETTING AVAILABLE COLLECTIONS");
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            WSResourceQuery query = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "tree-manager-service"), new AtomicCondition("//gc:ServiceClass", "DataAccess")});
            List results = client.execute((ISQuery)query, this.getASLSession().getScope());
            for (RPDocument result : results) {
                String endpoint = result.getEndpoint().getAddress().getPath();
                if (!endpoint.endsWith("gcube/data/tm/reader")) continue;
                String name = (String)result.evaluate("//*[local-name()='Name']/text()").get(0);
                String id = (String)result.evaluate("//*[local-name()='SourceId']/text()").get(0);
                String totalItems = result.evaluate("//*[local-name()='Cardinality']/text()").size() > 0 ? (String)result.evaluate("//*[local-name()='Cardinality']/text()").get(0) : "0";
                toReturn.add(new CollectionBean(id, name, "No Description Available, total items: " + totalItems, new Date(), "Tree Manager"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"ERROR GETTING AVAILABLE COLLECTIONS");
            toReturn.add(new CollectionBean("0000", "NO COLLECTION", "", new Date(), "Content Manager"));
            return toReturn;
        }
        log.trace((Object)"Printing COLLECTIONS");
        for (CollectionBean collectionBean : toReturn) {
            log.trace((Object)("COLLECTION " + collectionBean.getName() + " FROM: " + collectionBean.getSource()));
        }
        log.debug((Object)"GOT AVAILABLE COLLECTIONS");
        return toReturn;
    }
}

