package org.gcube.portlets.user.collectionsviewer.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.data.tml.Constants;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.collectionsviewer.client.ViewerService;
import org.gcube.portlets.user.collectionsviewer.shared.CollectionBean;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class ViewerServiceImpl extends RemoteServiceServlet implements
ViewerService {

	private static GCUBEClientLog log = new GCUBEClientLog(ViewerServiceImpl.class);
	/**
	 * the current D4SSession
	 * @return .
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		System.out.println("getASLSession COLLECTIONS");
		if (user == null) {
			user = "massimiliano.assante";
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);	
			session.setScope("/gcube/devsec");
			return session;
		}
		else
			return SessionManager.getInstance().getASLSession(sessionID, user);
	}

	/**
	 * 
	 */
	public List<CollectionBean> getAvailableCollections() {
		List<CollectionBean> toReturn = new ArrayList<CollectionBean>();
	
		log.debug("GETTING AVAILABLE COLLECTIONS" );

		try {
			//getting Tree Manager Collections
			
	    	ISClient client = GHNContext.getImplementation(ISClient.class);
	    	WSResourceQuery query = client.getQuery(WSResourceQuery.class);
	    	query.addAtomicConditions(
	    			new AtomicCondition("//gc:ServiceName", "tree-manager-service"), new AtomicCondition("//gc:ServiceClass", "DataAccess")
	    	);
	    	List<RPDocument> results = client.execute(query, getASLSession().getScope());	    	
	    	for (RPDocument result : results) {
	    		String endpoint = result.getEndpoint().getAddress().getPath();
	    		if (endpoint.endsWith(Constants.readerWSDDName)) {
	    			String name = result.evaluate("//*[local-name()='"+"Name"+"']/text()").get(0);
	    			String id = result.evaluate("//*[local-name()='"+"SourceId"+"']/text()").get(0);
	    			String totalItems = (result.evaluate("//*[local-name()='"+"Cardinality"+"']/text()").size() > 0) ?  result.evaluate("//*[local-name()='"+"Cardinality"+"']/text()").get(0) : "0";
	    			toReturn.add(new CollectionBean(id, name, "No Description Available, total items: " + totalItems, new Date(), "Tree Manager"));
	    		}
	    	}
	    	

		} catch (Exception e) {
			e.printStackTrace();
			log.error("ERROR GETTING AVAILABLE COLLECTIONS" );
			toReturn.add(new CollectionBean("0000", "NO COLLECTION", "", new Date(), "Content Manager"));
			return toReturn;
		}
		//		
		log.trace("Printing COLLECTIONS" );
		for (CollectionBean collectionBean : toReturn) {
			log.trace("COLLECTION " + collectionBean.getName() + " FROM: " + collectionBean.getSource());
		}		
		
		
    			
		
		log.debug("GOT AVAILABLE COLLECTIONS" );
		return toReturn;
	}


}
