package org.gcube.portlets.admin.software_upload_wizard.server.rpc.handlers;

import org.gcube.portlets.admin.software_upload_wizard.server.importmanagers.ImportSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetStringData;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetStringDataResult;
import org.slf4j.Logger;

import com.google.inject.Inject;

import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import net.customware.gwt.dispatch.shared.DispatchException;

public class SetStringDataHandler implements
		ActionHandler<SetStringData, SetStringDataResult> {

	@InjectLogger
	Logger logger;

	ImportSessionManager importSessionManager;

	@Inject
	public SetStringDataHandler(ImportSessionManager importSessionManager) {
		super();
		this.importSessionManager = importSessionManager;
	}

	@Override
	public Class<SetStringData> getActionType() {
		return SetStringData.class;
	}

	@Override
	public SetStringDataResult execute(SetStringData action,
			ExecutionContext context) throws DispatchException {
		try {
			logger.trace("Setting value for key '" + action.getKey() + "': "
					+ action.getValue());
			importSessionManager.getImportSession().setGenericData(
					action.getKey(), action.getValue());
			logger.trace("Value " + action.getValue() + " set for key "
					+ action.getKey());
			return new SetStringDataResult();
		} catch (Exception e) {
			throw new ActionException(e);
		}

	}

	@Override
	public void rollback(SetStringData action, SetStringDataResult result,
			ExecutionContext context) throws DispatchException {
		// TODO Implement rollback logic
	}

}
