/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.is;

import java.util.ArrayList;
import org.gcube.portlets.admin.accountingmanager.server.is.EnableTabJAXB;
import org.gcube.portlets.admin.accountingmanager.server.is.EnableTabsJAXB;
import org.gcube.portlets.admin.accountingmanager.server.is.InformationSystemUtils;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.portlets.admin.accountingmanager.shared.tabs.EnableTab;
import org.gcube.portlets.admin.accountingmanager.shared.tabs.EnableTabs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildEnableTabs {
    private static Logger logger = LoggerFactory.getLogger(BuildEnableTabs.class);

    public static EnableTabs build(String scope) throws ServiceException {
        ArrayList<EnableTab> enableTabList = new ArrayList<EnableTab>();
        EnableTabsJAXB enableTabsJAXB = InformationSystemUtils.retrieveEnableTab((String)scope);
        logger.debug("Enable Tabs: " + enableTabsJAXB);
        if (enableTabsJAXB != null && enableTabsJAXB.getEnableTabs() != null && !enableTabsJAXB.getEnableTabs().isEmpty()) {
            for (EnableTabJAXB enableTab : enableTabsJAXB.getEnableTabs()) {
                AccountingType type = AccountingType.getTypeFromString((String)enableTab.getName());
                if (type == null) continue;
                if (enableTab.getRoles() != null && !enableTab.getRoles().isEmpty()) {
                    ArrayList enableRoles = new ArrayList();
                    enableRoles.addAll(enableTab.getRoles());
                    enableTabList.add(new EnableTab(type, enableRoles));
                    continue;
                }
                enableTabList.add(new EnableTab(type, null));
            }
        } else {
            String error = "Error retrieving AccountingManager resource for get enable tabs in scope: " + scope;
            logger.error(error);
            throw new ServiceException(error);
        }
        EnableTabs enableTabs = new EnableTabs(enableTabList);
        logger.debug("EnableTabsData: " + enableTabs);
        return enableTabs;
    }
}

