/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingState;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.portlets.admin.accountingmanager.shared.exception.SessionExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

    public static ASLSession getASLSession(HttpSession httpSession) throws ServiceException {
        String username = (String)httpSession.getAttribute("username");
        if (username == null) {
            logger.info("No user found in session");
            throw new SessionExpiredException("Session Expired!");
        }
        ASLSession aslSession = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        logger.info("SessionUtil: aslSession " + aslSession.getUsername() + " " + aslSession.getScope());
        return aslSession;
    }

    public static String getToken(ASLSession aslSession) throws ServiceException {
        String token = null;
        token = aslSession.getSecurityToken();
        logger.info("received token: " + token);
        return token;
    }

    public static void setAccountingStateData(HttpSession httpSession, AccountingType accountingType, AccountingStateData accountingStateData) {
        AccountingState accountingState = (AccountingState)httpSession.getAttribute("ACCOUNTING_STATE");
        if (accountingState == null) {
            accountingState = new AccountingState();
            accountingState.setState(accountingType, accountingStateData);
            httpSession.setAttribute("ACCOUNTING_STATE", (Object)accountingState);
        } else {
            accountingState.setState(accountingType, accountingStateData);
        }
    }

    public static AccountingStateData getAccountingStateData(HttpSession httpSession, AccountingType accountingType) {
        AccountingState accountingState = (AccountingState)httpSession.getAttribute("ACCOUNTING_STATE");
        if (accountingState == null) {
            return null;
        }
        return accountingState.getState(accountingType);
    }
}

