/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management.maven;

import java.io.File;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.warmanagementwidget.server.management.ISUtil;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class ConsoleMavenDeployer implements MavenDeployer {
	
	protected Logger logger = Logger.getLogger(ConsoleMavenDeployer.class);

	
	public void deploy(GCUBEScope scope, MavenCoordinates mavenCoordinates, File warFile) throws Exception
	{
		MavenRepositoryInfo repositoryInfo = retrieveRepositoryInfo(scope);
		runDeploy(repositoryInfo, warFile, mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion());
	}
	
	protected void runDeploy(MavenRepositoryInfo repositoryInfo, File warFile, String groupId, String artifactId, String version) throws Exception
	{
		List<String> args = new LinkedList<String>();
		args.add("mvn");
		
		//args.add("-e");
		
		//-s /home/gabriele/.m2/settings.xml 
		/*String settingFile = "/home/fedy2/.m2/settings.xml";
		args.add("-s"+settingFile);*/
		
		
		//-Dmaven.repo.local=/home/gabriele/.m2/repository 
		/*String repoLocalDir = "/home/fedy2/.m2/repository";
		args.add("-Dmaven.repo.local="+repoLocalDir);*/
		
		
		//-Durl=http://maven.research-infrastructures.eu:8081/nexus/content/repositories/gcube-snapshots/
		args.add("-Durl="+repositoryInfo.getUrl());
		
		
		//-DrepositoryId=gcube-snapshots 
		args.add("-DrepositoryId="+repositoryInfo.getId());
		
		
		//-Dfile=/home/gabriele/tmp/myapp.war
		args.add("-Dfile="+warFile.getAbsolutePath());
		
		
		//-DgroupId=org.gcube.customwars
		args.add("-DgroupId="+groupId);
		
		//-DartifactId=myapp
		args.add("-DartifactId="+artifactId);
		
		//-Dversion=1.0.0 
		args.add("-Dversion="+version);
		
		//-Dpackaging=war
		String packaging = "war";
		args.add("-Dpackaging="+packaging);
		
		
		args.add("deploy:deploy-file");
		
		logger.trace("args: "+args);
		ProcessBuilder processBuilder = new ProcessBuilder(args);
		
		processBuilder.redirectErrorStream(true);
		
		Process process = processBuilder.start();
		int code = process.waitFor();
		
		logger.trace("return code: "+code);
		
		if (code!=0) {
			StringWriter output = new StringWriter();
			IOUtils.copy(process.getInputStream(), output);
			logger.error("An error occurred deploying the artifact: "+output.toString());
			throw new Exception("An error occurred deploying the artifact: "+output.toString());
		}
	}
	
	protected MavenRepositoryInfo retrieveRepositoryInfo(GCUBEScope scope) throws Exception
	{
		AccessPoint accessPoint = ISUtil.getMavenAccessPoint(scope);
		String url = accessPoint.getEndpoint();
		String id = accessPoint.getProperty("repositoryId");
		//TODO "http://maven.research-infrastructures.eu:8081/nexus/content/repositories/gcube-snapshots/", "gcube-snapshots"
		return new MavenRepositoryInfo(url, id);
	}
}
