/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationState;
import org.gcube.portlets.user.warmanagementwidget.server.accesslog.AccessLogUtil;
import org.gcube.portlets.user.warmanagementwidget.server.util.Util;
import org.gcube.vremanagement.softwaregateway.client.RemoveProfileClient;


/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class GCubeWarDeleter implements Runnable {

	protected Logger logger = Logger.getLogger(GCubeWarDeleter.class);

	protected OperationProgress operationProgress;

	protected String user;
	protected String id;
	protected String packageName;
	protected String packageVersion;
	protected String serviceClass;
	protected String serviceName;
	protected String serviceVersion;
	protected GCUBEScope scope;
	protected GCUBESecurityManager securityManager;

	public GCubeWarDeleter(OperationProgress operationProgress,
			String user, GCUBEScope scope, GCUBESecurityManager securityManager, 
			String id, String packageName, String packageVersion, String serviceClass, String serviceName, String serviceVersion) {
		this.operationProgress = operationProgress;
		this.user = user;
		this.scope = scope;
		this.securityManager = securityManager;
		this.id = id;
		this.packageName = packageName;
		this.packageVersion = packageVersion;
		this.serviceClass = serviceClass;
		this.serviceName = serviceName;
		this.serviceVersion = serviceVersion;
		
		ConsoleAppender ca = new ConsoleAppender(new SimpleLayout());
		ca.setThreshold(Level.ALL);
		ca.activateOptions();
		logger.addAppender(ca);
		logger.setLevel(Level.ALL);
	}

	@Override
	public void run() {

		operationProgress.setElaboratedLenght(0);
		logger.trace("removing the profile");
		try {
			RemoveProfileClient.removeProfile(scope, packageName, packageVersion, serviceClass, serviceName, serviceVersion);
		} catch (Exception e) {
			logger.error("An error occured deleting the SA profile", e);
			operationProgress.setFailed("An error occured removing the SA", Util.exceptionDetailMessage(e));
			return;
		}
		
		operationProgress.setElaboratedLenght(1);
		
		
		operationProgress.setState(OperationState.COMPLETED);
		AccessLogUtil.logWarRemoved(user, scope, id);

	}
	
}
