/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.vredefinition.server;

import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.vremanagement.vremanagement.impl.VREGeneratorEvo;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.vredefinition.client.VREDefinitionService;
import org.gcube.portlets.vredefinition.client.model.VREFunctionalityModel;
import org.gcube.portlets.vredefinition.server.loggers.CreatedVRELogEntry;
import org.gcube.portlets.vredefinition.server.loggers.OpenVREWizardLogEntry;
import org.gcube.portlets.vredefinition.shared.ExternalResourceModel;
import org.gcube.portlets.vredefinition.shared.ResourceCategory;
import org.gcube.portlets.vredefinition.shared.ResourceCategoryItem;
import org.gcube.portlets.vredefinition.shared.VRECollectionBean;
import org.gcube.portlets.vredefinition.shared.VREDescriptionBean;
import org.gcube.portlets.vredefinition.shared.exception.VREDefinitionException;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityItem;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityList;
import org.gcube.vremanagement.vremodeler.stubs.ResourceDescriptionItem;
import org.gcube.vremanagement.vremodeler.stubs.ResourceItem;
import org.gcube.vremanagement.vremodeler.stubs.SelectedResourceDescriptionType;
import org.gcube.vremanagement.vremodeler.stubs.VREDescription;

public class VREDefinitionServiceImpl
extends RemoteServiceServlet
implements VREDefinitionService {
    private static final String DESIGNER = "Designer";
    private static final String MANAGER = "Manager";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static String VRE_MANAGER_STRING = "VRE-Manager";
    private static final String VRE_GENERATOR_ATTRIBUTE = "VREGenerator";
    private static final String VRE_DEFINER_GENERATOR_ATTRIBUTE = "VREDefinerGenerator";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String HARD_CODED_VO_NAME = "/gcube/devsec";
    private static final String REEDIT_TYPE_ATTRIBUTE = "reeditType";
    private static final String APPROVE_MODE = "approve";
    public static final String EDIT_MODE = "edit";
    private static final String CATEGORIES = "CATEGORIES";
    public static GCUBEClientLog _log = new GCUBEClientLog(VREDefinitionServiceImpl.class, new Properties[0]);
    private boolean withinEclipse = false;

    private ASLSession getASLSession() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute(USERNAME_ATTRIBUTE);
        if (username == null) {
            username = "massimiliano.assante";
            SessionManager.getInstance().getASLSession(session.getId(), username).setScope(HARD_CODED_VO_NAME);
            SessionManager.getInstance().getASLSession(session.getId(), username).setAttribute(REEDIT_TYPE_ATTRIBUTE, (Object)APPROVE_MODE);
            this.withinEclipse = true;
        }
        return SessionManager.getInstance().getASLSession(session.getId(), username);
    }

    private VREGeneratorEvo getVREGenerator() {
        ASLSession d4ScienceSession = this.getASLSession();
        VREGeneratorEvo vreGenerator = (VREGeneratorEvo)d4ScienceSession.getAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE);
        if (vreGenerator == null) {
            vreGenerator = new VREGeneratorEvo(d4ScienceSession);
            d4ScienceSession.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, (Object)vreGenerator);
        }
        AccessLogger log = AccessLogger.getAccessLogger();
        OpenVREWizardLogEntry logEntry = new OpenVREWizardLogEntry();
        log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
        return vreGenerator;
    }

    private void storeResourceCategoryInSession(HashMap<String, ArrayList<ResourceCategory>> funcCategories) {
        this.getASLSession().setAttribute(CATEGORIES, funcCategories);
    }

    private HashMap<String, ArrayList<ResourceCategory>> getResourceCategoryFromSession() {
        return (HashMap)this.getASLSession().getAttribute(CATEGORIES);
    }

    public ArrayList<ExternalResourceModel> getResourceCategoryByFunctionality(String id) {
        ArrayList toReturn = new ArrayList();
        return this.getResourceCategoryFromSession().containsKey(id) ? this.getExternaleResources(id) : toReturn;
    }

    private ArrayList<ExternalResourceModel> getExternaleResources(String id) {
        ArrayList<ExternalResourceModel> toReturn = new ArrayList<ExternalResourceModel>();
        ArrayList cats = (ArrayList)this.getResourceCategoryFromSession().get(id);
        for (ResourceCategory rc : cats) {
            for (ResourceCategoryItem item : rc.getItems()) {
                toReturn.add(new ExternalResourceModel(item.getId(), item.getName(), item.getDescription(), item.isSelected(), rc.getName(), rc.getId()));
            }
        }
        return toReturn;
    }

    public VREFunctionalityModel getFunctionality() throws VREDefinitionException {
        Calendar cal = Calendar.getInstance();
        long startTime = cal.getTimeInMillis();
        cal.add(2, 5);
        cal.add(10, 7);
        long endTime = cal.getTimeInMillis();
        try {
            this.getVREGenerator().setVREModel("notCompletedVirtualResearchEnv.", UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), startTime, endTime);
            Thread.sleep(1000L);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (!this.getVREGenerator().isVreModelerServiceUp()) {
            return null;
        }
        VREFunctionalityModel toReturn = new VREFunctionalityModel("", "selected functionality", "", "", false);
        try {
            HashMap funCategories = new HashMap();
            FunctionalityList list = this.getVREGenerator().getFunctionality();
            if (list == null) {
                _log.warn((Object)"FunctionalityList NULL");
            }
            for (FunctionalityItem fi : list.getList()) {
                System.out.println(fi.getId() + " " + fi.getName());
                VREFunctionalityModel toAdd = new VREFunctionalityModel(Integer.toString(fi.getId()), fi.getName(), fi.getDescription(), "", fi.isSelected());
                if (fi.getChilds() == null) continue;
                FunctionalityItem[] children = fi.getChilds();
                VREFunctionalityModel[] newchildrens = new VREFunctionalityModel[children.length];
                for (int i = 0; i < children.length; ++i) {
                    System.out.println(children[i].getName() + " is " + children[i].isSelected());
                    newchildrens[i] = new VREFunctionalityModel(Integer.toString(children[i].getId()), children[i].getName(), children[i].getDescription(), "functionality-add-icon", children[i].isSelected());
                    ArrayList<ResourceCategory> resCats = new ArrayList<ResourceCategory>();
                    if (children[i].getSelectableResourcesDescription() == null) continue;
                    for (ResourceDescriptionItem category : children[i].getSelectableResourcesDescription()) {
                        if (category.getResource() == null) continue;
                        ResourceCategory rc = new ResourceCategory(category.getId(), category.getDescription());
                        for (ResourceItem resource : category.getResource()) {
                            rc.addResourceItem(new ResourceCategoryItem(resource.getId(), resource.getName(), resource.getDescription(), resource.isSelected()));
                        }
                        resCats.add(rc);
                    }
                    funCategories.put(newchildrens[i].getId(), resCats);
                }
                toAdd.addChildren(newchildrens);
                toReturn.add((ModelData)toAdd);
            }
            this.storeResourceCategoryInSession(funCategories);
            for (String func : funCategories.keySet()) {
                System.out.println("-" + func);
                for (ResourceCategory category : (ArrayList)funCategories.get(func)) {
                    System.out.println("--" + category.getName());
                    for (ResourceCategoryItem rc : category.getItems()) {
                        System.out.println("----" + rc.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VREDefinitionException("Set functionalities Error");
        }
        return toReturn;
    }

    public Map<String, Object> getVRE() throws VREDefinitionException {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute(USERNAME_ATTRIBUTE);
        List belongingUsers = new LinkedList();
        if (this.withinEclipse) {
            return this.getFakeBelongingUsers();
        }
        try {
            LiferayUserManager um = new LiferayUserManager();
            long currOrgid = this.getASLSession().getGroupId();
            LiferayRoleManager rm = new LiferayRoleManager();
            System.out.println("Trying to get roleid of " + VRE_MANAGER_STRING + " into " + this.getASLSession().getGroupName());
            String roleId = "none";
            roleId = rm.getRoleId(VRE_MANAGER_STRING, this.getASLSession().getGroupName());
            System.out.println("Trying to get VRE-Managers of " + currOrgid + " role id=" + roleId);
            belongingUsers = um.listUsersByGroupAndRole("" + currOrgid, roleId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new VREDefinitionException("We cannot find any VO-Admin user for this environment. There must be at least one.");
        }
        if (belongingUsers == null || belongingUsers.size() == 0) {
            throw new VREDefinitionException("We cannot find any VO-Admin user for this environment. There must be at least one.");
        }
        try {
            ArrayList<String> managers = new ArrayList<String>();
            for (int i = 0; i < belongingUsers.size(); ++i) {
                managers.add(((UserModel)belongingUsers.get(i)).getScreenName());
            }
            toReturn.put(MANAGER, managers);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VREDefinitionException("We cannot find any VO-Admin user for this environment. There must be at least one.");
        }
        toReturn.put(DESIGNER, username);
        try {
            VREDescriptionBean vre = this.getVREInSession();
            if (vre != null) {
                toReturn.put("vreName", vre.getName());
                toReturn.put("vreManager", vre.getManager());
                toReturn.put("vreDesigner", vre.getDesigner());
                toReturn.put("vreDescription", vre.getDescription());
                toReturn.put("vreStartTime", vre.getStartTime());
                toReturn.put("vreEndTime", vre.getEndTime());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return toReturn;
    }

    private HashMap<String, Object> getFakeBelongingUsers() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ArrayList<String> managers = new ArrayList<String>();
        managers.add("antonio.gioia");
        managers.add("andrea.manzi");
        managers.add("massimiliano.assante");
        ret.put(MANAGER, managers);
        ret.put(DESIGNER, "antonio.gioia");
        try {
            VREDescriptionBean vre = this.getVREInSession();
            if (vre != null) {
                System.out.println(" ########### VRE != NULL ##########");
                ret.put("vreName", vre.getName());
                ret.put("vreManager", vre.getManager());
                ret.put("vreDesigner", vre.getDesigner());
                ret.put("vreDescription", vre.getDescription());
                ret.put("vreStartTime", vre.getStartTime());
                ret.put("vreEndTime", vre.getEndTime());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String setVRE(VREDescriptionBean bean, String[] functionalityIDs, HashMap<String, List<ExternalResourceModel>> funcToExternalResources) throws VREDefinitionException {
        this.setVREDescription(bean);
        this.setFunctionality(functionalityIDs, funcToExternalResources);
        try {
            this.getVREGenerator().setVREtoPendingState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.getASLSession().setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
        AccessLogger log = AccessLogger.getAccessLogger();
        CreatedVRELogEntry logEntry = new CreatedVRELogEntry(bean.getName(), "unknown", bean.getDesigner(), bean.getManager());
        log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
        return null;
    }

    public String setFunctionality(String[] functionalityIDs, HashMap<String, List<ExternalResourceModel>> funcToExternalResources) throws VREDefinitionException {
        ArrayList<SelectedResourceDescriptionType> toSend = new ArrayList<SelectedResourceDescriptionType>();
        for (int i = 0; i < functionalityIDs.length; ++i) {
            if (!funcToExternalResources.containsKey(functionalityIDs[i])) continue;
            String descriptionId = "";
            ArrayList<String> resourceidsArray = new ArrayList<String>();
            for (ExternalResourceModel extRes : funcToExternalResources.get(functionalityIDs[i])) {
                _log.debug((Object)("resource: " + extRes.getName() + " Selected?" + extRes.isSelected()));
                if (!extRes.isSelected()) continue;
                descriptionId = extRes.getCategoryId();
                resourceidsArray.add(extRes.getId());
                _log.debug((Object)("------> Added selected resource: " + extRes.getName() + " id=" + extRes.getId() + "\n"));
            }
            String[] resourceids = resourceidsArray.toArray(new String[0]);
            toSend.add(new SelectedResourceDescriptionType(descriptionId, resourceids));
        }
        int[] funcIdAsInts = new int[functionalityIDs.length];
        for (int i = 0; i < functionalityIDs.length; ++i) {
            try {
                funcIdAsInts[i] = Integer.parseInt(functionalityIDs[i]);
                continue;
            }
            catch (ClassCastException e) {
                _log.error((Object)("Could not convert to int: " + functionalityIDs[i]));
            }
        }
        SelectedResourceDescriptionType[] selres = toSend.toArray(new SelectedResourceDescriptionType[toSend.size()]);
        System.out.println("SelectedResourceDescriptionType[] Sending to Service .... toSend size = " + toSend.size());
        for (int i = 0; i < selres.length; ++i) {
            System.out.println("SelectedResourceDescriptionType DESC: " + selres[i].getDescriptionId());
            for (int j = 0; j < selres[i].getResourceId().length; ++j) {
                System.out.println("resid= " + selres[i].getResourceId()[j]);
            }
        }
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        try {
            vreGenerator.setFunctionality(funcIdAsInts, selres);
            vreGenerator.setVREtoPendingState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new VREDefinitionException("Set functionalities Error");
        }
        return null;
    }

    private String setVREDescription(VREDescriptionBean bean) throws VREDefinitionException {
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        ASLSession d4ScienceSession = this.getASLSession();
        d4ScienceSession.setAttribute("VREName", (Object)bean.getName());
        d4ScienceSession.setAttribute(DESCRIPTION, (Object)bean.getDescription());
        d4ScienceSession.setAttribute(DESIGNER, (Object)bean.getDesigner());
        d4ScienceSession.setAttribute(MANAGER, (Object)bean.getManager());
        try {
            vreGenerator.setVREModel(bean.getName(), bean.getDescription(), bean.getDesigner(), bean.getManager(), bean.getStartTime().getTime(), bean.getEndTime().getTime());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new VREDefinitionException("Set Description Error");
        }
        return null;
    }

    public List<VRECollectionBean> getCollections() throws VREDefinitionException {
        ArrayList<VRECollectionBean> listToReturn = new ArrayList<VRECollectionBean>();
        return listToReturn;
    }

    public Map<String, Object> isEditMode() {
        String reeditType = (String)this.getASLSession().getAttribute(REEDIT_TYPE_ATTRIBUTE);
        this.getASLSession().setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
        if (reeditType != null && reeditType.equals(EDIT_MODE)) {
            VREGeneratorEvo vreGenerator = (VREGeneratorEvo)this.getASLSession().getAttribute(VRE_GENERATOR_ATTRIBUTE);
            this.getASLSession().setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, (Object)vreGenerator);
            this.getASLSession().setAttribute(REEDIT_TYPE_ATTRIBUTE, null);
            try {
                List collections = this.getCollections();
                VREFunctionalityModel functionalities = this.getFunctionality();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("collections", collections);
                map.put("functionalities", functionalities);
                return map;
            }
            catch (VREDefinitionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private VREDescriptionBean getVREInSession() throws VREDefinitionException {
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        VREDescriptionBean vreDescBean = null;
        try {
            VREDescription sd = vreGenerator.getVREModel();
            vreDescBean = new VREDescriptionBean(sd.getName(), sd.getDescription(), sd.getDesigner(), sd.getManager(), sd.getStartTime().getTime(), sd.getEndTime().getTime());
        }
        catch (RemoteException e) {
            throw new VREDefinitionException("Fail retrieve VRE");
        }
        System.out.println("Model: " + vreDescBean.getName());
        System.out.println("--- END Getting VRE Model ---");
        return vreDescBean;
    }

    public String[] getExistingNames() {
        return null;
    }
}

