/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.vredefinition.client;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.vredefinition.client.AppController;
import org.gcube.portlets.vredefinition.client.VREDefinitionServiceAsync;
import org.gcube.portlets.vredefinition.client.event.BackButtonEvent;
import org.gcube.portlets.vredefinition.client.event.ExternalResourceSelectionEvent;
import org.gcube.portlets.vredefinition.client.event.NextButtonEvent;
import org.gcube.portlets.vredefinition.client.event.TreeNodeFunctionalityEvent;
import org.gcube.portlets.vredefinition.client.event.TreeNodeWizardMenuEvent;
import org.gcube.portlets.vredefinition.client.model.VREDefinitionModel;
import org.gcube.portlets.vredefinition.client.model.VREFunctionalityModel;
import org.gcube.portlets.vredefinition.client.model.WizardStepType;
import org.gcube.portlets.vredefinition.client.presenter.Presenter;
import org.gcube.portlets.vredefinition.client.presenter.VREDefinitionPresenter;
import org.gcube.portlets.vredefinition.client.presenter.VREDescriptionPresenter;
import org.gcube.portlets.vredefinition.client.presenter.VREFinishWizardPresenter;
import org.gcube.portlets.vredefinition.client.presenter.VREFunctionalitiesPresenter;
import org.gcube.portlets.vredefinition.client.presenter.VREInfoFunctionalitiesPresenter;
import org.gcube.portlets.vredefinition.client.presenter.WizardActionsPresenter;
import org.gcube.portlets.vredefinition.client.presenter.WizardMenuViewPresenter;
import org.gcube.portlets.vredefinition.client.view.VREDefinitionView;
import org.gcube.portlets.vredefinition.client.view.VREDescriptionView;
import org.gcube.portlets.vredefinition.client.view.VREFinishWizardView;
import org.gcube.portlets.vredefinition.client.view.VREFunctionalitiesView;
import org.gcube.portlets.vredefinition.client.view.VREInfoFunctionalitiesView;
import org.gcube.portlets.vredefinition.client.view.WizardMenuView;
import org.gcube.portlets.vredefinition.shared.ExternalResourceModel;
import org.gcube.portlets.vredefinition.shared.VREDescriptionBean;

public class AppController {
    private final VREDefinitionModel vreModel = new VREDefinitionModel();
    private final HandlerManager eventBus;
    private VREDefinitionPresenter vreDefPresenter;
    private Presenter upCenterPanelPresenter;
    private WizardActionsPresenter wizardActionsPresenter;
    private WizardMenuViewPresenter wizardMenuPresenter;
    private RootPanel container;
    private HashMap<String, List<ExternalResourceModel>> funcToExternalResources = new HashMap();
    private static AppController singleton;
    private final VREDefinitionServiceAsync rpcService;

    public List<ExternalResourceModel> getExtResourcesFromApp(String funcId) {
        return (List)this.funcToExternalResources.get(funcId);
    }

    public HandlerManager getBus() {
        return this.eventBus;
    }

    public static AppController getAppController() {
        return singleton;
    }

    public AppController(VREDefinitionServiceAsync rpcService, HandlerManager eventBus) {
        singleton = this;
        this.rpcService = rpcService;
        this.eventBus = eventBus;
        this.bind();
    }

    public void go(RootPanel container) {
        this.container = container;
        VREDefinitionView mainView = new VREDefinitionView();
        this.vreDefPresenter = new VREDefinitionPresenter((VREDefinitionPresenter.Display)mainView);
        mainView.mask("Loading data ....");
        this.vreDefPresenter.go(container);
        this.updateSize();
        this.rpcService.isEditMode((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void bind() {
        this.eventBus.addHandler(ExternalResourceSelectionEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(NextButtonEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(BackButtonEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(TreeNodeWizardMenuEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(TreeNodeFunctionalityEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateSize() {
        int topBorder = this.container.getAbsoluteTop();
        int leftBorder = this.container.getAbsoluteLeft();
        int rootHeight = Window.getClientHeight() - topBorder;
        int rootWidth = Window.getClientWidth() - 2 * leftBorder;
        this.vreDefPresenter.display.asWidget().setHeight(String.valueOf(rootHeight - 40));
        this.vreDefPresenter.display.asWidget().setWidth(String.valueOf(rootWidth - 20));
        this.vreDefPresenter.display.getUpContainer().setSize(rootWidth - 25, rootHeight - 80);
        this.vreDefPresenter.display.getBottomCenterPanel().setSize(rootWidth - 25, 48);
    }

    private void goNextStepWizard() {
        if (this.upCenterPanelPresenter.doSave()) {
            this.vreModel.setNextStep();
        }
        this.goStepWizard();
    }

    private void goStepWizard() {
        WizardStepType step = this.vreModel.getWizardStep();
        this.vreDefPresenter.display.getEastPanel().setVisible(false);
        switch (10.$SwitchMap$org$gcube$portlets$vredefinition$client$model$WizardStepType[step.ordinal()]) {
            case 1: {
                this.upCenterPanelPresenter = new VREDescriptionPresenter(this.rpcService, this.vreModel, (VREDescriptionPresenter.Display)new VREDescriptionView());
                break;
            }
            case 2: {
                this.upCenterPanelPresenter = new VREFunctionalitiesPresenter(this.rpcService, this.vreModel, this.eventBus, (VREFunctionalitiesPresenter.Display)new VREFunctionalitiesView());
                VREInfoFunctionalitiesPresenter infoPresenter = new VREInfoFunctionalitiesPresenter((VREInfoFunctionalitiesPresenter.Display)new VREInfoFunctionalitiesView());
                infoPresenter.go((LayoutContainer)this.vreDefPresenter.display.getEastPanel());
                break;
            }
            case 3: {
                this.upCenterPanelPresenter = new VREFinishWizardPresenter((VREFinishWizardPresenter.Display)new VREFinishWizardView(this.vreModel.getVREDescriptionBean(), this.vreModel.getVREFunctionalities()));
                break;
            }
        }
        this.upCenterPanelPresenter.go(this.vreDefPresenter.display.getUpCenterPanel());
        this.wizardMenuPresenter = new WizardMenuViewPresenter(this.eventBus, (WizardMenuViewPresenter.Display)new WizardMenuView(this.vreModel.getWizardStepModel()));
        this.wizardMenuPresenter.go(this.vreDefPresenter.display.getwestPanel());
        this.wizardActionsPresenter.setStepWizard(step);
    }

    private void goBackStepWizard() {
        this.vreModel.setBackStep();
        this.goStepWizard();
    }

    private void showCreateVREConfirm() {
        MessageBox.confirm((String)"Confirm", (String)" The  current VRE Definition will be stored in the infrastructure waiting for approval", (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createVRE() {
        if (!this.validateVREDescription()) {
            return;
        }
        List items = this.validateVREFunctionalitiesSelected();
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<String> categoriesIDs = new ArrayList<String>();
        ArrayList<String> functionalitiesIDs = new ArrayList<String>();
        for (ModelData item : items) {
            VREFunctionalityModel func = (VREFunctionalityModel)item;
            if (func.getChildCount() > 0) {
                categoriesIDs.add(func.getId());
                continue;
            }
            functionalitiesIDs.add(func.getId());
        }
        String[] functionalities = functionalitiesIDs.toArray(new String[functionalitiesIDs.size()]);
        this.rpcService.setVRE(this.vreModel.getVREDescriptionBean(), functionalities, this.funcToExternalResources, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean validateVREDescription() {
        VREDescriptionBean bean = this.vreModel.getVREDescriptionBean();
        boolean check = true;
        if (bean.getName() == null || bean.getName().trim().isEmpty()) {
            check = false;
        }
        if (bean.getDescription() == null || bean.getDescription().trim().isEmpty()) {
            check = false;
        }
        if (bean.getDesigner() == null || bean.getDesigner().trim().isEmpty()) {
            check = false;
        }
        if (bean.getManager() == null || bean.getManager().trim().isEmpty()) {
            check = false;
        }
        if (bean.getStartTime() == null) {
            check = false;
        }
        if (bean.getEndTime() == null) {
            check = false;
        }
        if (!check) {
            this.vreModel.setWizardStep(WizardStepType.VREDescription);
            this.goStepWizard();
        }
        return check;
    }

    private List<ModelData> validateVREFunctionalitiesSelected() {
        ArrayList<ModelData> items = new ArrayList<ModelData>();
        List categories = this.vreModel.getVREFunctionalities();
        for (ModelData category : categories) {
            for (ModelData func : ((VREFunctionalityModel)category).getChildren()) {
                if (!((VREFunctionalityModel)func).isSelected()) continue;
                items.add(func);
            }
        }
        if (items.isEmpty()) {
            this.vreModel.setWizardStep(WizardStepType.VREFunctionalities);
            this.goStepWizard();
            MessageBox.alert((String)"Alert", (String)"Please, select at least one Functionality", null);
        }
        return items;
    }

    static /* synthetic */ VREDefinitionModel access$000(AppController x0) {
        return x0.vreModel;
    }

    static /* synthetic */ WizardActionsPresenter access$102(AppController x0, WizardActionsPresenter x1) {
        x0.wizardActionsPresenter = x1;
        return x0.wizardActionsPresenter;
    }

    static /* synthetic */ HandlerManager access$200(AppController x0) {
        return x0.eventBus;
    }

    static /* synthetic */ WizardActionsPresenter access$100(AppController x0) {
        return x0.wizardActionsPresenter;
    }

    static /* synthetic */ void access$300(AppController x0) {
        x0.goStepWizard();
    }

    static /* synthetic */ HashMap access$400(AppController x0) {
        return x0.funcToExternalResources;
    }

    static /* synthetic */ void access$500(AppController x0) {
        x0.showCreateVREConfirm();
    }

    static /* synthetic */ void access$600(AppController x0) {
        x0.goNextStepWizard();
    }

    static /* synthetic */ void access$700(AppController x0) {
        x0.goBackStepWizard();
    }

    static /* synthetic */ Presenter access$800(AppController x0) {
        return x0.upCenterPanelPresenter;
    }

    static /* synthetic */ VREDefinitionPresenter access$900(AppController x0) {
        return x0.vreDefPresenter;
    }

    static /* synthetic */ VREDefinitionServiceAsync access$1000(AppController x0) {
        return x0.rpcService;
    }

    static /* synthetic */ void access$1100(AppController x0) {
        x0.createVRE();
    }

    static /* synthetic */ RootPanel access$1200(AppController x0) {
        return x0.container;
    }
}

