/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.geospatial.server.servlet;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.GeospatialInfo;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.QueryGroup;
import org.gcube.application.framework.search.library.util.Point;
import org.gcube.portlets.session.client.TimeBound;
import org.gcube.portlets.user.geospatial.client.GeoSpatialService;
import org.gcube.portlets.user.geospatial.server.servlet.Logger;

public class GeoSpatialServlet
extends RemoteServiceServlet
implements GeoSpatialService {
    private static final int DEFAULT_QUERY = 0;
    private static final long serialVersionUID = 1L;

    private void storeGeoInfoInSession(GeospatialInfo geoInfo) {
        ASLSession session = this.getASLSession();
        session.setAttribute("geoInfo", (Object)geoInfo);
    }

    private GeospatialInfo getGeoInfoFromSession() {
        ASLSession session = this.getASLSession();
        if (session.getAttribute("geoInfo") == null) {
            return new GeospatialInfo();
        }
        return (GeospatialInfo)session.getAttribute("geoInfo");
    }

    public ASLSession getASLSession() {
        HttpServletRequest httpServletRequest = this.getThreadLocalRequest();
        HttpSession session = httpServletRequest.getSession();
        String user = (String)session.getAttribute("username");
        if (session.getAttribute("username") == null) {
            user = "massimiliano.assante";
        }
        return SessionManager.getInstance().getASLSession(session.getId(), user);
    }

    public Query getQuery() {
        ASLSession session = this.getASLSession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Logger.debug((String)"public Query getQuery(): ");
        return queryGroup.getQuery(0);
    }

    private String fileToString(String path) {
        BufferedReader filebuf = null;
        String nextStr = null;
        String ret = new String();
        try {
            filebuf = new BufferedReader(new FileReader(path));
            nextStr = filebuf.readLine();
            while (nextStr != null) {
                ret = ret + nextStr;
                nextStr = filebuf.readLine();
            }
            filebuf.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return ret;
    }

    public String getCountries() {
        String path = this.getServletContext().getRealPath("");
        return this.fileToString(path + "/XML/countries.xml");
    }

    public void removeSessionVars() {
        Logger.debug((String)"removeSessionVars()");
        ASLSession session = this.getASLSession();
        session.removeAttribute("timeinterval");
        session.removeAttribute("bounds");
        session.removeAttribute("relations");
        session.removeAttribute("selectedCountryId");
        Logger.debug((String)"getQuery().getGeospatial() is set null ");
        this.getQuery().setGeospatial(new GeospatialInfo());
    }

    public void storeDateBounds(TimeBound time) {
        Logger.debug((String)"Storing Date Bounds  getQuery().setGeospatial(geoInfo)");
        Logger.debug((String)("time.getStartingDate(): " + time.getStartingDate()));
        Logger.debug((String)("time.getEndingDate()" + time.getEndingDate()));
        ASLSession session = this.getASLSession();
        GeospatialInfo geoInfo = this.getGeoInfoFromSession();
        geoInfo.setStartingDate(time.getStartingDate());
        geoInfo.setEndingDate(time.getEndingDate());
        this.storeGeoInfoInSession(geoInfo);
        this.getQuery().setGeospatial(geoInfo);
        session.setAttribute("timeinterval", (Object)time);
    }

    public TimeBound getDateBounds() {
        ASLSession session = this.getASLSession();
        return (TimeBound)session.getAttribute("timeinterval");
    }

    public boolean dateBoundsIsEmpty() {
        ASLSession session = this.getASLSession();
        boolean toReturn = false;
        try {
            session.getAttribute("timeinterval").equals(null);
        }
        catch (NullPointerException e) {
            return true;
        }
        return toReturn;
    }

    public void anyTimeClicked() {
        ASLSession session = this.getASLSession();
        session.removeAttribute("timeinterval");
    }

    public String getRelations() {
        ASLSession session = this.getASLSession();
        return (String)session.getAttribute("relations");
    }

    public void storeRelations(String theRelation) {
        Logger.debug((String)"Storing Relations  getQuery().setGeospatial(geoInfo)");
        Logger.debug((String)("geoInfo.setRelation(theRelation) to: " + theRelation));
        ASLSession session = this.getASLSession();
        GeospatialInfo geoInfo = this.getGeoInfoFromSession();
        geoInfo.setRelation(theRelation);
        this.storeGeoInfoInSession(geoInfo);
        this.getQuery().setGeospatial(geoInfo);
        session.setAttribute("relations", (Object)theRelation);
    }

    public boolean relationsIsEmpty() {
        ASLSession session = this.getASLSession();
        boolean toReturn = false;
        try {
            session.getAttribute("relations").equals(null);
        }
        catch (NullPointerException e) {
            return true;
        }
        return toReturn;
    }

    public void storePointBounds(org.gcube.portlets.session.client.Point[] points) {
        ASLSession session = this.getASLSession();
        Logger.debug((String)"Storing Relations  getQuery().setGeospatial(geoInfo)");
        Logger.debug((String)("geoInfo.setBounds(Point[] points) = " + points.toString()));
        Point[] toStore = new Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            toStore[i] = new Point();
            toStore[i].setLatitude(points[i].getLatitude());
            toStore[i].setLongitude(points[i].getLongitude());
        }
        GeospatialInfo geoInfo = this.getGeoInfoFromSession();
        geoInfo.setBounds(toStore);
        this.storeGeoInfoInSession(geoInfo);
        this.getQuery().setGeospatial(geoInfo);
        session.setAttribute("bounds", (Object)points);
    }

    public org.gcube.portlets.session.client.Point[] getPointBounds() {
        ASLSession session = this.getASLSession();
        return (org.gcube.portlets.session.client.Point[])session.getAttribute("bounds");
    }

    public boolean pointBoundsIsEmpty() {
        ASLSession session = this.getASLSession();
        boolean toReturn = false;
        try {
            session.getAttribute("bounds").equals(null);
        }
        catch (NullPointerException e) {
            return true;
        }
        return toReturn;
    }

    public void storeSelectedCountryId(int id) {
        ASLSession session = this.getASLSession();
        session.setAttribute("selectedCountryId", (Object)new Integer(id));
    }

    public boolean selectedCountryIsEmpty() {
        ASLSession session = this.getASLSession();
        boolean toReturn = false;
        try {
            session.getAttribute("selectedCountryId").equals(null);
        }
        catch (NullPointerException e) {
            return true;
        }
        return toReturn;
    }

    public int getSelectedCountry() {
        ASLSession session = this.getASLSession();
        return (Integer)session.getAttribute("selectedCountryId");
    }

    public void setMapIsLoaded(boolean value) {
        System.out.println("" + value);
        ASLSession session = this.getASLSession();
        session.setAttribute("mapIsLoaded", (Object)new Boolean(value));
    }

    public Boolean isMapLoaded() {
        ASLSession session = this.getASLSession();
        Boolean toReturn = false;
        try {
            toReturn = (Boolean)session.getAttribute("mapIsLoaded");
            System.out.println("Map was loaded? " + toReturn);
        }
        catch (NullPointerException e) {
            return false;
        }
        return toReturn;
    }

    public Boolean semaphoreUnlocked() throws Exception {
        ASLSession session = this.getASLSession();
        System.out.println("****NEW**** Waiting ...session.waitNotification().....  ");
        session.waitNotification("CollectionsStatusChange");
        Query q = this.getQuery();
        return q.isGeoAvailable();
    }

    public void disableTemporary() {
        String relation = "NO Relation";
        GeospatialInfo geoInfo = this.getGeoInfoFromSession();
        if (geoInfo.getRelation() != null) {
            relation = geoInfo.getRelation();
        }
        Point[] points = new Point[]{};
        if (geoInfo.getBounds() != null) {
            points = geoInfo.getBounds();
        }
        this.getQuery().setGeospatial(new GeospatialInfo());
        Logger.debug((String)"GeospatialInfo reset OK");
    }

    public void restorePreviousState() {
        this.getQuery().setGeospatial(this.getGeoInfoFromSession());
    }
}

