/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.geospatial.client;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.mapitz.gwt.googleMaps.client.GControl;
import com.mapitz.gwt.googleMaps.client.GEventListener;
import com.mapitz.gwt.googleMaps.client.GLatLng;
import com.mapitz.gwt.googleMaps.client.GLatLngBounds;
import com.mapitz.gwt.googleMaps.client.GMap2;
import com.mapitz.gwt.googleMaps.client.GMap2EventClickListener;
import com.mapitz.gwt.googleMaps.client.GMap2EventManager;
import com.mapitz.gwt.googleMaps.client.GMap2EventMouseListener;
import com.mapitz.gwt.googleMaps.client.GMap2Widget;
import com.mapitz.gwt.googleMaps.client.GMapType;
import com.mapitz.gwt.googleMaps.client.GOverlay;
import com.mapitz.gwt.googleMaps.client.GPolyline;
import java.util.Vector;
import org.gcube.portlets.session.client.Point;
import org.gcube.portlets.user.geospatial.client.Geospatial;
import org.gcube.portlets.user.geospatial.client.GoogleMap;

public class GoogleMap
extends Composite
implements GMap2EventClickListener,
GMap2EventMouseListener {
    private GMap2Widget mapWidget = null;
    private GMap2 gmaps = null;
    private GMap2EventManager eventManager = null;
    GEventListener onClickListener = null;
    GEventListener onMouseMove = null;
    private Vector points = new Vector();
    private GLatLng[] rectVerteces = new GLatLng[5];
    boolean startingClick = true;
    boolean waitingSecondClick = false;
    boolean selection = false;
    boolean clicked = false;
    private int type = -1;
    private double distFromVertex = 0.0;
    private Timer timer = new /* Unavailable Anonymous Inner Class!! */;

    public GoogleMap() {
        this.mapWidget = new GMap2Widget("190", "275");
        this.gmaps = this.mapWidget.getGmap();
        this.gmaps.addControl(GControl.GMapTypeControl());
        this.gmaps.addControl(GControl.GLargeMapControl());
        GLatLng pos = new GLatLng(40.0, -5.0);
        this.gmaps.setCenter(pos);
        this.gmaps.enableDoubleClickZoom();
        this.gmaps.setZoom(1);
        this.gmaps.setMapType(GMapType.G_HYBRID_MAP());
        this.gmaps.panTo(pos);
        this.eventManager = GMap2EventManager.getInstance();
        this.onClickListener = this.eventManager.addOnClickListener(this.gmaps, (GMap2EventClickListener)this);
        this.onMouseMove = this.eventManager.addOnMouseMoveListener(this.gmaps, (GMap2EventMouseListener)this);
        this.initWidget((Widget)this.mapWidget);
        this.clearMap();
    }

    public void adjustSize(int width, int height) {
        this.mapWidget.setPixelSize(width, height);
        GLatLng pos = new GLatLng(40.0, -5.0);
        this.gmaps.setCenter(pos);
        this.gmaps.setZoom(1);
    }

    protected void clearMap() {
        this.gmaps.clearOverlays();
        this.points.clear();
        GLatLng pos = new GLatLng(40.0, -5.0);
        this.gmaps.setCenter(pos);
        this.gmaps.enableDoubleClickZoom();
        this.gmaps.setZoom(1);
    }

    protected void paintRectangle(double north, double south, double east, double west) {
        GLatLng[] rect;
        this.gmaps.clearOverlays();
        this.points.clear();
        rect = new GLatLng[]{new GLatLng(north, west), new GLatLng(north, east), new GLatLng(south, east), new GLatLng(south, west), rect[0]};
        this.gmaps.addOverlay((GOverlay)new GPolyline(rect, "#ff0000", 2));
        double centerLat = south + (north - south) / 2.0;
        double centerLng = west + (east - west) / 2.0;
        GLatLng center = new GLatLng(centerLat, centerLng);
        GLatLngBounds bounds = new GLatLngBounds(rect[3], rect[1]);
        int zoomLevel = this.gmaps.getBoundsZoomLevel(bounds);
        this.gmaps.setCenter(center, zoomLevel);
        this.gmaps.enableDragging();
        this.gmaps.disableDragging();
        2 storeCallback = new /* Unavailable Anonymous Inner Class!! */;
        Point[] points = new Point[rect.length];
        for (int i = 0; i < rect.length; ++i) {
            points[i] = new Point(rect[i].lat(), rect[i].lng());
        }
        Geospatial.geoSpatialService.storePointBounds(points, (AsyncCallback)storeCallback);
    }

    public void createSelectionArea(int type) {
        this.type = type;
        this.selection = true;
        this.gmaps.disableDoubleClickZoom();
        this.gmaps.disableContinuousZoom();
        this.gmaps.disableDragging();
    }

    public void panMethod() {
        this.gmaps.enableDoubleClickZoom();
        this.gmaps.enableContinuousZoom();
        this.gmaps.enableDragging();
        this.selection = false;
    }

    public int getGmapHeight() {
        return this.gmaps.getSize().getHeight();
    }

    private void updateTextBox() {
        double maxLat = 0.0;
        double minLat = 0.0;
        double maxLng = 0.0;
        double minLng = 0.0;
        int size = this.points.size();
        for (int i = 0; i < size - 1; ++i) {
            double lat = ((GLatLng)this.points.elementAt(i)).lat();
            double lng = ((GLatLng)this.points.elementAt(i)).lng();
            if (i == 0) {
                maxLat = lat;
                minLat = lat;
                maxLng = lng;
                minLng = lng;
                continue;
            }
            if (maxLat < lat) {
                maxLat = lat;
            } else if (minLat > lat) {
                minLat = lat;
            }
            if (maxLng < lng) {
                maxLng = lng;
                continue;
            }
            if (!(minLng > lng)) continue;
            minLng = lng;
        }
        Geospatial.get().setTextBoxes(maxLat, minLat, maxLng, minLng);
        double centerLat = minLat + (maxLat - minLat) / 2.0;
        double centerLng = minLng + (maxLng - minLng) / 2.0;
        GLatLng center = new GLatLng(centerLat, centerLng);
        GLatLng sw = new GLatLng(minLat, minLng);
        GLatLng ne = new GLatLng(maxLat, maxLng);
        GLatLngBounds bounds = new GLatLngBounds(sw, ne);
        int zoomLevel = this.gmaps.getBoundsZoomLevel(bounds);
        this.gmaps.setCenter(center, zoomLevel);
        this.gmaps.enableDragging();
        this.gmaps.disableDragging();
    }

    protected void paintPoligon(GLatLng point) {
        this.points.add(point);
        int size = this.points.size();
        if (size > 1) {
            this.gmaps.clearOverlays();
            GLatLng[] aux = new GLatLng[size];
            for (int i = 0; i < size; ++i) {
                aux[i] = (GLatLng)this.points.elementAt(i);
            }
            this.gmaps.addOverlay((GOverlay)new GPolyline(aux, "#ff0000", 2));
        }
    }

    protected void drawSelection(GLatLng[] points) {
        this.gmaps.addOverlay((GOverlay)new GPolyline(points, "#ff0000", 2));
        this.points = new Vector();
        for (int i = 0; i < points.length; ++i) {
            this.points.add(points[i]);
        }
        this.updateTextBox();
    }

    public void onClick(GMap2 map, GOverlay overlay, GLatLng point) {
        if (this.selection) {
            Point[] sessionPoints;
            if (this.startingClick) {
                this.gmaps.clearOverlays();
                this.points.clear();
                this.startingClick = false;
                if (this.type == 0) {
                    this.paintPoligon(point);
                }
            } else if (this.type == 0) {
                this.startingClick = true;
                for (int i = 1; i < 4; ++i) {
                    this.points.add(i, this.rectVerteces[i]);
                }
                this.paintPoligon((GLatLng)this.points.elementAt(0));
                sessionPoints = new Point[this.rectVerteces.length];
                for (int i = 0; i < this.rectVerteces.length; ++i) {
                    sessionPoints[i] = new Point(this.rectVerteces[i].lat(), this.rectVerteces[i].lng());
                }
                3 storeCallback = new /* Unavailable Anonymous Inner Class!! */;
                Geospatial.geoSpatialService.storePointBounds(sessionPoints, (AsyncCallback)storeCallback);
            }
            if (this.waitingSecondClick) {
                this.waitingSecondClick = false;
                this.startingClick = true;
                if (this.type == 1) {
                    this.paintPoligon((GLatLng)this.points.elementAt(0));
                    sessionPoints = new Point[this.points.size()];
                    for (int i = 0; i < this.points.size(); ++i) {
                        sessionPoints[i] = new Point(((GLatLng)this.points.elementAt(i)).lat(), ((GLatLng)this.points.elementAt(i)).lng());
                    }
                    4 storeCallback = new /* Unavailable Anonymous Inner Class!! */;
                    Geospatial.geoSpatialService.storePointBounds(sessionPoints, (AsyncCallback)storeCallback);
                }
            } else {
                if (this.type == 1) {
                    double divideBy = this.gmaps.getZoom();
                    if (divideBy > 6.0) {
                        divideBy *= 2.0;
                    }
                    if (divideBy > 8.0) {
                        divideBy *= 5.0;
                    }
                    boolean positioner_x = true;
                    boolean positioner_y = true;
                    double distFromVertex = 2.6999999999999997 / divideBy;
                    this.paintPoligon(new GLatLng(point.lat() + distFromVertex * (double)positioner_y, point.lng() - distFromVertex * (double)positioner_x));
                }
                this.waitingSecondClick = true;
                this.timer.schedule(450);
            }
        }
    }

    public void onMouseMove(GMap2 map, GLatLng latLng) {
        if (this.selection) {
            int size = this.points.size();
            if (this.type == 1) {
                if (size >= 1 && !this.startingClick) {
                    double divideBy = this.gmaps.getZoom();
                    if (divideBy > 6.0) {
                        divideBy *= 2.0;
                    }
                    if (divideBy > 8.0) {
                        divideBy *= 5.0;
                    }
                    int positioner_x = 1;
                    if (latLng.lng() < ((GLatLng)this.points.elementAt(0)).lng()) {
                        positioner_x = -1;
                    }
                    int positioner_y = 1;
                    if (latLng.lat() > ((GLatLng)this.points.elementAt(0)).lat()) {
                        positioner_y = -1;
                    }
                    this.distFromVertex = 2.6999999999999997 / divideBy;
                    this.gmaps.clearOverlays();
                    GLatLng[] aux = new GLatLng[size];
                    for (int i = 0; i < size; ++i) {
                        aux[i] = (GLatLng)this.points.elementAt(i);
                    }
                    this.gmaps.addOverlay((GOverlay)new GPolyline(aux, "#ff0000", 2));
                    GLatLng[] aux2 = new GLatLng[]{(GLatLng)this.points.elementAt(size - 1), new GLatLng(latLng.lat() + this.distFromVertex * (double)positioner_y, latLng.lng() - this.distFromVertex * (double)positioner_x), (GLatLng)this.points.elementAt(0)};
                    this.gmaps.addOverlay((GOverlay)new GPolyline(aux2, "#ffaaaa", 2));
                    System.out.println(this.gmaps.getZoom());
                }
            } else if (this.type == 0 && !this.startingClick) {
                this.gmaps.clearOverlays();
                this.rectVerteces[0] = (GLatLng)this.points.elementAt(0);
                this.rectVerteces[4] = (GLatLng)this.points.elementAt(0);
                double divideBy = this.gmaps.getZoom();
                if (divideBy > 6.0) {
                    divideBy *= 3.0;
                }
                if (divideBy > 8.0) {
                    divideBy *= 6.0;
                }
                this.distFromVertex = 2.6999999999999997 / divideBy;
                int positioner_x = 1;
                if (latLng.lng() < this.rectVerteces[0].lng()) {
                    positioner_x = -1;
                }
                int positioner_y = 1;
                if (latLng.lat() > this.rectVerteces[0].lat()) {
                    positioner_y = -1;
                }
                this.rectVerteces[2] = new GLatLng(latLng.lat() + this.distFromVertex * (double)positioner_y, latLng.lng() - this.distFromVertex * (double)positioner_x);
                this.rectVerteces[1] = new GLatLng(this.rectVerteces[0].lat(), this.rectVerteces[2].lng());
                this.rectVerteces[3] = new GLatLng(this.rectVerteces[2].lat(), this.rectVerteces[0].lng());
                System.out.println(this.gmaps.getZoom() + "-" + this.rectVerteces[0].lng() + " - " + latLng.lng());
                this.gmaps.addOverlay((GOverlay)new GPolyline(this.rectVerteces, "#ffaaaa", 2));
            }
        }
    }

    public void onMouseOut(GMap2 map, GLatLng latlng) {
    }

    public void onMouseOver(GMap2 map, GLatLng latlng) {
    }

    public GMap2 getGmaps() {
        return this.gmaps;
    }

    static /* synthetic */ void access$000(GoogleMap x0) {
        x0.updateTextBox();
    }
}

