/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.geospatial.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapter;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapterException;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusListener;
import net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.PersonJsonizer;
import net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.SubscriberData;
import org.gcube.portlets.user.gcubewidgets.client.GCubePanel;
import org.gcube.portlets.user.geospatial.client.CountryList;
import org.gcube.portlets.user.geospatial.client.DatePanel;
import org.gcube.portlets.user.geospatial.client.GeoSpatialCostants;
import org.gcube.portlets.user.geospatial.client.GeoSpatialService;
import org.gcube.portlets.user.geospatial.client.GeoSpatialServiceAsync;
import org.gcube.portlets.user.geospatial.client.Geospatial;
import org.gcube.portlets.user.geospatial.client.GoogleMap;
import org.gcube.portlets.user.geospatial.client.MapContainer;
import org.jsonmaker.gwt.client.Jsonizer;

public class Geospatial
implements EntryPoint {
    public static GeoSpatialServiceAsync geoSpatialService = (GeoSpatialServiceAsync)GWT.create(GeoSpatialService.class);
    private static ServiceDefTarget endpoint = (ServiceDefTarget)geoSpatialService;
    private static Geospatial singleton = null;
    RadioButton inside = new RadioButton("relation");
    RadioButton intersects = new RadioButton("relation");
    RadioButton contains = new RadioButton("relation");
    private HTML gif4Height = new HTML(GeoSpatialCostants.NONE_IMAGE, true);
    private HorizontalPanel titlePanel = new HorizontalPanel();
    private GCubePanel geoVerticalPanel = new GCubePanel("Geo Coordinates", "https://technical.wiki.d4science.research-infrastructures.eu/documentation/index.php/Common_Functionality#Geospatial_Search");
    private CellPanel bottomPanel = new HorizontalPanel();
    private HorizontalPanel listBoxHorizontalPanel = new HorizontalPanel();
    private CountryList countryListBox = null;
    public ShadowPanel backgroundDlg = new ShadowPanel(this);
    private DatePanel datePanel = null;
    protected MapContainer mapContainer = new MapContainer();
    private HorizontalPanel selectionTool = new HorizontalPanel();
    protected HTML pan = new HTML(GeoSpatialCostants.PAN_IMAGE);
    private HTML rectangular = new HTML(GeoSpatialCostants.RECTANGULAR_IMAGE);
    private HTML polygon = new HTML(GeoSpatialCostants.POLYGON_IMAGE);
    private HTML reset = new HTML(GeoSpatialCostants.RESET_IMAGE);
    private VerticalPanel nestedVerticalPanel = new VerticalPanel();
    protected GoogleMap googleMap;
    private boolean enableRelationPanel = false;
    private boolean mapIsOpen = false;
    private HorizontalPanel gridHorizontalInnerPanel = new HorizontalPanel();
    private CellPanel cellPanel = new VerticalPanel();
    private TextBox lat_TR = new TextBox();
    private TextBox lon_TR = new TextBox();
    private TextBox lat_BL = new TextBox();
    private TextBox lon_BL = new TextBox();
    private HTML acceptingCoordRightTop = new HTML();
    private HTML acceptingCoordBottomLeftt = new HTML();
    private Button enableMapButton = new Button("Apply");
    ClickHandler textListener = new /* Unavailable Anonymous Inner Class!! */;
    ChangeHandler textBoxesListener = new /* Unavailable Anonymous Inner Class!! */;
    ClickHandler coordApplier = new /* Unavailable Anonymous Inner Class!! */;

    public static Geospatial get() {
        return singleton;
    }

    public GoogleMap getGoogleMap() {
        return this.googleMap;
    }

    public void setTextBoxes(double maxLat, double minLat, double maxLng, double minLng) {
        this.lat_TR.setText(this.approximate("" + maxLat));
        this.lon_TR.setText(this.approximate("" + maxLng));
        this.lat_BL.setText(this.approximate("" + minLat));
        this.lon_BL.setText(this.approximate("" + minLng));
    }

    public void onModuleLoad() {
        singleton = this;
        String sessionID = Cookies.getCookie((String)"JSESSIONID");
        endpoint.setServiceEntryPoint(GeoSpatialCostants.SERVLET_URL + ";jsessionid=" + sessionID);
        this.datePanel = new DatePanel();
        this.countryListBox = new CountryList();
        PageBusAdapter pageBusAdapter = new PageBusAdapter();
        SubscriberData subscriberData = new SubscriberData();
        subscriberData.setHeader("myHeader");
        subscriberData.setBody("myHeader");
        try {
            pageBusAdapter.PageBusSubscribe("net.eliasbalasis.tibcopagebus4gwt.testsubscriber.client.Person", null, null, (Object)subscriberData, (Jsonizer)GWT.create(PersonJsonizer.class));
        }
        catch (PageBusAdapterException e) {
            Window.alert((String)("Geospatial Portlet cannot subscribe to events" + e.toString()));
            e.printStackTrace();
        }
        this.enablePortlet(true);
        pageBusAdapter.addPageBusSubscriptionCallbackListener((PageBusListener)new /* Unavailable Anonymous Inner Class!! */);
        2 checkMapCallback = new /* Unavailable Anonymous Inner Class!! */;
        geoSpatialService.isMapLoaded((AsyncCallback)checkMapCallback);
        this.backgroundDlg.setStyleName("backgroundPanel");
        this.backgroundDlg.setAnimationEnabled(true);
        this.backgroundDlg.setPopupPosition(RootPanel.get((String)"GeoSpatialDIV").getAbsoluteLeft(), RootPanel.get((String)"GeoSpatialDIV").getAbsoluteTop());
        this.pan.setStyleName("icon-NotSelected");
        this.polygon.setStyleName("icon-NotSelected");
        this.rectangular.setStyleName("icon-NotSelected");
        this.pan.setTitle("Pan Tool");
        this.pan.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.rectangular.setTitle("Rectangular Selection Tool");
        this.rectangular.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.polygon.setTitle("Polygon Selection Tool");
        this.polygon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectionTool.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.selectionTool.setSpacing(4);
        this.selectionTool.add((Widget)this.pan);
        this.selectionTool.add((Widget)this.rectangular);
        this.selectionTool.add((Widget)this.polygon);
        this.listBoxHorizontalPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.listBoxHorizontalPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.listBoxHorizontalPanel.setSpacing(4);
        this.listBoxHorizontalPanel.add((Widget)this.countryListBox);
        this.listBoxHorizontalPanel.add((Widget)this.selectionTool);
        HorizontalPanel underHeaderPanel = new HorizontalPanel();
        underHeaderPanel.add((Widget)this.listBoxHorizontalPanel);
        HorizontalPanel resetPanel = new HorizontalPanel();
        resetPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        resetPanel.add((Widget)this.reset);
        resetPanel.setSpacing(4);
        resetPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        underHeaderPanel.setWidth("100%");
        underHeaderPanel.add((Widget)resetPanel);
        underHeaderPanel.setCellHorizontalAlignment((Widget)resetPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        underHeaderPanel.setCellWidth((Widget)this.listBoxHorizontalPanel, "76%");
        underHeaderPanel.setCellWidth((Widget)resetPanel, "24%");
        this.reset.setStyleName("icon-NotSelected");
        underHeaderPanel.setCellVerticalAlignment((Widget)resetPanel, HasVerticalAlignment.ALIGN_MIDDLE);
        underHeaderPanel.setHeight("24px");
        this.lat_TR.setStyleName("geospatial-gridTextBox-TR ");
        this.lat_BL.setStyleName("geospatial-gridTextBox-BL");
        this.lon_BL.setStyleName("geospatial-gridTextBox-BL");
        this.lon_TR.setStyleName("geospatial-gridTextBox-TR ");
        this.lat_TR.addChangeHandler(this.textBoxesListener);
        this.lat_BL.addChangeHandler(this.textBoxesListener);
        this.lon_BL.addChangeHandler(this.textBoxesListener);
        this.lon_TR.addChangeHandler(this.textBoxesListener);
        this.lat_TR.setMaxLength(7);
        this.lat_TR.setVisibleLength(7);
        this.lat_TR.setText("90");
        this.lat_TR.addClickHandler(this.textListener);
        this.lon_TR.setMaxLength(7);
        this.lon_TR.setVisibleLength(7);
        this.lon_TR.setText("180");
        this.lon_TR.addClickHandler(this.textListener);
        this.lat_BL.setMaxLength(7);
        this.lat_BL.setVisibleLength(7);
        this.lat_BL.setText("-90");
        this.lat_BL.addClickHandler(this.textListener);
        this.lon_BL.setMaxLength(7);
        this.lon_BL.setVisibleLength(7);
        this.lon_BL.setText("-180");
        this.lon_BL.addClickHandler(this.textListener);
        HorizontalPanel firstRow = new HorizontalPanel();
        HorizontalPanel left = new HorizontalPanel();
        HorizontalPanel right = new HorizontalPanel();
        left.add((Widget)new HTML(GeoSpatialCostants.GEO_SELECTION));
        left.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
        right.add((Widget)this.lon_TR);
        right.add((Widget)this.lat_TR);
        right.add((Widget)this.acceptingCoordRightTop);
        right.setSpacing(2);
        firstRow.add((Widget)left);
        firstRow.add((Widget)right);
        HorizontalPanel secondRow = new HorizontalPanel();
        secondRow.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        secondRow.add((Widget)new HTML(GeoSpatialCostants.LON_LAT));
        secondRow.setWidth("100%");
        HorizontalPanel thirdRow = new HorizontalPanel();
        HorizontalPanel left2 = new HorizontalPanel();
        HorizontalPanel right2 = new HorizontalPanel();
        left2.add((Widget)this.lon_BL);
        left2.add((Widget)this.lat_BL);
        right2.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        right2.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
        right2.add((Widget)this.acceptingCoordBottomLeftt);
        left2.setSpacing(2);
        thirdRow.add((Widget)left2);
        thirdRow.add((Widget)right2);
        HorizontalPanel fourthRow = new HorizontalPanel();
        fourthRow.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        fourthRow.add((Widget)this.enableMapButton);
        fourthRow.setWidth("100%");
        this.cellPanel.add((Widget)firstRow);
        this.cellPanel.add((Widget)secondRow);
        this.cellPanel.add((Widget)thirdRow);
        this.cellPanel.add((Widget)fourthRow);
        this.enableMapButton.setEnabled(false);
        this.enableMapButton.setStyleName("calendarIcon");
        this.enableMapButton.setTitle("Use manual latitude and longitude");
        this.gridHorizontalInnerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.gridHorizontalInnerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.gridHorizontalInnerPanel.add((Widget)this.cellPanel);
        this.gridHorizontalInnerPanel.setSpacing(1);
        this.enableMapButton.addClickHandler(this.coordApplier);
        this.nestedVerticalPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.nestedVerticalPanel.setWidth("100%");
        this.nestedVerticalPanel.add((Widget)this.mapContainer);
        this.bottomPanel.setWidth("100%");
        this.bottomPanel.setSpacing(8);
        VerticalPanel rightBottomPanel = new VerticalPanel();
        VerticalPanel centerBottomPanel = new VerticalPanel();
        centerBottomPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        rightBottomPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        centerBottomPanel.add((Widget)this.gridHorizontalInnerPanel);
        centerBottomPanel.setWidth("100%");
        rightBottomPanel.setWidth("100%");
        rightBottomPanel.add((Widget)this.datePanel);
        if (this.enableRelationPanel) {
            HorizontalPanel leftBottomPanel = this.enableRelationsPanel();
            this.bottomPanel.add((Widget)leftBottomPanel);
            this.bottomPanel.add((Widget)centerBottomPanel);
            this.bottomPanel.add((Widget)rightBottomPanel);
            this.bottomPanel.setCellWidth((Widget)leftBottomPanel, "23%");
            this.bottomPanel.setCellWidth((Widget)centerBottomPanel, "33%");
            this.bottomPanel.setCellWidth((Widget)rightBottomPanel, "43%");
        } else {
            this.bottomPanel.add((Widget)centerBottomPanel);
            this.bottomPanel.add((Widget)rightBottomPanel);
            this.bottomPanel.setCellWidth((Widget)centerBottomPanel, "50%");
            this.bottomPanel.setCellWidth((Widget)rightBottomPanel, "50%");
        }
        this.nestedVerticalPanel.add((Widget)this.bottomPanel);
        this.nestedVerticalPanel.setSpacing(0);
        this.nestedVerticalPanel.setSize("100%", "100%");
        this.geoVerticalPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.geoVerticalPanel.add((Widget)this.titlePanel);
        this.geoVerticalPanel.add((Widget)underHeaderPanel);
        this.geoVerticalPanel.add((Widget)this.nestedVerticalPanel);
        this.titlePanel.setWidth("100%");
        this.titlePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.titlePanel.add((Widget)this.gif4Height);
        RootPanel.get((String)"GeoSpatialDIV").add((Widget)this.geoVerticalPanel);
        if (this.mapIsOpen) {
            this.googleMap.setStyleName("addBorder");
            int mapWidth = RootPanel.get((String)"GeoSpatialDIV").getOffsetWidth() - 30;
            int mapHeight = mapWidth * 11 / 16;
            this.googleMap.adjustSize(mapWidth, mapHeight);
        }
        this.geoVerticalPanel.setSize("100%", "590px");
        this.geoVerticalPanel.setHeight("590px");
        this.backgroundDlg.backgroundPanel.setPixelSize(RootPanel.get((String)"GeoSpatialDIV").getOffsetWidth(), 590);
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.reset.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void resizePortlet() {
        int gridHorizontalWidth = this.lat_TR.getOffsetWidth() + this.gridHorizontalInnerPanel.getSpacing() * 2;
        int gridHorizontalHeight = this.lat_TR.getOffsetHeight() + this.gridHorizontalInnerPanel.getSpacing() * 2;
        this.gridHorizontalInnerPanel.setPixelSize(gridHorizontalWidth, gridHorizontalHeight);
        int mapWidth = RootPanel.get((String)"GeoSpatialDIV").getOffsetWidth() - 100;
        int mapHeight = mapWidth * 10 / 16;
        if (this.mapIsOpen) {
            this.googleMap.adjustSize(mapWidth, mapHeight);
        } else {
            this.mapContainer.getMapImg().setPixelSize(mapWidth, mapHeight);
        }
        this.geoVerticalPanel.setPixelSize(Window.getClientWidth() / 3, 590);
        this.geoVerticalPanel.setWidth("100%");
        this.geoVerticalPanel.setHeight("590px");
        this.backgroundDlg.backgroundPanel.setPixelSize(this.geoVerticalPanel.getOffsetWidth(), this.geoVerticalPanel.getOffsetHeight());
    }

    private void updateMap() {
        double left = Double.valueOf(this.lon_BL.getText());
        double top = Double.valueOf(this.lat_TR.getText());
        double right = Double.valueOf(this.lon_TR.getText());
        double bottom = Double.valueOf(this.lat_BL.getText());
        this.googleMap.paintRectangle(top, bottom, right, left);
    }

    private void setSelectedInSession(String theRelationName) {
        9 getSessionCallback = new /* Unavailable Anonymous Inner Class!! */;
        geoSpatialService.storeRelations(theRelationName, (AsyncCallback)getSessionCallback);
    }

    public void restoreVarsFromSession() throws Exception {
        10 getPointsCallback = new /* Unavailable Anonymous Inner Class!! */;
        11 checkPboundsCallback = new /* Unavailable Anonymous Inner Class!! */;
        geoSpatialService.pointBoundsIsEmpty((AsyncCallback)checkPboundsCallback);
        12 getRelationsCallback = new /* Unavailable Anonymous Inner Class!! */;
        13 checkRelationsCallback = new /* Unavailable Anonymous Inner Class!! */;
        geoSpatialService.relationsIsEmpty((AsyncCallback)checkRelationsCallback);
        14 getDatesCallback = new /* Unavailable Anonymous Inner Class!! */;
        15 checkDatesCallback = new /* Unavailable Anonymous Inner Class!! */;
        geoSpatialService.dateBoundsIsEmpty((AsyncCallback)checkDatesCallback);
        16 getCountryCallback = new /* Unavailable Anonymous Inner Class!! */;
        17 checkCountryCallback = new /* Unavailable Anonymous Inner Class!! */;
        geoSpatialService.selectedCountryIsEmpty((AsyncCallback)checkCountryCallback);
    }

    public boolean isMapIsOpen() {
        return this.mapIsOpen;
    }

    public void setMapIsOpen(boolean mapIsOpen) {
        this.mapIsOpen = mapIsOpen;
    }

    public void disableMap() {
        this.mapIsOpen = false;
        if (this.googleMap == null) {
            this.googleMap = new GoogleMap();
        }
        this.mapContainer.disableGoogleMAP(this.googleMap);
    }

    public void enableMapIfNeeded() {
        this.enableMapButton.setEnabled(true);
        if (!this.mapIsOpen) {
            18 setMapCallback = new /* Unavailable Anonymous Inner Class!! */;
            geoSpatialService.setMapIsLoaded(true, (AsyncCallback)setMapCallback);
        }
    }

    public void enablePortlet(boolean available) {
        this.backgroundDlg.setStyleName("backgroundPanel");
        if (!available) {
            this.disableMap();
            this.lat_TR.setEnabled(false);
            this.lon_TR.setEnabled(false);
            this.lat_BL.setEnabled(false);
            this.lon_BL.setEnabled(false);
            this.datePanel.radioAnyTime.setEnabled(false);
            this.datePanel.radioCalendar.setEnabled(false);
            this.countryListBox.setEnabled(false);
            this.backgroundDlg.show();
            19 callback = new /* Unavailable Anonymous Inner Class!! */;
            geoSpatialService.disableTemporary((AsyncCallback)callback);
        } else {
            this.backgroundDlg.hide();
            this.lat_TR.setEnabled(true);
            this.lon_TR.setEnabled(true);
            this.lat_BL.setEnabled(true);
            this.lon_BL.setEnabled(true);
            this.datePanel.radioAnyTime.setEnabled(true);
            this.datePanel.radioCalendar.setEnabled(true);
            this.countryListBox.setEnabled(true);
            this.enableMapIfNeeded();
            20 callback = new /* Unavailable Anonymous Inner Class!! */;
            geoSpatialService.restorePreviousState((AsyncCallback)callback);
        }
    }

    public HorizontalPanel enableRelationsPanel() {
        HorizontalPanel leftBottomPanel = new HorizontalPanel();
        VerticalPanel radioPanel = new VerticalPanel();
        radioPanel.setWidth("70%");
        radioPanel.setSpacing(4);
        radioPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.inside.setTitle("returns all elements whose area completely covers the query area");
        this.intersects.setTitle("returns all elements whose area overlaps any part of the query area");
        this.contains.setTitle("returns all elements whose area is completely covered by the query area");
        HTML selectedArea = new HTML("Query area<br>");
        radioPanel.add((Widget)selectedArea);
        HorizontalPanel h1 = new HorizontalPanel();
        h1.add((Widget)this.inside);
        HTML insideText = new HTML("inside");
        insideText.setTitle("returns all elements whose area completely covers the query area");
        h1.add((Widget)insideText);
        HorizontalPanel h2 = new HorizontalPanel();
        h2.add((Widget)this.intersects);
        HTML intersectText = new HTML("intersects");
        intersectText.setTitle("returns all elements whose area overlaps any part of the query area");
        h2.add((Widget)intersectText);
        HorizontalPanel h3 = new HorizontalPanel();
        h3.add((Widget)this.contains);
        HTML containsText = new HTML("contains");
        containsText.setTitle("returns all elements whose area is completely covered by the query area");
        h3.add((Widget)containsText);
        this.contains.setChecked(true);
        this.setSelectedInSession("contains");
        radioPanel.add((Widget)h1);
        radioPanel.add((Widget)h2);
        radioPanel.add((Widget)h3);
        leftBottomPanel.add((Widget)radioPanel);
        this.inside.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.intersects.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.contains.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return leftBottomPanel;
    }

    private String approximate(String texttoApprox) {
        String checkedText = texttoApprox.replaceAll("[^0-9\\-.]", "");
        if (checkedText.indexOf(".") >= 0) {
            checkedText = checkedText + "aaa";
            int n = checkedText.indexOf(".");
            n += 4;
            checkedText = checkedText.substring(0, checkedText.indexOf(".") + 4);
        }
        return checkedText.replaceAll("[^0-9\\-.]", "");
    }

    static /* synthetic */ boolean access$002(Geospatial x0, boolean x1) {
        x0.mapIsOpen = x1;
        return x0.mapIsOpen;
    }

    static /* synthetic */ HTML access$100(Geospatial x0) {
        return x0.polygon;
    }

    static /* synthetic */ HTML access$200(Geospatial x0) {
        return x0.rectangular;
    }

    static /* synthetic */ TextBox access$300(Geospatial x0) {
        return x0.lat_TR;
    }

    static /* synthetic */ HorizontalPanel access$400(Geospatial x0) {
        return x0.gridHorizontalInnerPanel;
    }

    static /* synthetic */ boolean access$000(Geospatial x0) {
        return x0.mapIsOpen;
    }

    static /* synthetic */ GCubePanel access$500(Geospatial x0) {
        return x0.geoVerticalPanel;
    }

    static /* synthetic */ Button access$600(Geospatial x0) {
        return x0.enableMapButton;
    }

    static /* synthetic */ CountryList access$700(Geospatial x0) {
        return x0.countryListBox;
    }

    static /* synthetic */ DatePanel access$800(Geospatial x0) {
        return x0.datePanel;
    }

    static /* synthetic */ void access$900(Geospatial x0) {
        x0.resizePortlet();
    }

    static /* synthetic */ String access$1000(Geospatial x0, String x1) {
        return x0.approximate(x1);
    }

    static /* synthetic */ TextBox access$1100(Geospatial x0) {
        return x0.lon_TR;
    }

    static /* synthetic */ HTML access$1200(Geospatial x0) {
        return x0.acceptingCoordRightTop;
    }

    static /* synthetic */ TextBox access$1300(Geospatial x0) {
        return x0.lat_BL;
    }

    static /* synthetic */ TextBox access$1400(Geospatial x0) {
        return x0.lon_BL;
    }

    static /* synthetic */ HTML access$1500(Geospatial x0) {
        return x0.acceptingCoordBottomLeftt;
    }

    static /* synthetic */ void access$1600(Geospatial x0) {
        x0.updateMap();
    }
}

