/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.geospatial.client;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ChangeListenerCollection;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.gcube.portlets.user.geospatial.client.CalendarWidget;

public class CalendarWidget
extends DialogBox
implements ClickListener,
SourcesChangeEvents {
    private final NavBar navbar = new NavBar(this, this);
    private final DockPanel outer = new DockPanel();
    private final Grid grid = new /* Unavailable Anonymous Inner Class!! */;
    private Date date = new Date();
    private ChangeListenerCollection changeListeners;
    private String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public CalendarWidget() {
        this.setWidget((Widget)this.outer);
        this.grid.setStyleName("table");
        this.grid.setCellSpacing(0);
        this.outer.add((Widget)this.navbar, DockPanel.NORTH);
        this.outer.add((Widget)this.grid, DockPanel.CENTER);
        this.drawCalendar();
        this.setStyleName("CalendarWidget");
    }

    public CalendarWidget(Date startingDate) {
        this.date = startingDate;
        this.setWidget((Widget)this.outer);
        this.grid.setStyleName("table");
        this.grid.setCellSpacing(0);
        this.outer.add((Widget)this.navbar, DockPanel.NORTH);
        this.outer.add((Widget)this.grid, DockPanel.CENTER);
        this.drawCalendar();
        this.setStyleName("CalendarWidget");
    }

    private void drawCalendar() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        this.setHeaderText(year, month);
        this.grid.getRowFormatter().setStyleName(0, "weekheader");
        for (int i = 0; i < this.days.length; ++i) {
            this.grid.getCellFormatter().setStyleName(0, i, "days");
            this.grid.setText(0, i, this.days[i].substring(0, 3));
        }
        Date now = new Date();
        int sameDay = now.getDate();
        int today = now.getMonth() == month && now.getYear() + 1900 == year ? sameDay : 0;
        int firstDay = new Date(year - 1900, month, 1).getDay();
        int numOfDays = this.getDaysInMonth(year, month);
        int j = 0;
        for (int i = 1; i < 6; ++i) {
            int k = 0;
            while (k < 7) {
                int displayNum = j - firstDay + 1;
                if (j < firstDay || displayNum > numOfDays) {
                    this.grid.getCellFormatter().setStyleName(i, k, "empty");
                    this.grid.setHTML(i, k, "&nbsp;");
                } else {
                    CellHTML html = new CellHTML("<span>" + String.valueOf(displayNum) + "</span>", displayNum);
                    html.addClickListener((ClickListener)this);
                    this.grid.getCellFormatter().setStyleName(i, k, "cell");
                    if (displayNum == today) {
                        this.grid.getCellFormatter().addStyleName(i, k, "today");
                    } else if (displayNum == sameDay) {
                        this.grid.getCellFormatter().addStyleName(i, k, "day");
                    }
                    this.grid.setWidget(i, k, (Widget)html);
                }
                ++k;
                ++j;
            }
        }
    }

    protected void setHeaderText(int year, int month) {
        this.navbar.title.setText(this.months[month] + ", " + year);
    }

    private int getDaysInMonth(int year, int month) {
        switch (month) {
            case 1: {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    return 29;
                }
                return 28;
            }
            case 3: {
                return 30;
            }
            case 5: {
                return 30;
            }
            case 8: {
                return 30;
            }
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public void prevMonth() {
        int month = this.getMonth() - 1;
        if (month < 0) {
            this.setDate(this.getYear() - 1, 11, this.getDay());
        } else {
            this.setMonth(month);
        }
        this.drawCalendar();
    }

    public void nextMonth() {
        int month = this.getMonth() + 1;
        if (month > 11) {
            this.setDate(this.getYear() + 1, 0, this.getDay());
        } else {
            this.setMonth(month);
        }
        this.drawCalendar();
    }

    public void prevYear() {
        this.setYear(this.getYear() - 1);
        this.drawCalendar();
    }

    public void nextYear() {
        this.setYear(this.getYear() + 1);
        this.drawCalendar();
    }

    private void setDate(int year, int month, int day) {
        this.date = new Date(year - 1900, month, day);
    }

    private void setYear(int year) {
        this.date.setYear(year - 1900);
    }

    private void setMonth(int month) {
        this.date.setMonth(month);
    }

    public int getYear() {
        return 1900 + this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonth();
    }

    public int getDay() {
        return this.date.getDate();
    }

    public Date getDate() {
        return this.date;
    }

    public void onClick(Widget sender) {
        CellHTML cell = (CellHTML)sender;
        this.setDate(this.getYear(), this.getMonth(), cell.getDay());
        this.drawCalendar();
        if (this.changeListeners != null) {
            this.changeListeners.fireChange((Widget)this);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ChangeListenerCollection();
        }
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove((Object)listener);
        }
    }
}

