/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.geospatial.client;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.thapar.gwt.user.ui.client.util.DateUtil;
import java.util.Date;
import org.gcube.portlets.user.geospatial.client.AbstractDatePicker;

public class CalendarTraversalPanel
extends DockPanel
implements ClickListener {
    HTML monthYearDesc = new HTML();
    Button prevMonth = new Button("&lt;", (ClickListener)this);
    Button prevYear = new Button("&lt;&lt;", (ClickListener)this);
    Button nextYear = new Button("&gt;&gt;", (ClickListener)this);
    Button nextMonth = new Button("&gt;", (ClickListener)this);
    AbstractDatePicker datePicker = null;

    public CalendarTraversalPanel(AbstractDatePicker datePicker) {
        this.datePicker = datePicker;
        this.init();
    }

    private void init() {
        this.setHeight("18px");
        this.drawTitle();
        this.prevMonth.setWidth("23px");
        this.nextMonth.setWidth("23px");
        DOM.setAttribute((Element)this.prevMonth.getElement(), (String)"title", (String)"Previous Month");
        DOM.setAttribute((Element)this.prevYear.getElement(), (String)"title", (String)"Previous Year");
        DOM.setAttribute((Element)this.nextMonth.getElement(), (String)"title", (String)"Next Month");
        DOM.setAttribute((Element)this.nextYear.getElement(), (String)"title", (String)"Next Year");
        HorizontalPanel prevButtons = new HorizontalPanel();
        this.prevMonth.setStyleName("monthYearTraversorBtn");
        this.prevMonth.setTitle("go to previou month");
        this.prevYear.setStyleName("monthYearTraversorBtn");
        this.prevYear.setTitle("go to previou year");
        prevButtons.add((Widget)this.prevYear);
        prevButtons.add((Widget)this.prevMonth);
        HorizontalPanel nextButtons = new HorizontalPanel();
        this.nextMonth.setStyleName("monthYearTraversorBtn");
        this.nextMonth.setTitle("go to next month");
        this.nextYear.setStyleName("monthYearTraversorBtn");
        this.nextYear.setTitle("go to next year");
        nextButtons.add((Widget)this.nextMonth);
        nextButtons.add((Widget)this.nextYear);
        this.add((Widget)prevButtons, DockPanel.WEST);
        this.setCellHorizontalAlignment((Widget)prevButtons, DockPanel.ALIGN_LEFT);
        this.add((Widget)nextButtons, DockPanel.EAST);
        this.setCellHorizontalAlignment((Widget)nextButtons, DockPanel.ALIGN_RIGHT);
        this.add((Widget)this.monthYearDesc, DockPanel.CENTER);
        this.setVerticalAlignment(DockPanel.ALIGN_MIDDLE);
        this.setCellHorizontalAlignment((Widget)this.monthYearDesc, HasAlignment.ALIGN_CENTER);
        this.setCellVerticalAlignment((Widget)this.monthYearDesc, HasAlignment.ALIGN_MIDDLE);
        this.setCellWidth((Widget)this.monthYearDesc, "100%");
        this.monthYearDesc.setStyleName("monthYearTraversor");
        this.setStyleName("monthYearTraversor");
    }

    private void drawTitle() {
        this.redrawTitle();
    }

    protected void redrawTitle() {
        StringBuffer monthYearTitle = new StringBuffer();
        monthYearTitle.append(DateUtil.getMonth((Date)this.datePicker.getCurrentDate()));
        monthYearTitle.append("-");
        monthYearTitle.append(this.datePicker.getCurrentDate().getYear() + 1900);
        this.monthYearDesc.setText(monthYearTitle.toString());
    }

    public void onClick(Widget sender) {
        if (sender == this.prevMonth) {
            this.datePicker.setCurrentDate(DateUtil.addMonths((Date)this.datePicker.getCurrentDate(), (int)-1));
        } else if (sender == this.prevYear) {
            this.datePicker.setCurrentDate(DateUtil.addYears((Date)this.datePicker.getCurrentDate(), (int)-1));
        } else if (sender == this.nextYear) {
            this.datePicker.setCurrentDate(DateUtil.addYears((Date)this.datePicker.getCurrentDate(), (int)1));
        } else if (sender == this.nextMonth) {
            this.datePicker.setCurrentDate(DateUtil.addMonths((Date)this.datePicker.getCurrentDate(), (int)1));
        }
        this.redrawTitle();
        this.datePicker.redrawCalendar();
    }
}

