/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.geospatial.client;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.Widget;
import com.thapar.gwt.user.ui.client.util.DateUtil;
import com.thapar.gwt.user.ui.client.widget.simpledatepicker.DateFormatter;
import java.util.Date;
import org.gcube.portlets.user.geospatial.client.AbstractDatePicker;
import org.gcube.portlets.user.geospatial.client.CalendarPanel;

public class CalendarPanel
extends AbsolutePanel {
    AbstractDatePicker datePicker = null;
    FlexTable currentMonth = new FlexTable();
    String[][] cellValues = new String[7][7];
    private boolean isWeekendSelectable = false;
    private DateFormatter dateFormatter = new DateFormatter(DateFormatter.DATE_FORMAT_DDMMYYYY);

    public CalendarPanel(AbstractDatePicker datePicker) {
        this.datePicker = datePicker;
        this.init();
    }

    private void init() {
        this.setHeight("118px");
        this.setStyleName("calendarPanel");
        this.currentMonth.addTableListener((TableListener)new DateClickListener(this, this));
        this.add(this.drawCalendar());
    }

    public void redrawCalendar() {
        this.clearCalendar(this.currentMonth);
        this.buildMonthBody(this.datePicker.getCurrentDate(), this.currentMonth);
    }

    private Widget drawCalendar() {
        this.currentMonth.setStyleName("monthDates");
        this.buildMonthHeader(this.currentMonth);
        this.buildMonthBody(this.datePicker.getCurrentDate(), this.currentMonth);
        return this.currentMonth;
    }

    protected void clearCalendar(FlexTable monthBody) {
        for (int row = 1; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                monthBody.setText(row, col, "");
            }
        }
    }

    protected void buildMonthHeader(FlexTable monthHeader) {
        monthHeader.setHTML(0, 0, "<font class='holidayWeek'>Sun</font>");
        monthHeader.setHTML(0, 1, "<font class='monthHeader'>Mon</font>");
        monthHeader.setHTML(0, 2, "<font class='monthHeader'>Tue</font>");
        monthHeader.setHTML(0, 3, "<font class='monthHeader'>Wed</font>");
        monthHeader.setHTML(0, 4, "<font class='monthHeader'>Thu</font>");
        monthHeader.setHTML(0, 5, "<font class='monthHeader'>Fri</font>");
        monthHeader.setHTML(0, 6, "<font class='holidayWeek'>Sat</font>");
    }

    protected void buildMonthBody(Date date, FlexTable monthBody) {
        int startWeekDay = DateUtil.getStartWeekDay((Date)date);
        int numDays = DateUtil.getNumDaysInMonth((int)date.getMonth(), (boolean)DateUtil.isLeapYear((Date)date));
        int dayCount = 0;
        for (int row = 1; row < 7; ++row) {
            for (int col = 0; col < 7; ++col) {
                if (row == 1 && col < startWeekDay) {
                    monthBody.setText(row, col, "");
                    this.cellValues[row][col] = "";
                    continue;
                }
                if (numDays > dayCount) {
                    int selectedDate = ++dayCount;
                    this.cellValues[row][col] = selectedDate + "";
                    if (col == 0 || col == 6) {
                        if (this.isSelectedDate(date, selectedDate)) {
                            monthBody.setHTML(row, col, "<font class='currentDate'>" + selectedDate + "</font>");
                            continue;
                        }
                        if (this.isWeekendSelectable()) {
                            monthBody.setHTML(row, col, "<font class='holidaySelectable'>" + selectedDate + "</font>");
                            continue;
                        }
                        monthBody.setHTML(row, col, "<font class='holiday'>" + selectedDate + "</font>");
                        continue;
                    }
                    if (this.isSelectedDate(date, selectedDate)) {
                        monthBody.setHTML(row, col, "<font class='currentDate'>" + selectedDate + "<font>");
                        continue;
                    }
                    monthBody.setHTML(row, col, "<font class='calendarDate'>" + selectedDate + "<font>");
                    continue;
                }
                monthBody.setText(row, col, "");
                this.cellValues[row][col] = "";
            }
        }
    }

    private boolean isSelectedDate(Date date, int printedDate) {
        boolean isCurrentDate = false;
        Date selectedDate = this.datePicker.getSelectedDate();
        if (selectedDate.getMonth() == date.getMonth() && selectedDate.getYear() == date.getYear() && selectedDate.getDate() == printedDate) {
            isCurrentDate = true;
        }
        return isCurrentDate;
    }

    public boolean isWeekendSelectable() {
        return this.isWeekendSelectable;
    }

    public void setWeekendSelectable(boolean isWeekendSelectable) {
        this.isWeekendSelectable = isWeekendSelectable;
    }

    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    private String getFormattedDate(Date date) {
        int day = date.getDate();
        int month = date.getMonth() + 1;
        int year = date.getYear() + 1900;
        return "" + day + "/" + month + "/" + year;
    }

    static /* synthetic */ String access$000(CalendarPanel x0, Date x1) {
        return x0.getFormattedDate(x1);
    }
}

