/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubelogin.client.wizard;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.user.gcubelogin.client.commons.LoadingPopUp;
import org.gcube.portlets.user.gcubelogin.client.stubs.NewLoginServiceAsync;
import org.gcube.portlets.user.gcubelogin.client.wizard.WizardMenu;
import org.gcube.portlets.user.gcubelogin.shared.VO;
import org.gcube.portlets.user.gcubelogin.shared.VRE;

public class VRESelector
extends Composite {
    private ArrayList<VO> currentVOs;
    private VerticalPanel mainPanel = new VerticalPanel();
    private VerticalPanel contentPanel = new VerticalPanel();
    private Button nextButton = new Button("Install selected");

    public VRESelector(NewLoginServiceAsync newLoginSvc, ArrayList<VO> myCurrentVOs) {
        this.currentVOs = myCurrentVOs;
        this.mainPanel.setWidth("100%");
        this.mainPanel.add((Widget)new WizardMenu());
        this.mainPanel.add((Widget)this.contentPanel);
        this.contentPanel.setStyleName("wizardPanel");
        this.nextButton.setStyleName("wizardButton");
        HTML title = new HTML("Virtual Research Environments lookup");
        title.setStyleName("wizardTitle");
        HTML select = new HTML("The following VREs were found, select which one of the following you want install:");
        select.setStyleName("wizardText");
        this.contentPanel.add((Widget)title);
        this.contentPanel.add((Widget)select);
        for (VO vo : this.currentVOs) {
            if (vo.getVres().size() <= 0) continue;
            HTML vosel = new HTML("VREs found on " + vo.getName());
            vosel.setStyleName("wizardH2");
            this.contentPanel.add((Widget)vosel);
            Grid vreGrid = this.getVREGrid(vo.getVres());
            int i = 1;
            for (VRE vre : vo.getVres()) {
                vreGrid.setText(i, 1, vre.getName());
                vreGrid.setText(i, 2, vre.getDescription());
                CheckBox box = new CheckBox();
                box.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                vreGrid.setWidget(i, 0, (Widget)box);
                ++i;
            }
            this.contentPanel.add((Widget)vreGrid);
        }
        this.contentPanel.add((Widget)this.nextButton);
        this.initWidget((Widget)this.mainPanel);
        this.nextButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ArrayList<String> isAnyVRESelectedByUser() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (VO vo : this.currentVOs) {
            if (vo.getVres().size() <= 0) continue;
            for (VRE vre : vo.getVres()) {
                if (vre.getUserBelonging() == null) continue;
                toReturn.add(vre.getName());
            }
        }
        return toReturn;
    }

    private Grid getVREGrid(ArrayList<VRE> vres) {
        Grid vreGrid = new Grid(vres.size() + 1, 3);
        vreGrid.setStyleName("wizardGrid");
        HTML name = new HTML("VRE name");
        name.setStyleName("wizardGridLabel");
        HTML description = new HTML("VRE description");
        description.setStyleName("wizardGridLabel");
        HTML select = new HTML("Select");
        select.setStyleName("wizardGridLabel");
        vreGrid.setWidget(0, 0, (Widget)select);
        vreGrid.setWidget(0, 1, (Widget)name);
        vreGrid.setWidget(0, 2, (Widget)description);
        return vreGrid;
    }

    static void showLoading() {
        LoadingPopUp dlg = LoadingPopUp.get();
        dlg.show();
    }

    static void hideLoading() {
        LoadingPopUp dlg = LoadingPopUp.get();
        dlg.hide();
    }

    static /* synthetic */ ArrayList access$000(VRESelector x0) {
        return x0.isAnyVRESelectedByUser();
    }

    static /* synthetic */ VerticalPanel access$100(VRESelector x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ ArrayList access$200(VRESelector x0) {
        return x0.currentVOs;
    }
}

