/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin.tests;

import java.util.ArrayList;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.sam.reports.search.SimpleSearchReport;
import org.gcube.tools.searchtester.plugin.ASLHTTPRequest;
import org.gcube.tools.searchtester.plugin.CollectionInfo;
import org.gcube.tools.searchtester.plugin.ParamMap;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.tests.BaseTest;
import org.gcube.tools.searchtester.plugin.tests.TestResult;
import org.gcube.tools.searchtester.plugin.util.Util;

public class SimpleSearchTest
extends BaseTest {
    public SimpleSearchTest() {
        this.reports = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        SimpleSearchReport report = null;
        for (CollectionInfo coll : PluginContext.collectionsMap.get(this.vre)) {
            try {
                report = new SimpleSearchReport();
                ParamMap parameters = new ParamMap();
                parameters.addParameter("scope", this.vre);
                parameters.addParameter("searchType", "simple");
                String term = Util.getRandomTokenFromSchemas(coll);
                report.setVre(this.vre);
                report.setTerm(term);
                report.setCollectionName(coll.getName());
                report.setCollectionID(coll.getId());
                parameters.addParameter("selectedCollections", coll.getId());
                parameters.addParameter("searchTerms", term);
                if (term.equals("")) {
                    report.setResult(XMLReport.STATUS_ABORTED);
                    report.setError("ERROR: null term selected");
                    report.setExecutionTime(XMLReport.NOT_EXECUTED);
                    continue;
                }
                this.logger.debug((Object)("Executing Simple Search Query on collection :" + coll.getName()));
                this.req = new ASLHTTPRequest("SearchResults", parameters);
                TestResult results = this.req.makeRequest();
                this.logger.debug((Object)("Finishing execution of Simple Search Query on collection :" + coll.getName()));
                report.setResult(Util.checkResults(results.getResult()));
                report.setError(results.getError());
                report.setExecutionTime(results.getExecutionTime());
            }
            catch (Exception e) {
                report.setError(e.toString());
                report.setResult(XMLReport.STATUS_EXCEPTION);
                report.setExecutionTime(XMLReport.NOT_EXECUTED);
            }
            finally {
                this.reports.add(report);
            }
        }
    }
}

