/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin.tests;

import java.util.ArrayList;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.sam.reports.search.BrowseReport;
import org.gcube.tools.searchtester.plugin.ASLHTTPRequest;
import org.gcube.tools.searchtester.plugin.CollectionInfo;
import org.gcube.tools.searchtester.plugin.ParamMap;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.tests.BaseTest;
import org.gcube.tools.searchtester.plugin.tests.TestResult;
import org.gcube.tools.searchtester.plugin.util.Util;

public class BrowseTest
extends BaseTest {
    public BrowseTest() {
        this.reports = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        BrowseReport report = null;
        for (CollectionInfo coll : PluginContext.collectionsMap.get(this.vre)) {
            try {
                report = new BrowseReport();
                ParamMap parameters = new ParamMap();
                parameters.addParameter("scope", this.vre);
                parameters.addParameter("searchType", "browse");
                report.setVre(this.vre);
                report.setCollectionName(coll.getName());
                report.setCollectionID(coll.getId());
                parameters.addParameter("selectedCollection", coll.getId());
                if (coll.getAvailableBrowsableFields().size() == 0) {
                    report.setField(XMLReport.NOT_AVAILABLE);
                    report.setResult("ERROR:Not available Browse fields");
                    report.setError("ERROR:Not available Browse fields");
                    report.setExecutionTime(XMLReport.NOT_EXECUTED);
                    continue;
                }
                String field = Util.getRandomField(coll.getAvailableBrowsableFields());
                parameters.addParameter("searchTerms", field);
                report.setField(field);
                this.logger.debug((Object)("Executing Browse Search  on collection :" + coll.getName()));
                this.req = new ASLHTTPRequest("SearchResults", parameters);
                TestResult results = this.req.makeRequest();
                report.setResult(Util.checkResults(results.getResult()));
                report.setError(results.getError());
                report.setExecutionTime(results.getExecutionTime());
            }
            catch (Exception e) {
                report.setError(e.toString());
                report.setResult(XMLReport.STATUS_EXCEPTION);
                report.setExecutionTime(XMLReport.NOT_EXECUTED);
            }
            finally {
                this.reports.add(report);
            }
        }
    }
}

