/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.sam.istester.plugin.tests.collector;

import java.net.URL;
import java.rmi.Remote;
import java.util.HashMap;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.informationsystem.collector.stubs.XQueryAccessPortType;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteRequest;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteResponse;
import org.gcube.informationsystem.collector.stubs.service.XQueryAccessServiceLocator;
import org.gcube.tools.sam.istester.plugin.helpers.ISCollectorHelper;
import org.gcube.tools.sam.reports.XMLReport;

public class ISQueryTest
extends GCUBEHandler<ISQueryTest> {
    private String type = "";
    private HashMap<String, Object> blackboard = new HashMap();
    private GCUBEScope scope = null;
    private EndpointReferenceType epr = null;
    private XQueryAccessPortType port = null;

    public ISQueryTest(String type, GCUBEScope scope, EndpointReferenceType epr) {
        this.type = type;
        this.scope = scope;
        this.epr = epr;
    }

    public void run() throws Exception {
        try {
            this.setState((State)State.Running.INSTANCE);
            this.port = new XQueryAccessServiceLocator().getXQueryAccessPortTypePort(new URL(this.epr.getAddress().toString()));
            this.port = (XQueryAccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.port, (GCUBEScope)this.scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            XQueryExecuteResponse response = null;
            XQueryExecuteRequest request = new XQueryExecuteRequest();
            String query = ISCollectorHelper.prepareQuery(this.type);
            this.logger.debug((Object)("Sending query :" + query));
            request.setXQueryExpression(query);
            response = this.port.XQueryExecute(request);
            if (response == null) {
                this.logger.error((Object)"Invalid response received from the IC instance");
                this.blackboard.put("RESULT", XMLReport.STATUS_EXCEPTION);
                this.setState((State)State.Failed.INSTANCE);
                return;
            }
            if (response.getSize() == 0L) {
                this.blackboard.put("RESULT", XMLReport.STATUS_EXCEPTION);
                this.setState((State)State.Failed.INSTANCE);
                return;
            }
            this.blackboard.put("RESULT", XMLReport.STATUS_OK);
            this.setState((State)State.Done.INSTANCE);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Exception running the query " + this.type));
            this.logger.debug((Object)e);
            this.blackboard.put("RESULT", XMLReport.STATUS_EXCEPTION);
            this.setState((State)State.Failed.INSTANCE);
            throw e;
        }
        finally {
            this.setBlackboard(this.blackboard);
        }
    }
}

