/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.sam.istester.plugin.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.vremanagement.executor.stubs.ExecutorCall;
import org.gcube.vremanagement.executor.stubs.TaskCall;
import org.gcube.vremanagement.executor.stubs.TaskMonitor;
import org.gcube.vremanagement.executor.stubs.TaskProxy;

public class TestCall {
    public static void main(String[] args) {
        TaskMonitor monitor = new TaskMonitor(new TaskMonitor.TaskTopic[0]){

            public void onStateChange(TaskProxy proxy) throws Exception {
                if (proxy.getState().equals(State.Failed.INSTANCE.toString())) {
                    System.out.println("task has failed with error " + proxy.getError());
                    System.exit(1);
                } else if (proxy.getState().equals(State.Done.INSTANCE.toString())) {
                    System.out.println("task has completed with: " + proxy.getOutput().get("report"));
                    System.exit(0);
                } else {
                    System.out.println("task has moved to status " + proxy.getState());
                }
            }

            public void onOutputChange(TaskProxy proxy) {
                if (proxy.getOutput().containsKey("report")) {
                    System.out.println("output message is " + proxy.getOutput().get("report"));
                }
            }
        };
        ExecutorCall call = null;
        try {
            call = new ExecutorCall(args[0], GCUBEScope.getScope((String)args[1]), new GCUBESecurityManager[0]);
            call.setEndpoint("pcd4science3.cern.ch", "8080");
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("scope", args[1]);
            ArrayList<String> listtests = new ArrayList<String>();
            listtests.add("org.gcube.tools.sam.istester.plugin.tests.ProfileOperationTest");
            listtests.add("org.gcube.tools.sam.istester.plugin.tests.QueryOperationTest");
            String[] string = new String[listtests.size()];
            inputs.put("tests", listtests.toArray(string));
            inputs.put("interval", "3600");
            TaskCall task = call.launch(inputs);
            task.subscribe(monitor);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String quit = null;
            while (true) {
                try {
                    quit = br.readLine();
                }
                catch (IOException ioe) {
                    System.exit(1);
                }
                if (quit.compareTo("q") != 0) continue;
                task.stop();
                System.exit(1);
            }
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

