/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.sam.istester.plugin;

import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.tools.sam.istester.plugin.ISTesterWorker;
import org.gcube.tools.sam.istester.plugin.PluginContext;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class ISTesterTask
extends GCUBEHandler<TaskRuntime>
implements ExecutorTask {
    private GCUBEScheduledHandler scheduled = null;
    ISTesterWorker worker = null;
    boolean isScheduled = false;

    public void run() throws Exception {
        TaskRuntime r = (TaskRuntime)this.getHandled();
        PluginContext.cleanInput();
        this.setState((State)State.Running.INSTANCE);
        try {
            String scope;
            if (r.getInput("tests") != null) {
                for (Object t : (Object[])r.getInput("tests")) {
                    PluginContext.tests.add(Class.forName((String)t));
                }
            } else {
                r.throwException(new Exception("Missing tests to run input parameter"));
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("Missing tests to run input parameter");
            }
            if ((String)r.getInput("scope") == null) {
                r.throwException(new Exception("Missing scope as input parameter"));
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("Missing scope as input parameter");
            }
            PluginContext.scope = scope = (String)r.getInput("scope");
            if ((String)r.getInput("interval") != null) {
                String interval = (String)r.getInput("interval");
                this.logger.debug((Object)("Setting Scheduling interval to:" + interval));
                PluginContext.schedulingInterval = Long.valueOf(interval);
            }
            if (PluginContext.schedulingInterval == -1L) {
                this.worker = new ISTesterWorker(this.isScheduled);
                this.worker.setHandled(this.getHandled());
                this.logger.debug((Object)"Missing scheduling interval. using DEFAULT not scheduled task");
                this.worker.setState((State)State.Running.INSTANCE);
                this.worker.run();
            } else {
                this.logger.debug((Object)("Running scheduled execution with scheduling interval set to:" + PluginContext.schedulingInterval));
                this.isScheduled = true;
                this.worker = new ISTesterWorker(this.isScheduled);
                this.worker.setHandled(this.getHandled());
                this.scheduled = new GCUBEScheduledHandler(PluginContext.schedulingInterval, GCUBEScheduledHandler.Mode.EAGER, new GCUBEHandler[0]);
                this.scheduled.setScheduled((GCUBEHandler)this.worker);
                this.worker.setState((State)State.Running.INSTANCE);
                this.scheduled.run();
            }
            while (this.worker.getState().equals((Object)State.Running.INSTANCE)) {
                Thread.sleep(60000L);
            }
            this.setState((State)State.Done.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            r.throwException(e);
            this.setState((State)State.Failed.INSTANCE);
            PluginContext.cleanInput();
            throw new Exception("Failed to Run the IS Tester", e);
        }
    }

    public void stop() throws Exception {
        if (this.isScheduled) {
            this.scheduled.stop();
        }
        TaskRuntime r = (TaskRuntime)this.getHandled();
        r.addOutput("report", (Object)"TASK Stopped by USER");
        PluginContext.cleanInput();
        this.setState((State)State.Done.INSTANCE);
    }
}

