package org.gcube.personalization.userprofileaccess.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.personalization.userprofileaccess.client.library.plugins.UserProfileAccessCLPlugin;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessStub;
import org.gcube.personalization.userprofileaccess.client.library.utils.UserProfileAccessCLConstants;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessDSL {
	
	public static final UserProfileAccessCLPlugin persin_plugin = new UserProfileAccessCLPlugin();
	
	
	public static StatefulQuery plugin(final String username, final String scope) {
		
		StatefulQuery query = new StatefulQuery(persin_plugin);
		query.addNamespace("ns1",URI.create(UserProfileAccessCLConstants.NAMESPACE))
		.addCondition("$resource/ns1:ResourceKey/text() eq '"+ username + "." + scope +"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(persin_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	public static StatefulBuilder<UserProfileAccessCLProxyI> getUserProfileAccessProxyBuilder() {
		return new StatefulBuilderImpl<UserProfileAccessStub,UserProfileAccessCLProxyI>(persin_plugin);
	}
	
}
