package org.gcube.personalization.userprofileaccess.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.personalization.userprofileaccess.client.library.utils.UserProfileAccessCLConstants;

/**
 * SourceQueryBuilder class
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class SourceQueryBuilder {

	private final StatefulQuery query;
	
	private String username;
	private String scope;
	
	public SourceQueryBuilder(StatefulQuery query) {
		query.addNamespace("ns1",URI.create(UserProfileAccessCLConstants.NAMESPACE));
		this.query=query;
	}

	public SourceQueryBuilder withUsernameAndScope(String username, String scope) {
		this.username = username;
		this.scope = scope;
		return this;
	}

	public StatefulQuery build() {
		if (username!=null)
			query.addCondition("$resource/SourceKey/text() eq '" + username + "_" + scope + "'");
		return query;
	}

}
