package org.gcube.personalization.userprofileaccess.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessCLDefaultProxy;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessCLProxyI;
import org.gcube.personalization.userprofileaccess.client.library.stubs.UserProfileAccessStub;
import org.gcube.personalization.userprofileaccess.client.library.utils.UserProfileAccessCLConstants;

/**
 * UserProfileAccess Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of UserProfileAccess CL. 
 * 
 * @author Panagiota Koltsida, NKUA
 * 
 */
public class UserProfileAccessCLPlugin implements Plugin<UserProfileAccessStub, UserProfileAccessCLProxyI> {

	@Override
	public String name() {
		return UserProfileAccessCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return UserProfileAccessCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return UserProfileAccessCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return UserProfileAccessCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public UserProfileAccessStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(UserProfileAccessCLConstants.persin).at(reference);
		
	}
	
	@Override
	public UserProfileAccessCLProxyI newProxy(ProxyDelegate<UserProfileAccessStub> delegate) {
		return new UserProfileAccessCLDefaultProxy(delegate);
	}

}
