/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.activation.MimeType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.gcube.opensearch.opensearchlibrary.DescriptionDocument;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.responseelements.HTMLResponse;
import org.gcube.opensearch.opensearchlibrary.responseelements.OpenSearchResponse;
import org.gcube.opensearch.opensearchlibrary.responseelements.XMLResponse;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryPair;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryResolver;
import org.gcube.opensearch.opensearchlibrary.utils.URLEncoder;
import org.gcube.opensearch.opensearchoperator.OpenSearchOpConfig;
import org.gcube.opensearch.opensearchoperator.Pager;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OpenSearchWorker
implements Runnable {
    private String terms;
    private Map<String, String> params;
    private String fixedTerms;
    private Map<String, String> fixedParams;
    private Set<String> queryNamespaces = null;
    private URI outLocator;
    private OpenSearchResource resource;
    private OpenSearchResource topResource;
    private ResourceRepository resources;
    private RecordWriter<GenericRecord> writer = null;
    private Object synchLocator = null;
    private OpenSearchOpConfig config;
    private volatile IntegerHolder resultsRemaining = null;
    private volatile IntegerHolder totalResultCount = null;
    private int resultLimit = -1;
    private boolean noLimit = false;
    private Object synchWriter;
    private Object synchInt;
    private Object synchFinalResultCount = null;
    private volatile Integer finalResultCount = null;
    private boolean emittedFinalEvent = false;
    private Boolean emitProgressiveEvents = null;
    private static Logger logger = LoggerFactory.getLogger((String)OpenSearchWorker.class.getName());

    private OpenSearchWorker(OpenSearchResource resource, OpenSearchResource topResource, ResourceRepository resources, OpenSearchOpConfig config, String terms, Map<String, String> params, String fixedTerms, Map<String, String> fixedParams, Set<String> queryNamespaces, IntegerHolder resultsRemaining, IntegerHolder totalResultCount, boolean noLimit, RecordWriter<GenericRecord> writer, URI outLocator, Object synchWriter, Object synchInt) {
        this.writer = writer;
        this.outLocator = outLocator;
        this.terms = terms;
        this.params = params;
        this.fixedTerms = fixedTerms;
        this.fixedParams = fixedParams;
        this.queryNamespaces = queryNamespaces;
        this.resource = resource;
        this.topResource = topResource;
        this.resources = resources;
        this.config = config;
        this.synchWriter = synchWriter;
        this.synchInt = synchInt;
        this.synchFinalResultCount = new Object();
        this.resultsRemaining = resultsRemaining;
        this.totalResultCount = totalResultCount;
        this.noLimit = noLimit;
    }

    public OpenSearchWorker(OpenSearchResource resource, ResourceRepository resources, OpenSearchOpConfig config, String terms, Map<String, String> params, String fixedTerms, Map<String, String> fixedParams, Set<String> queryNamespaces, Object synchLocator) throws Exception {
        this.terms = terms;
        this.params = params;
        this.fixedTerms = fixedTerms;
        this.fixedParams = fixedParams;
        this.queryNamespaces = queryNamespaces;
        this.resource = resource;
        this.topResource = resource;
        this.resources = resources;
        this.config = config;
        this.resultsRemaining = new IntegerHolder();
        this.totalResultCount = new IntegerHolder();
        this.synchWriter = new Object();
        this.synchInt = new Object();
        this.synchLocator = synchLocator;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getFinalResultCount() {
        Object object = this.synchFinalResultCount;
        synchronized (object) {
            while (this.finalResultCount == null) {
                try {
                    this.synchFinalResultCount.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.finalResultCount == -1) {
                return null;
            }
            return new Integer(this.finalResultCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> initializeWriter(Map<String, String> presentationInformation) throws Exception {
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        Set<String> presentables = presentationInformation.keySet();
        FieldDefinition[] fieldDefs = new FieldDefinition[presentables.size() + 1];
        fieldDefs[0] = new StringFieldDefinition("ObjectID");
        int i = 1;
        for (String presentable : presentables) {
            fieldDefs[i] = new StringFieldDefinition(presentable);
            positions.put(presentable, i++);
        }
        LocalWriterProxy producerProxy = new LocalWriterProxy();
        this.writer = new RecordWriter((IWriterProxy)producerProxy, new RecordDefinition[]{new GenericRecordDefinition(fieldDefs)}, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        this.outLocator = producerProxy.getLocator();
        Object object = this.synchLocator;
        synchronized (object) {
            this.synchLocator.notifyAll();
        }
        return positions;
    }

    private void parseConfigParams(Map<String, String> params) throws Exception {
        for (Map.Entry<String, String> en : params.entrySet()) {
            if (en.getKey().compareToIgnoreCase("config:numOfResults") == 0) {
                if (en.getValue().compareToIgnoreCase("unbounded") == 0) continue;
                try {
                    Integer.parseInt(en.getValue());
                }
                catch (Exception e) {
                    logger.error("Invalid configuration parameter format: numOfResults");
                    throw new Exception("Invalid configuration parameter format: numOfResults", e);
                }
            }
            if (en.getKey().compareToIgnoreCase("config:sequentialResults") != 0) continue;
            if (en.getValue().compareToIgnoreCase("true") == 0) {
                this.config.sequentialResults = true;
                continue;
            }
            if (en.getValue().compareToIgnoreCase("false") == 0) {
                this.config.sequentialResults = false;
                continue;
            }
            logger.error("Invalid configuration parameter format: sequentialResults");
            throw new Exception("Invalid configuration parameter format: sequentialResults");
        }
    }

    private EncodingPair selectEncodings(DescriptionDocument dd) throws Exception {
        String selectedInputEncoding = null;
        String selectedOutputEncoding = null;
        List<String> inputEncodings = dd.getSupportedInputEncodings();
        List<String> outputEncodings = dd.getSupportedOutputEncodings();
        if (this.params.containsKey(OpenSearchConstants.inputEncodingQName)) {
            String requestedInputEncoding = this.params.get(OpenSearchConstants.inputEncodingQName);
            if (!dd.isInputEncodingSupported(requestedInputEncoding)) {
                throw new Exception("Requested input encoding is not supported by provider");
            }
            selectedInputEncoding = requestedInputEncoding;
        } else {
            if (!inputEncodings.contains(dd.getDefaultInputEncoding())) {
                throw new Exception("The providers description document does not support the default inputEncoding. The inputEncoding parameter should be contained in the query");
            }
            selectedInputEncoding = dd.getDefaultInputEncoding();
        }
        if (this.params.containsKey(OpenSearchConstants.outputEncodingQName)) {
            String requestedOutputEncoding = this.params.get(OpenSearchConstants.outputEncodingQName);
            if (!dd.isOutputEncodingSupported(requestedOutputEncoding)) {
                throw new Exception("Requested output encoding is not supported by provider");
            }
            if (!Charset.isSupported(requestedOutputEncoding)) {
                throw new Exception("Requested output encoding is not supported");
            }
        } else {
            if (!outputEncodings.contains(dd.getDefaultOutputEncoding())) {
                throw new Exception("The providers description document does not support the default outputEncoding. The outputEncoding parameter should be contained in the query");
            }
            selectedOutputEncoding = dd.getDefaultOutputEncoding();
        }
        return new EncodingPair(selectedInputEncoding, selectedOutputEncoding);
    }

    private List<TransformationSpec> findTransformers(DescriptionDocument dd, List<String> MimeTypes) throws ParserConfigurationException {
        Transformer tr = null;
        XPathExpression recordSplitXpath = null;
        XPathExpression recordIdXpath = null;
        String MIMEType = null;
        Map<String, String> presentationInformation = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        ArrayList<TransformationSpec> specs = new ArrayList<TransformationSpec>();
        for (String MimeType2 : MimeTypes) {
            try {
                tr = this.resource.getTransformer(MimeType2);
                recordSplitXpath = this.resource.getRecordSplitXPath(MimeType2);
                recordIdXpath = this.resource.getRecordIdXPath(MimeType2);
                presentationInformation = this.resource.getPresentationInformation(MimeType2);
            }
            catch (Exception e) {
                logger.warn("Error while retrieving query builders for " + this.resource.getName() + " for mime type " + MimeType2 + " .Ignoring", (Throwable)e);
                continue;
            }
            MIMEType = MimeType2;
            specs.add(new TransformationSpec(MIMEType, tr, recordSplitXpath, recordIdXpath, presentationInformation));
        }
        return specs;
    }

    private void prepareQueryBuilders(List<QueryBuilder> queryBuilders, String searchTerms, String inputEncoding, String outputEncoding) throws Exception {
        HashMap<String, String> ddParams = new HashMap<String, String>();
        logger.info("will evaluate the following params : " + this.params);
        for (Map.Entry<String, String> e : this.params.entrySet()) {
            String[] pEntries = e.getKey().split(":");
            if (pEntries.length > 2) {
                logger.warn("Malformed parameter: " + e.getKey() + ". Ignoring.");
                logger.warn("param has " + pEntries.length + " but expected 2");
                continue;
            }
            ddParams.put(e.getKey(), e.getValue());
        }
        for (QueryBuilder qb : queryBuilders) {
            if (qb.hasParameter(OpenSearchConstants.searchTermsQName)) {
                qb.setParameter(OpenSearchConstants.searchTermsQName, searchTerms);
            }
            if (qb.hasParameter(OpenSearchConstants.inputEncodingQName)) {
                qb.setParameter(OpenSearchConstants.inputEncodingQName, inputEncoding);
            }
            if (qb.hasParameter(OpenSearchConstants.outputEncodingQName)) {
                qb.setParameter(OpenSearchConstants.outputEncodingQName, outputEncoding);
            }
            for (Map.Entry e : ddParams.entrySet()) {
                if (!qb.hasParameter((String)e.getKey())) continue;
                qb.setParameter((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private List<QueryBuilder> reorderQueryBuilders(List<QueryBuilder> queryBuilders, Collection<String> queryParams, String queryTerms) {
        int i;
        final class MatchScore {
            public Integer id;
            public Integer score;

            MatchScore() {
            }
        }
        MatchScore[] matchScores = new MatchScore[queryBuilders.size()];
        for (i = 0; i < queryBuilders.size(); ++i) {
            matchScores[i] = new MatchScore();
            matchScores[i].id = i;
            matchScores[i].score = -1;
        }
        i = 0;
        for (QueryBuilder qb : queryBuilders) {
            int matchScore = 0;
            List<String> reqParams = qb.getRequiredParameters();
            ArrayList<String> qbParams = new ArrayList<String>(reqParams);
            qbParams.addAll(qb.getOptionalParameters());
            ArrayList<String> tmpReqParams = new ArrayList<String>(reqParams);
            tmpReqParams.remove(OpenSearchConstants.searchTermsQName);
            tmpReqParams.remove(OpenSearchConstants.startIndexQName);
            tmpReqParams.remove(OpenSearchConstants.startPageQName);
            tmpReqParams.remove(OpenSearchConstants.countQName);
            tmpReqParams.removeAll(queryParams);
            if (!tmpReqParams.isEmpty()) {
                ++i;
                continue;
            }
            for (String param : qbParams) {
                if (!queryParams.contains(param)) continue;
                ++matchScore;
            }
            matchScores[i].score = matchScore;
            ++i;
        }
        ArrayList<QueryBuilder> qbs = new ArrayList<QueryBuilder>();
        Arrays.sort(matchScores, new Comparator<MatchScore>(){

            @Override
            public int compare(MatchScore a, MatchScore b) {
                if (a.score.equals(b.score)) {
                    return 0;
                }
                if (a.score < b.score) {
                    return 1;
                }
                return -1;
            }
        });
        for (MatchScore entry : matchScores) {
            if (entry.score < 0) break;
            qbs.add(queryBuilders.get(entry.id));
        }
        return qbs;
    }

    private TransformationSpec switchContext(Iterator<TransformationSpec> tsIt, DescriptionDocument dd, Pager pager, String searchTerms, EncodingPair encodings) {
        List<QueryBuilder> qbs = null;
        while (tsIt.hasNext()) {
            TransformationSpec ts = tsIt.next();
            try {
                qbs = dd.getQueryBuilders("results", ts.MimeType);
                qbs = this.reorderQueryBuilders(qbs, this.params.keySet(), this.terms);
                this.prepareQueryBuilders(qbs, searchTerms, encodings.inputEncoding, encodings.outputEncoding);
            }
            catch (Exception ee) {
                logger.warn("Unable to formulate query for " + this.resource.getName() + " MIME Type: " + ts.MimeType + " Page " + pager.getCurrPage() + " after trying all alternatives.");
                continue;
            }
            pager.setContext(qbs, ts.MimeType);
            return ts;
        }
        return null;
    }

    private Map<String, XPathExpression> compileXPathExpressions(Map<String, String> presentationInformation) throws XPathExpressionException {
        HashMap<String, XPathExpression> compiledXPaths = new HashMap<String, XPathExpression>();
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        for (Map.Entry<String, String> presentable : presentationInformation.entrySet()) {
            compiledXPaths.put(presentable.getKey(), xpath.compile(presentable.getValue()));
        }
        return compiledXPaths;
    }

    private boolean appendToResultSet(String record, String recId, Map<String, XPathExpression> presentationInformation, Map<String, Integer> positionInformation) throws GRS2WriterException, XPathExpressionException {
        logger.info("record                  : " + record);
        logger.info("presentationInformation : " + presentationInformation);
        logger.info("positionInformation     : " + positionInformation);
        GenericRecord rec = new GenericRecord();
        Field[] fields = new Field[presentationInformation.keySet().size() + 1];
        fields[0] = recId != null && recId.trim().compareTo("") != 0 ? new StringField(recId) : new StringField(null);
        for (Map.Entry<String, XPathExpression> presentable : presentationInformation.entrySet()) {
            logger.info("fieldName : " + presentable.getKey());
            StringBuilder f = new StringBuilder();
            NodeList nl = (NodeList)presentable.getValue().evaluate(new InputSource(new StringReader(record)), XPathConstants.NODESET);
            logger.info("field number of nodes found in record : " + nl.getLength());
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i).getFirstChild();
                if (child == null) continue;
                f.append(child.getNodeValue() + " ");
            }
            int pos = positionInformation.get(presentable.getKey());
            logger.info("field pos : " + pos);
            logger.info("field payload : " + f);
            fields[pos] = new StringField(f.toString());
        }
        rec.setFields(fields);
        if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
            logger.info("Consumption stopped by consumer side. Stopping.");
            return false;
        }
        if (!this.writer.put((Record)rec, 60L, TimeUnit.SECONDS)) {
            if (this.writer.getStatus() != IBuffer.Status.Open) {
                logger.info("Consumption stopped by consumer side. Stopping.");
            } else {
                logger.warn("Consumer timed out");
            }
            return false;
        }
        return true;
    }

    private void emitProgressiveEvent(int count) {
        try {
            this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumber", "" + count));
        }
        catch (Exception e) {
            logger.warn("Resource " + this.resource.getName() + " could not emit progressive result count event with value" + count);
        }
    }

    private void emitFinalEvent(int count) {
        try {
            this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + count));
        }
        catch (Exception e) {
            logger.warn("Resource " + this.resource.getName() + " could not emit final result count event with value" + count);
        }
        this.emittedFinalEvent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBrokerResultCountEvents(int count) {
        if (!this.emitProgressiveEvents.booleanValue()) {
            if (this.resource == this.topResource) {
                this.emitFinalEvent(count);
            } else {
                Object object = this.synchFinalResultCount;
                synchronized (object) {
                    this.finalResultCount = count;
                    this.synchFinalResultCount.notifyAll();
                }
            }
        } else {
            Object object = this.synchFinalResultCount;
            synchronized (object) {
                this.finalResultCount = -1;
                this.synchFinalResultCount.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePageResultCountEvents(int pageNo, int recordsAppended, OpenSearchResponse response) {
        if (this.emittedFinalEvent) {
            return;
        }
        if (this.emitProgressiveEvents != null && this.emitProgressiveEvents.booleanValue()) {
            int totalRes;
            if (this.resource.isBrokered()) {
                return;
            }
            if (!this.config.sequentialResults.booleanValue() || this.resource == this.topResource && !this.resource.isBrokered()) {
                totalRes = this.totalResultCount.get();
            } else {
                Object object = this.synchInt;
                synchronized (object) {
                    totalRes = this.totalResultCount.get();
                }
            }
            try {
                this.emitProgressiveEvent(totalRes);
            }
            catch (Exception e) {
                logger.warn("Resource " + this.resource.getName() + " could not emit progressive result count event");
            }
        }
        if (this.resource != this.topResource) {
            if (!this.resource.isBrokered() && pageNo == 1) {
                if (!this.config.sequentialResults.booleanValue()) {
                    Object totalRes = this.synchFinalResultCount;
                    synchronized (totalRes) {
                        if (response.getTotalResults() != null) {
                            int count = response.getTotalResults();
                            if (!this.noLimit && this.resultLimit < count) {
                                count = this.resultLimit;
                            }
                            this.finalResultCount = count;
                        } else {
                            int totResults;
                            this.finalResultCount = -1;
                            Object object = this.synchInt;
                            synchronized (object) {
                                totResults = this.totalResultCount.get();
                            }
                            this.emitProgressiveEvent(totResults);
                            this.emitProgressiveEvents = true;
                        }
                        this.synchFinalResultCount.notifyAll();
                    }
                }
                if (response.getTotalResults() != null) {
                    int seqTotal = this.totalResultCount.get() - recordsAppended + response.getTotalResults();
                    if (this.resultLimit < seqTotal) {
                        this.emitFinalEvent(this.resultLimit);
                    } else {
                        this.emitProgressiveEvent(seqTotal);
                    }
                } else {
                    this.emitProgressiveEvent(this.totalResultCount.get());
                    this.emitProgressiveEvents = true;
                }
            }
        } else if (!this.resource.isBrokered() && pageNo == 1) {
            if (response.getTotalResults() != null) {
                int count = response.getTotalResults();
                if (!this.noLimit && this.resultLimit < count) {
                    count = this.resultLimit;
                }
                this.emitFinalEvent(count);
            } else {
                this.emitProgressiveEvents = true;
                this.emitProgressiveEvent(this.totalResultCount.get());
            }
        }
    }

    private void writerCleanup() {
        try {
            if (this.resource == this.topResource) {
                this.writer.close();
            }
        }
        catch (GRS2WriterException e) {
            logger.warn("Top resource " + this.resource.getName() + " was unable to close writer");
        }
    }

    private void enrichRecordNamespaces(Document response, Element record) {
        NamedNodeMap attrs = response.getDocumentElement().getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.item(i).getNodeName();
            if (!attrName.startsWith("xmlns:") || record.hasAttribute(attrName)) continue;
            try {
                record.setPrefix(attrName.substring(attrName.indexOf(":") + 1));
                record.setAttribute(attrName, attrs.item(i).getNodeValue());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object MIMEType;
            Object object;
            Pager pager;
            int currResultsRemaining;
            long start = Calendar.getInstance().getTimeInMillis();
            DocumentBuilder docBuilder = null;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docBuilder = docFactory.newDocumentBuilder();
            FactoryResolver.initialize(this.queryNamespaces, this.config.factories);
            FactoryPair factories = FactoryResolver.getFactories();
            ArrayList<String> brokeredDDUrls = null;
            String terms = this.terms;
            Map<String, String> params = this.params;
            Map<String, XPathExpression> compiledXPathExpressions = null;
            if (this.resource == this.topResource) {
                if (!this.fixedTerms.equals("")) {
                    terms = this.fixedTerms;
                }
                params.putAll(this.fixedParams);
                brokeredDDUrls = new ArrayList<String>();
            }
            int clientStartPage = -1;
            int clientStartIndex = -1;
            int clientCount = -1;
            logger.info("params : " + params);
            if (this.params.containsKey(OpenSearchConstants.startPageQName)) {
                clientStartPage = Integer.parseInt(this.params.get(OpenSearchConstants.startPageQName));
            }
            if (this.params.containsKey(OpenSearchConstants.startIndexQName)) {
                clientStartIndex = Integer.parseInt(this.params.get(OpenSearchConstants.startIndexQName));
            }
            if (this.params.containsKey(OpenSearchConstants.countQName)) {
                clientCount = Integer.parseInt(this.params.get(OpenSearchConstants.countQName));
            }
            logger.info("Parameters from client : ");
            logger.info("startPage        : " + clientStartPage);
            logger.info("clientStartIndex : " + clientStartIndex);
            logger.info("clientCount      : " + clientCount);
            logger.info("------------------------");
            logger.info("params           : " + params);
            logger.info("fixedParams      : " + this.fixedParams);
            DescriptionDocument dd = new DescriptionDocument(this.resource.getDescriptionDocument(), factories.urlElFactory, factories.queryElFactory);
            this.parseConfigParams(params);
            if (this.resource == this.topResource) {
                this.totalResultCount.set(0);
                if (params.containsKey("config:numOfResults")) {
                    if (params.get("config:numOfResults").compareToIgnoreCase("unbounded") == 0) {
                        this.resultsRemaining.set(Integer.MAX_VALUE);
                        this.noLimit = true;
                    } else {
                        this.resultLimit = Integer.parseInt(params.get("config:numOfResults"));
                        this.resultsRemaining.set(this.resultLimit);
                    }
                } else {
                    this.resultsRemaining.set(Integer.MAX_VALUE);
                    this.noLimit = true;
                }
            }
            if (!dd.canRequest()) {
                this.writerCleanup();
                return;
            }
            Object object2 = this.synchInt;
            synchronized (object2) {
                currResultsRemaining = this.resultsRemaining.get();
            }
            if (currResultsRemaining <= 0) {
                this.writerCleanup();
                return;
            }
            EncodingPair encodings = this.selectEncodings(dd);
            List<String> MimeTypes = this.resource.getTransformationTypes();
            MimeTypes.retainAll(dd.getSupportedMimeTypes("results"));
            if (MimeTypes.isEmpty()) {
                this.writerCleanup();
                return;
            }
            List<TransformationSpec> tss = this.findTransformers(dd, MimeTypes);
            if (tss.isEmpty()) {
                logger.warn("Could not find a tranformation specification matching with the MIME types exposed by the description document.");
                this.writerCleanup();
                return;
            }
            Map<String, Integer> positionInformation = this.initializeWriter(tss.get((int)0).presentationInformation);
            String searchTerms = URLEncoder.UrlEncode(terms, "UTF-8");
            OpenSearchResponse response = null;
            Object object3 = this.synchInt;
            synchronized (object3) {
                pager = clientCount > 0 ? new Pager(this.resultsRemaining.get(), clientCount, this.resource.getName(), clientStartPage, clientStartIndex, clientCount) : new Pager(this.resultsRemaining.get(), this.config.resultsPerPage, this.resource.getName(), clientStartPage, clientStartIndex, clientCount);
            }
            Iterator<TransformationSpec> tsIt = tss.iterator();
            TransformationSpec ts = tsIt.next();
            compiledXPathExpressions = this.compileXPathExpressions(ts.presentationInformation);
            List<QueryBuilder> qbs = dd.getQueryBuilders("results", ts.MimeType);
            qbs = this.reorderQueryBuilders(qbs, params.keySet(), terms);
            this.prepareQueryBuilders(qbs, searchTerms, encodings.inputEncoding, encodings.outputEncoding);
            pager.setContext(qbs, ts.MimeType);
            NodeList recordNodes = null;
            int pageNo = 0;
            int resultCount = 0;
            boolean stoppedByConsumer = false;
            do {
                URL pageQuery;
                if (!this.resource.isBrokered() && !this.noLimit) {
                    object = this.synchInt;
                    synchronized (object) {
                        if (this.resultsRemaining.get() <= 0) {
                            logger.info(this.resource.getName() + ": The number of requested results has been retrieved. Stopping.");
                            break;
                        }
                    }
                }
                try {
                    pageQuery = pager.getPageQuery();
                    logger.info("Issuing query to " + this.resource.getName() + " for page #" + ++pageNo + ": " + pageQuery);
                }
                catch (Exception e) {
                    ts = this.switchContext(tsIt, dd, pager, searchTerms, encodings);
                    if (ts != null) {
                        compiledXPathExpressions = this.compileXPathExpressions(ts.presentationInformation);
                        continue;
                    }
                    logger.error("Failed to retrieve results from " + this.resource.getName(), (Throwable)e);
                    break;
                }
                InputStream responseStream = null;
                logger.info("creating http client... : " + pageQuery.toString());
                try {
                    DefaultHttpClient client = new DefaultHttpClient();
                    logger.info("creating http client...OK");
                    HttpGet request = new HttpGet(pageQuery.toString());
                    logger.info("executing query...");
                    HttpResponse httpResponse = client.execute((HttpUriRequest)request);
                    logger.info("executing query...OK");
                    responseStream = httpResponse.getEntity().getContent();
                    MIMEType = new MimeType(ts.MimeType);
                    logger.info("mime  : " + MIMEType.getPrimaryType());
                    response = MIMEType.getPrimaryType().compareTo("text") == 0 && MIMEType.getSubType().compareTo("html") == 0 || MIMEType.getPrimaryType().compareTo("application") == 0 && MIMEType.getSubType().compareTo("xhtml+xml") == 0 ? new HTMLResponse(responseStream, encodings.outputEncoding, dd.getURIToPrefixMappings()) : new XMLResponse(responseStream, factories.queryElFactory, pager.getQueryBuilder(), encodings.outputEncoding, dd.getURIToPrefixMappings());
                }
                catch (Exception e) {
                    logger.warn("Error while parsing response. Ignoring transformation.", (Throwable)e);
                    ts = this.switchContext(tsIt, dd, pager, searchTerms, encodings);
                    if (ts != null) {
                        compiledXPathExpressions = this.compileXPathExpressions(ts.presentationInformation);
                        continue;
                    }
                    logger.error("Failed to retrieve results from " + this.resource.getName(), (Throwable)e);
                    break;
                }
                finally {
                    try {
                        if (responseStream != null) {
                            responseStream.close();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Could not close query response stream");
                    }
                }
                try {
                    Object result = ts.recordSplitXpath.evaluate(response.getResponse(), XPathConstants.NODESET);
                    recordNodes = (NodeList)result;
                    for (int i = 0; i < recordNodes.getLength(); ++i) {
                        this.enrichRecordNamespaces(response.getResponse(), (Element)recordNodes.item(i));
                    }
                }
                catch (Exception e) {
                    logger.warn("XPath evaluation error while extracting records from " + this.resource.getName() + " MIME Type: " + ts.MimeType, (Throwable)e);
                    ts = this.switchContext(tsIt, dd, pager, searchTerms, encodings);
                    if (ts != null) {
                        compiledXPathExpressions = this.compileXPathExpressions(ts.presentationInformation);
                        continue;
                    }
                    logger.error("Failed to retrieve results from " + this.resource.getName(), (Throwable)e);
                    break;
                }
                try {
                    int recordsToAppend;
                    Object i = this.synchInt;
                    synchronized (i) {
                        recordsToAppend = !this.resource.isBrokered() && this.resultsRemaining.get() < recordNodes.getLength() ? (this.resultsRemaining.get() >= 0 ? this.resultsRemaining.get() : 0) : recordNodes.getLength();
                    }
                    if (!this.resource.isBrokered() && !this.noLimit && recordNodes.getLength() != 0 && recordsToAppend == 0) {
                        logger.info(this.resource.getName() + ": The number of requested results has been retrieved. Discarding results of page #" + pageNo);
                        break;
                    }
                    logger.info(this.resource.getName() + ": Current page= #" + pageNo + ". Retrieved " + recordsToAppend + " results");
                    resultCount += recordsToAppend;
                    for (int i2 = 0; i2 < recordsToAppend; ++i2) {
                        String recId = null;
                        try {
                            if (ts.recordIdXpath != null) {
                                Document doc = docBuilder.newDocument();
                                Node node = doc.importNode(recordNodes.item(i2), true);
                                doc.appendChild(node);
                                recId = ts.recordIdXpath.evaluate(doc);
                                recId = XMLUtils.DoReplaceSpecialCharachters((String)recId);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("XPath evaluation error while extracting record ids from " + this.resource.getName() + " MIME Type: " + ts.MimeType, (Throwable)e);
                        }
                        StringWriter transformed = new StringWriter();
                        ts.transformer.transform(new DOMSource(recordNodes.item(i2)), new StreamResult(transformed));
                        if (!this.resource.isBrokered()) {
                            if (!this.noLimit) {
                                boolean bl;
                                boolean bl2 = false;
                                Object object4 = this.synchInt;
                                synchronized (object4) {
                                    if (this.resultsRemaining.get() == 0) {
                                        bl = true;
                                    } else {
                                        this.resultsRemaining.set(this.resultsRemaining.get() - 1);
                                    }
                                }
                                if (bl) {
                                    logger.info(this.resource.getName() + ": The number of requested results has been retrieved. Discarding results of page #" + pageNo + " after #" + i2);
                                    break;
                                }
                            }
                            try {
                                this.handlePageResultCountEvents(pageNo, recordsToAppend, response);
                                if (this.appendToResultSet(transformed.toString(), recId, compiledXPathExpressions, positionInformation)) continue;
                                stoppedByConsumer = true;
                                break;
                            }
                            catch (GRS2WriterException gRS2WriterException) {
                                logger.warn("Could not write record", (Throwable)gRS2WriterException);
                                continue;
                            }
                        }
                        try {
                            new URL(transformed.toString());
                        }
                        catch (Exception exception) {
                            logger.warn("Malformed Url for brokered provider # " + i2 + ". Ignoring");
                            continue;
                        }
                        brokeredDDUrls.add(transformed.toString());
                    }
                }
                catch (TransformerException e) {
                    logger.warn("Transformation error while transforming results from  " + dd.getShortName() + " MIME Type: " + ts.MimeType, (Throwable)e);
                    ts = this.switchContext(tsIt, dd, pager, searchTerms, encodings);
                    if (ts != null) continue;
                    logger.error("Failed to retrieve results from " + this.resource.getName(), (Throwable)e);
                    break;
                }
                logger.info("recordNodes.getLength() : " + recordNodes.getLength());
                if (stoppedByConsumer) break;
                pager.next(response, recordNodes.getLength());
            } while (pager.hasNext());
            if (!this.resource.isBrokered()) {
                this.writerCleanup();
                logger.info(this.resource.getName() + ": Results retrieved: " + resultCount);
                MIMEType = this.synchInt;
                synchronized (MIMEType) {
                    this.totalResultCount.set(this.totalResultCount.get() + resultCount);
                    long end = Calendar.getInstance().getTimeInMillis();
                    if (this.resource == this.topResource) {
                        float productionRate = (float)this.totalResultCount.get().intValue() / (float)(end - start) * 1000.0f;
                        logger.info("Top resource " + this.resource.getName() + ": Total results retrieved: " + this.totalResultCount.get());
                        logger.info("Production rate was: " + productionRate + " records per second");
                        logger.info("Production rate per provider was: " + productionRate + " records per second");
                    }
                }
                return;
            }
            if (!stoppedByConsumer) {
                if (this.config.sequentialResults.booleanValue()) {
                    OpenSearchResource oldResource = this.resource;
                    for (int i = 0; i < brokeredDDUrls.size(); ++i) {
                        OpenSearchResource brokeredResource;
                        try {
                            brokeredResource = this.resources.get((String)brokeredDDUrls.get(i));
                        }
                        catch (Exception e) {
                            logger.warn("Could not retrieve brokered resource with DD URL: " + (String)brokeredDDUrls.get(i) + ". Ignoring resource", (Throwable)e);
                            --resultCount;
                            continue;
                        }
                        if (brokeredResource == null) {
                            logger.warn("Missing brokered resource with DD URL: " + (String)brokeredDDUrls.get(i) + " . Ignoring resource");
                            --resultCount;
                            continue;
                        }
                        this.resource = brokeredResource;
                        this.emitProgressiveEvents = false;
                        this.run();
                        Object e = this.synchInt;
                        synchronized (e) {
                            if (this.resultsRemaining.get() <= 0 && !this.noLimit) {
                                break;
                            }
                            continue;
                        }
                    }
                    this.resource = oldResource;
                } else if (brokeredDDUrls.size() > 0) {
                    ArrayList<OpenSearchWorker> workers = new ArrayList<OpenSearchWorker>();
                    ExecutorService es = Executors.newFixedThreadPool(brokeredDDUrls.size());
                    ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
                    for (int i = 0; i < brokeredDDUrls.size(); ++i) {
                        OpenSearchResource brokeredResource;
                        try {
                            brokeredResource = this.resources.get((String)brokeredDDUrls.get(i));
                        }
                        catch (Exception e) {
                            logger.warn("Could not retrieve brokered resource with DD URL: " + (String)brokeredDDUrls.get(i) + ". Ignoring resource", (Throwable)e);
                            --resultCount;
                            continue;
                        }
                        if (brokeredResource == null) {
                            logger.warn("Missing brokered resource with DD URL: " + (String)brokeredDDUrls.get(i) + " . Ignoring resource");
                            --resultCount;
                            continue;
                        }
                        OpenSearchWorker worker = new OpenSearchWorker(brokeredResource, this.topResource, this.resources, this.config, this.terms, this.params, this.fixedTerms, this.fixedParams, this.queryNamespaces, this.resultsRemaining, this.totalResultCount, this.noLimit, this.writer, this.outLocator, this.synchWriter, this.synchInt);
                        workers.add(worker);
                        tasks.add(Executors.callable(worker));
                    }
                    List futures = es.invokeAll(tasks);
                    int finalResultCountSum = 0;
                    for (OpenSearchWorker openSearchWorker : workers) {
                        Integer frc = openSearchWorker.getFinalResultCount();
                        if (frc == null) {
                            this.emitProgressiveEvents = true;
                            break;
                        }
                        finalResultCountSum += frc.intValue();
                    }
                    this.handleBrokerResultCountEvents(finalResultCountSum);
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException ee) {
                            logger.error("Brokered result retrieval failure: " + ee.getCause());
                        }
                    }
                    es.shutdown();
                }
            }
            this.writerCleanup();
            logger.info("Total brokered providers retrieved: " + resultCount);
            object = this.synchInt;
            synchronized (object) {
                logger.info("Brokered " + (this.resource == this.topResource ? "Top " : "") + "resource " + this.resource.getName() + ": Total results retrieved: " + this.totalResultCount.get());
                if (this.resource == this.topResource) {
                    long end = Calendar.getInstance().getTimeInMillis();
                    float productionRate = (float)this.totalResultCount.get().intValue() / (float)(end - start) * 1000.0f;
                    logger.info("Production rate was: " + productionRate + " records per second");
                    if (resultCount != 0) {
                        logger.info("Production rate per provider was: " + productionRate / (float)resultCount + " records per secord");
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error("Error while retrieving results" + (this.resource != null ? " from " + this.resource.getName() : "") + ". Stopping.", (Throwable)e);
            this.writerCleanup();
            return;
        }
    }

    private class TransformationSpec {
        public final String MimeType;
        public final Transformer transformer;
        public final XPathExpression recordSplitXpath;
        public final XPathExpression recordIdXpath;
        public final Map<String, String> presentationInformation;

        public TransformationSpec(String MimeType2, Transformer transformer, XPathExpression recordSplitXpath, XPathExpression recordIdXpath, Map<String, String> presentationInformation) {
            this.MimeType = MimeType2;
            this.transformer = transformer;
            this.recordSplitXpath = recordSplitXpath;
            this.recordIdXpath = recordIdXpath;
            this.presentationInformation = presentationInformation;
        }
    }

    private class EncodingPair {
        public final String inputEncoding;
        public final String outputEncoding;

        public EncodingPair(String inputEncoding, String outputEncoding) {
            this.inputEncoding = inputEncoding;
            this.outputEncoding = outputEncoding;
        }
    }

    private class IntegerHolder {
        Integer i = null;

        private IntegerHolder() {
        }

        public Integer get() {
            return this.i;
        }

        public void set(Integer i) {
            this.i = i;
        }
    }
}

