/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.query.extensions.sru;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.SRUConstants;
import org.gcube.opensearch.opensearchlibrary.query.BasicQueryBuilder;
import org.gcube.opensearch.opensearchlibrary.query.BasicURLTemplate;
import org.gcube.opensearch.opensearchlibrary.query.IncompleteQueryException;
import org.gcube.opensearch.opensearchlibrary.query.MalformedQueryException;
import org.gcube.opensearch.opensearchlibrary.query.NonExistentParameterException;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilderDecorator;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;

public class SRUQueryBuilder
extends QueryBuilderDecorator {
    public SRUQueryBuilder(QueryBuilder qb) throws Exception {
        super(qb);
        for (String param : this.getRequiredParameters()) {
            if (!param.equals(SRUConstants.startRecordQname)) continue;
            this.setParameter(SRUConstants.startRecordQname, this.getStartIndexDef());
        }
    }

    @Override
    public QueryBuilder clone() {
        SRUQueryBuilder qb;
        try {
            qb = new SRUQueryBuilder(this.qb);
        }
        catch (Exception e) {
            return null;
        }
        return qb;
    }

    @Override
    public SRUQueryBuilder setParameter(String name, String value) throws NonExistentParameterException, Exception {
        if (name.compareTo(SRUConstants.sortKeysQname) == 0 || name.compareTo(SRUConstants.httpAcceptQname) == 0 || name.compareTo(SRUConstants.facetSortQname) == 0) {
            this.qb.setParameter(name, URLDecoder.decode(value, "UTF-8"));
        } else {
            this.qb.setParameter(name, value);
        }
        return this;
    }

    @Override
    public SRUQueryBuilder setParameters(List<String> names, List<Object> values) throws NonExistentParameterException, Exception {
        if (names.size() != values.size()) {
            throw new Exception("List size mismatch");
        }
        int index = names.indexOf(SRUConstants.queryTypeQname);
        if (index != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.queryTypeQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.queryQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.queryQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.startRecordQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.startRecordQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.startRecordQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.maximumRecordsQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.maximumRecordsQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.maximumRecordsQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.recordPackingQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.recordPackingQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.recordSchemaQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.recordSchemaQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.resultSetTTLQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.resultSetTTLQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.resultSetTTLQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.sortKeysQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.sortKeysQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.stylesheetQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.stylesheetQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.renderingQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.renderingQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.httpAcceptQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.httpAcceptQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.httpAcceptCharsetQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.httpAcceptCharsetQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.httpAcceptEncodingQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.httpAcceptEncodingQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.httpAcceptRangesQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.httpAcceptRangesQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetLimitQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.facetLimitQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetStartQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.facetStartQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.facetStartQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetSortQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.facetSortQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetRangeFieldQname)) != 1) {
            if (!(values.get(index) instanceof String)) {
                throw new ClassCastException();
            }
            this.setParameter(SRUConstants.facetRangeFieldQname, (String)values.get(index));
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetLowValueQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.facetLowValueQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.facetLowValueQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetHighValueQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.facetHighValueQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.facetHighValueQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        if ((index = names.indexOf(SRUConstants.facetCountQname)) != 1) {
            if (values.get(index) instanceof String) {
                this.setParameter(SRUConstants.facetCountQname, (String)values.get(index));
            } else if (values.get(index) instanceof Integer) {
                this.setParameter(SRUConstants.facetCountQname, (Integer)values.get(index));
            } else {
                throw new ClassCastException();
            }
            names.remove(index);
            values.remove(index);
        }
        this.qb.setParameters(names, values);
        return this;
    }

    private void validateQuery() throws IncompleteQueryException, MalformedQueryException, Exception {
        String value;
        for (String param : Arrays.asList(SRUConstants.startRecordQname, SRUConstants.maximumRecordsQname, SRUConstants.resultSetTTLQname)) {
            if (!this.isParameterSet(param)) continue;
            Integer intVal = null;
            try {
                intVal = Integer.parseInt(this.getParameterValue(param));
            }
            catch (Exception e) {
                throw new MalformedQueryException("Incorrect parameter type", param);
            }
            if (!param.equals(SRUConstants.maximumRecordsQname) && !param.equals(SRUConstants.resultSetTTLQname) || intVal >= 0) continue;
            throw new MalformedQueryException("Non-negative value expected", param);
        }
        if (this.isParameterSet(SRUConstants.recordPackingQname)) {
            value = null;
            try {
                value = this.getParameterValue(SRUConstants.recordPackingQname);
            }
            catch (Exception e) {
                throw new MalformedQueryException(e);
            }
            if (!value.equals("xml") && !value.equals("string")) {
                throw new MalformedQueryException("Invalid SRU recordpacking parameter value");
            }
        }
        if (this.isParameterSet(SRUConstants.sortKeysQname)) {
            value = null;
            try {
                value = this.getParameterValue(SRUConstants.sortKeysQname);
            }
            catch (Exception e) {
                throw new MalformedQueryException(e);
            }
            this.validateSortKeys(SRUConstants.sortKeysQname, value);
        }
        if (this.isParameterSet(SRUConstants.renderingQname)) {
            value = null;
            try {
                value = this.getParameterValue(SRUConstants.renderingQname);
            }
            catch (Exception e) {
                throw new MalformedQueryException(e);
            }
            if (!value.equals("server") && !value.equals("client")) {
                throw new MalformedQueryException("Invalid SRU rendering parameter value");
            }
        }
        if (this.isParameterSet(SRUConstants.facetLimitQname) || this.isParameterSet(SRUConstants.facetCountQname) || this.isParameterSet(SRUConstants.facetRangeFieldQname) || this.isParameterSet(SRUConstants.facetLowValueQname) || this.isParameterSet(SRUConstants.facetHighValueQname) || this.isParameterSet(SRUConstants.facetSortQname) || this.isParameterSet(SRUConstants.facetStartQname)) {
            throw new Exception("SRU facet parameters currently not supported");
        }
    }

    private void validateSortKeys(String param, String value) throws MalformedQueryException {
        String[] sortKeys;
        for (String sortKey : sortKeys = value.split(" ")) {
            String[] subParams = sortKey.split(",");
            if (subParams.length < 1 || subParams.length > 5) {
                throw new MalformedQueryException(sortKey + " contains illegal number of subparameters");
            }
            if (subParams[0].equals("")) {
                throw new MalformedQueryException("Path subparameter of " + sortKey + " is missing", param);
            }
            if (!subParams[subParams.length - 1].equals("")) continue;
            throw new MalformedQueryException("No value found for last defined subparameter of " + sortKey);
        }
    }

    @Override
    public String getQuery() throws IncompleteQueryException, MalformedQueryException, Exception {
        this.validateQuery();
        return this.qb.getQuery();
    }

    @Override
    public QueryBuilder setParameters(QueryElement queryEl) throws NonExistentParameterException, Exception {
        Map<String, String> m = queryEl.getQueryParameters();
        for (Map.Entry<String, String> e : m.entrySet()) {
            this.setParameter(e.getKey(), e.getValue());
        }
        return this;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> nsPrefixes = new HashMap<String, String>();
        nsPrefixes.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        nsPrefixes.put("http://www.genesi-dr.eu/spec/opensearch/extensions/eop/1.0/", "eop");
        nsPrefixes.put("http://a9.com/-/opensearch/extensions/time/1.0/", "time");
        nsPrefixes.put("http://a9.com/-/opensearch/extensions/geo/1.0/", "geo");
        nsPrefixes.put("http://earth.esa.int/sar", "sar");
        nsPrefixes.put("http://purl.org/dc/elements/1.1/", "dc");
        nsPrefixes.put("http://purl.org/dc/terms/", "dct");
        nsPrefixes.put("http://xmlns.com/2008/dclite4g#", "dclite4g");
        nsPrefixes.put("http://www.w3.org/2002/12/cal/ical#", "ical");
        nsPrefixes.put("http://www.w3.org/2005/Atom", "atom");
        nsPrefixes.put("http://www.example.com/schemas/envisat.rdf#", "envisat");
        nsPrefixes.put("http://www.w3.org/2002/07/owl#", "owl");
        nsPrefixes.put("http://downlode.org/Code/RDF/file-properties/", "fp");
        nsPrefixes.put("http://dclite4g.xmlns.com/ws.rdf#", "ws");
        nsPrefixes.put("http://a9.com/-/spec/opensearch/1.1/", "os");
        nsPrefixes.put("http://www.eorc.jaxa.jp/JERS-1/en/", "jers");
        nsPrefixes.put("http://a9.com/-/opensearch/extensions/sru/2.0/", "sru");
        String queryType = "TODO";
        String query = "TODO";
        long start = Calendar.getInstance().getTimeInMillis();
        BasicURLTemplate template = new BasicURLTemplate("http://www.testTimeExt.com/rdf/?count={count?}&startPage={startPage?}&startIndex={startIndex?}&sort={sru:sortKeys?}&ce={ws:ce?}&protocol={ws:protocol?}&resourcetype={ws:type?}&q={searchTerms?}&start={time:start?}&stop={time:end?}&ingested={dct:modified?}&bbox={geo:box?}&geometry={geo:geometry?}&uid={geo:uid?}&processingCenter={eop:processingCenter?}&acquisitionStation={eop:acquisitionStation?}&size={eop:size?}&orbitNumber={eop:orbitNumber?}&trackNumber={eop:trackNumber?}&lat={geo:lat?}&lon={geo:lon?}&radius={geo:radius?}", nsPrefixes);
        for (int i = 0; i < 1000; ++i) {
            SRUQueryBuilder qb = new SRUQueryBuilder(new BasicQueryBuilder(template, "1", "1"));
            qb.setParameter(SRUConstants.queryTypeQname, URLEncoder.encode(queryType, "UTF-8"));
            qb.setParameter(SRUConstants.queryQname, URLEncoder.encode(query, "UTF-8"));
            String q = qb.getQuery();
            if (i % 100 != 0) continue;
            System.out.println(i * 100 + "th record in " + (Calendar.getInstance().getTimeInMillis() - start) + " millis");
            System.out.println(q);
        }
    }
}

