/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.opensearch.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.gcube.rest.opensearch.client.exception.OpenSearchClientException;
import org.gcube.rest.opensearch.client.helpers.ResponseUtils;
import org.gcube.rest.opensearch.client.inject.OpenSearchClientModule;
import org.gcube.rest.opensearch.common.apis.OpenSearchServiceAPI;
import org.gcube.rest.opensearch.common.discover.OpenSearchDiscovererAPI;
import org.gcube.rest.opensearch.common.helpers.ResultReader;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchClient {
    private static Gson gson = new Gson();
    private String endpoint;
    private String resourceID;
    private final String scope;
    private final String collectionID;
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchClient.class);

    public OpenSearchClient(Builder builder) throws OpenSearchClientException {
        this.endpoint = builder.endpoint;
        this.scope = builder.scope;
        this.resourceID = builder.resourceID;
        this.collectionID = builder.collectionID;
        OpenSearchDiscovererAPI discoverer = builder.discoverer;
        if (discoverer == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new OpenSearchClientModule()});
            discoverer = (OpenSearchDiscovererAPI)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<OpenSearchDiscovererAPI<OpenSearchDataSourceResource>>(){}));
        }
        this.initialize((OpenSearchDiscovererAPI<OpenSearchDataSourceResource>)discoverer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initialize(OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer) throws OpenSearchClientException {
        boolean found = false;
        try {
            Map opensearchNodes = discoverer.discoverOpenSearchNodes(this.collectionID, this.scope);
            logger.info("running instances for opensearch service : " + opensearchNodes);
            ArrayList endpoints = Lists.newArrayList(opensearchNodes.keySet());
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) {
                    throw new OpenSearchClientException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                }
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            for (String endpoint : endpoints) {
                ArrayList resources;
                block11: {
                    if (opensearchNodes.get(endpoint) == null || ((Set)opensearchNodes.get(endpoint)).size() <= 0) continue;
                    resources = Lists.newArrayList((Iterable)((Iterable)opensearchNodes.get(endpoint)));
                    if (this.resourceID != null) {
                        if (resources.contains(this.resourceID)) {
                            resources = Lists.newArrayList((Object[])new String[]{this.resourceID});
                            break block11;
                        } else {
                            logger.info("resource : " + this.resourceID + " not in : " + resources + " of " + endpoint);
                            continue;
                        }
                    }
                    Collections.shuffle(resources);
                }
                this.resourceID = (String)resources.get(0);
                this.endpoint = endpoint;
                found = true;
                break;
            }
            logger.info("Initialized at : " + this.endpoint + " , " + this.resourceID);
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new OpenSearchClientException("could not initialize random client", e);
        }
        if (found) {
            return;
        }
        if (this.resourceID != null) {
            throw new OpenSearchClientException("could not initialize random client. given resourceID : " + this.resourceID);
        }
        throw new OpenSearchClientException("could not initialize random client");
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getScope() {
        return this.scope;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    private static OpenSearchServiceAPI getOpenSearchServiceProxy(String endpoint) throws OpenSearchClientException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        OpenSearchServiceAPI simple = null;
        logger.info("getting proxy from opensearch service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (OpenSearchServiceAPI)target.proxy(OpenSearchServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new OpenSearchClientException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from opensearch service...OK");
        return simple;
    }

    public String query(String queryString) throws OpenSearchClientException {
        return this.query(queryString, true);
    }

    public String query(String queryString, Boolean useRR) throws OpenSearchClientException {
        logger.info("calling query with parameters. queryString : " + queryString + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = OpenSearchClient.getOpenSearchServiceProxy(this.endpoint).query(this.scope, this.resourceID, queryString, useRR, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        logger.info("query returned");
        ResponseUtils.checkResponse(response, "query");
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        return (String)resp.get("grslocator");
    }

    public List<Map<String, String>> queryAndReadClientSide(String queryString) throws OpenSearchClientException {
        return this.queryAndReadClientSide(queryString, true);
    }

    public List<Map<String, String>> queryAndReadClientSide(String queryString, Boolean useRR) throws OpenSearchClientException {
        logger.info("calling queryAndReadClientSide with parameters. queryString : " + queryString + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        String grsLocator = this.query(queryString, useRR);
        logger.info("queryAndReadClientSide returned : " + grsLocator);
        try {
            List results = ResultReader.resultSetToRecords((String)grsLocator);
            return results;
        }
        catch (Exception e) {
            logger.error("could not read results from the grs2 locator : " + grsLocator, (Throwable)e);
            throw new OpenSearchClientException("could not read results from the grs2 locator : " + grsLocator, e);
        }
    }

    public List<Map<String, String>> queryAndRead(String queryString) throws OpenSearchClientException {
        return this.queryAndRead(queryString, true);
    }

    public List<Map<String, String>> queryAndRead(String queryString, Boolean useRR) throws OpenSearchClientException {
        logger.info("calling query with parameters. queryString : " + queryString + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = OpenSearchClient.getOpenSearchServiceProxy(this.endpoint).query(this.scope, this.resourceID, queryString, useRR, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        logger.info("query returned");
        ResponseUtils.checkResponse(response, "query");
        String json = (String)response.readEntity(String.class);
        response.close();
        try {
            List resp = (List)gson.fromJson(json, new TypeToken<List<Map<String, String>>>(){}.getType());
            return resp;
        }
        catch (Exception e) {
            logger.error("Unable to convert response to list of maps of strings : " + json);
            throw new OpenSearchClientException("Unable to convert response to list of maps of strings " + json, e);
        }
    }

    public static class Builder {
        private String endpoint;
        private String resourceID;
        private String scope;
        private String collectionID;
        private final OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer;

        public Builder() {
            this.discoverer = null;
        }

        @Inject
        public Builder(OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer) {
            this.discoverer = discoverer;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder resourceID(String resourceID) {
            this.resourceID = resourceID;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder collectionID(String collectionID) {
            this.collectionID = collectionID;
            return this;
        }

        public OpenSearchClient build() throws OpenSearchClientException {
            return new OpenSearchClient(this);
        }
    }
}

