/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.manager;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TaxonomyUtils {
    private static Logger log = Logger.getLogger(TaxonomyUtils.class);

    public static String createClassTree(OntModel m) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("Taxonomy");
            doc.appendChild(root);
            ExtendedIterator i = m.listHierarchyRootClasses().filterDrop(new Filter(){

                public boolean accept(Object o) {
                    return ((Resource)o).isAnon();
                }
            });
            while (i.hasNext()) {
                TaxonomyUtils.appendNodes((OntClass)i.next(), root, doc, new ArrayList());
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            log.error((Object)"Could not create the tree, xml description of the taxonomy", (Throwable)e);
            throw new Exception("Could not create the tree, xml description of the taxonomy");
        }
    }

    public static String createSubTaxonomyTree(OntModel m, OntClass parentClass) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("Taxonomy");
            doc.appendChild(root);
            TaxonomyUtils.appendNodes(parentClass, root, doc, new ArrayList());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            log.error((Object)"Could not create the tree, xml description of the taxonomy", (Throwable)e);
            throw new Exception("Could not create the tree, xml description of the taxonomy");
        }
    }

    private static void appendNodes(OntClass cls, Node parent, Document doc, List occurs) {
        Element current = doc.createElement("Class");
        Attr clsname = doc.createAttribute("name");
        clsname.setNodeValue(cls.getOntModel().shortForm(cls.getURI()));
        current.setAttributeNode(clsname);
        parent.appendChild(current);
        if (cls.canAs(OntClass.class) && !occurs.contains(cls)) {
            ExtendedIterator i = cls.listSubClasses(true);
            while (i.hasNext()) {
                OntClass sub = (OntClass)i.next();
                occurs.add(cls);
                TaxonomyUtils.appendNodes(sub, current, doc, occurs);
                occurs.remove(cls);
            }
        }
    }
}

