/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.manager;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchFieldsUtils {
    public static String createSearchFields(OntModel model) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("SearchFields");
        doc.appendChild(root);
        Element dataTypePropertiesElement = doc.createElement("DatatypeProperties");
        Element classesElement = doc.createElement("Classes");
        root.appendChild(dataTypePropertiesElement);
        root.appendChild(classesElement);
        ExtendedIterator it = model.listDatatypeProperties();
        while (it.hasNext()) {
            DatatypeProperty dataTypeProperty = (DatatypeProperty)it.next();
            String uri = dataTypeProperty.getURI();
            String localname = dataTypeProperty.getLocalName();
            Element propertyElement = doc.createElement("Property");
            Element propURI = doc.createElement("URI");
            Element propLocal = doc.createElement("LocalName");
            propURI.setTextContent(uri);
            propLocal.setTextContent(localname);
            propertyElement.appendChild(propURI);
            propertyElement.appendChild(propLocal);
            dataTypePropertiesElement.appendChild(propertyElement);
        }
        ExtendedIterator clsIt = model.listClasses().filterDrop(new Filter(){

            public boolean accept(Object o) {
                return ((Resource)o).isAnon();
            }
        });
        while (clsIt.hasNext()) {
            OntClass ontClass = (OntClass)clsIt.next();
            if (ontClass.isClass()) {
                String uri = ontClass.getURI();
                String localname = ontClass.getLocalName();
                Element classElement = doc.createElement("Class");
                Element classURI = doc.createElement("URI");
                Element classLocal = doc.createElement("LocalName");
                classURI.setTextContent(uri);
                classLocal.setTextContent(localname);
                classElement.appendChild(classURI);
                classElement.appendChild(classLocal);
                classesElement.appendChild(classElement);
                continue;
            }
            System.out.println("adssdf");
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return sw.getBuffer().toString();
    }
}

