/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.manager;

import com.hp.hpl.jena.ontology.OntModel;
import org.apache.log4j.Logger;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntModelManager;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfCollectionIDs;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOntologies;
import org.globus.wsrf.ResourceException;

public class OntologyResource
extends GCUBEWSResource {
    protected static final String RP_BaseOntologyNAME = "BaseOntologyName";
    protected static final String RP_BaseOntologyURI = "BaseOntologyURI";
    protected static final String RP_ImportedOntologies = "ImportedOntologies";
    protected static final String RP_ReferencedCollections = "ReferencedCollections";
    protected static String[] RPNames = new String[]{"BaseOntologyName", "BaseOntologyURI", "ImportedOntologies", "ReferencedCollections"};
    private static Logger log = Logger.getLogger(OntologyResource.class);
    private OntModel model;

    protected void initialise(Object ... args) throws ResourceException {
        if (args.length != 4) {
            throw new IllegalArgumentException();
        }
        try {
            String baseOntologyName = (String)args[0];
            String baseOntologyURI = (String)args[1];
            ArrayOfOntologies importedOntologies = (ArrayOfOntologies)args[2];
            ArrayOfCollectionIDs collectionIDs = (ArrayOfCollectionIDs)args[3];
            this.setBaseOntologyName(baseOntologyName);
            this.setBaseOntologyURI(baseOntologyURI);
            this.setImportedOntologies(importedOntologies);
            this.setReferencedCollections(collectionIDs);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public String[] getPropertyNames() {
        return RPNames;
    }

    public String getBaseOntologyName() {
        return (String)this.getResourcePropertySet().get(RP_BaseOntologyNAME).get(0);
    }

    public String getBaseOntologyURI() {
        return (String)this.getResourcePropertySet().get(RP_BaseOntologyURI).get(0);
    }

    public ArrayOfOntologies getImportedOntologies() {
        return (ArrayOfOntologies)this.getResourcePropertySet().get(RP_ImportedOntologies).get(0);
    }

    public ArrayOfCollectionIDs getReferencedCollections() {
        try {
            return (ArrayOfCollectionIDs)this.getResourcePropertySet().get(RP_ReferencedCollections).get(0);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    protected synchronized void setBaseOntologyName(String name) throws Exception {
        this.getResourcePropertySet().get(RP_BaseOntologyNAME).clear();
        this.getResourcePropertySet().get(RP_BaseOntologyNAME).add((Object)name);
    }

    protected synchronized void setBaseOntologyURI(String uri) throws Exception {
        this.getResourcePropertySet().get(RP_BaseOntologyURI).clear();
        this.getResourcePropertySet().get(RP_BaseOntologyURI).add((Object)uri);
    }

    public void putReferencedCollectionID(String collectionID) throws Exception {
        ArrayOfCollectionIDs arrayOfCollectionIDs = this.getReferencedCollections();
        String[] array = null;
        boolean exists = false;
        if (arrayOfCollectionIDs == null) {
            arrayOfCollectionIDs = new ArrayOfCollectionIDs();
            array = new String[]{};
        } else if (arrayOfCollectionIDs.getCollectionIDsArray() == null) {
            array = new String[]{};
        } else {
            for (String existingCollectionID : arrayOfCollectionIDs.getCollectionIDsArray()) {
                if (!collectionID.equals(existingCollectionID)) continue;
                log.debug((Object)("Ontology " + this.getBaseOntologyURI() + " has already reference to ollection with id " + collectionID));
                exists = true;
                break;
            }
            if (!exists) {
                array = arrayOfCollectionIDs.getCollectionIDsArray();
            }
        }
        if (!exists) {
            String[] newArray = new String[array.length + 1];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[newArray.length - 1] = collectionID;
            arrayOfCollectionIDs.setCollectionIDsArray(newArray);
            log.debug((Object)("Adding reference to collection " + collectionID + " in resource with id " + this.getID()));
            this.setReferencedCollections(arrayOfCollectionIDs);
            this.store();
        }
    }

    protected synchronized void setImportedOntologies(ArrayOfOntologies importedOntologies) throws Exception {
        this.getResourcePropertySet().get(RP_ImportedOntologies).clear();
        this.getResourcePropertySet().get(RP_ImportedOntologies).add((Object)importedOntologies);
    }

    protected synchronized void setReferencedCollections(ArrayOfCollectionIDs referencedCollectionIds) throws Exception {
        this.getResourcePropertySet().get(RP_ReferencedCollections).clear();
        this.getResourcePropertySet().get(RP_ReferencedCollections).add((Object)referencedCollectionIds);
    }

    public void setOntModel(OntModel model) {
        this.model = model;
    }

    public OntModel getOntModel() throws GCUBEFault {
        if (this.model == null) {
            try {
                log.debug((Object)"Model is ");
                this.model = OntModelManager.createOntModel(((GCUBEWSResourceKey)this.getID()).getValue(), this.getBaseOntologyURI(), null);
            }
            catch (Exception e) {
                log.error((Object)"Did not manage to get the persisted ontology model", (Throwable)e);
                throw new GCUBEUnrecoverableException("Did not manage to get the persisted ontology model", (Throwable)e).toFault(new String[0]);
            }
        }
        return this.model;
    }
}

