/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.manager;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.ontologymanagement.ontologymanagementservice.OntologyManagementServiceContext;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.DBManager;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntModelManager;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntologyManagerContext;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntologyResource;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.SearchFieldsUtils;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.TaxonomyUtils;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.AddEquivalencePropertyToIndividual;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.AddEquivalencePropertyToIndividualResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.AddOntologyClassesToGCubeIndividual;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.AddOntologyClassesToGCubeIndividualResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.AddOntologyClassesToIndividual;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.AddOntologyClassesToIndividualResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOWLIndividuals;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOWLPropertyValues;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOntologies;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.CreateIndividual;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.CreateIndividualResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.DeleteIndividualsResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.DestroyOntology;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.DestroyOntologyResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.EquivalencePropertyType;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ExportTaxonomy;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ExportTaxonomyResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.GetIndividualDescriptionResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.GetIndividuals;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.GetSearchFields;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.GetSubTaxonomy;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.GetSubTaxonomyResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ListIndividuals;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OWLClass;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OWLIndividual;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OWLProperty;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OWLPropertyType;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OWLPropertyValues;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.Ontology;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.RemoveOntologyClassFromIndividual;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.RemoveOntologyClassFromIndividualResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.SetPropertyValuesResponse;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ShortToExpandedURIs;
import org.globus.wsrf.ResourceException;

public class OntologyManager {
    public static String GCUBE_NS = "http://gcube-system.org/namespaces/ontologymanagement/ontologymanagementservice#";
    public static String GCUBE_NS_PREFIX = "gcube";
    public static String GCUBE_COLLECTION_PROPERTY_LOCAL_NAME = "CollectionID";
    public static String GCUBE_COLLECTION_PROPERTY_URI = GCUBE_NS + GCUBE_COLLECTION_PROPERTY_LOCAL_NAME;
    private static GCUBELog log = new GCUBELog(OntologyManager.class);

    public String getOntologySchemaRSXML() throws GCUBEFault {
        RSXMLWriter writer;
        OntologyResource resource = null;
        ArrayOfOntologies ontologiesArray = null;
        try {
            resource = this.getResource();
            log.debug((Object)("Resource found: Name: " + resource.getBaseOntologyName() + ", URI: " + resource.getBaseOntologyURI()));
            ontologiesArray = resource.getImportedOntologies();
            if (ontologiesArray == null || ontologiesArray.getOntologiesArray() == null || ontologiesArray.getOntologiesArray().length == 0) {
                log.error((Object)("Ontology model with base ontology uri " + resource.getBaseOntologyURI() + " does not contain any ontology."));
                throw new Exception("Ontology model with base ontology uri " + resource.getBaseOntologyURI() + " does not contain any ontology.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not get resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        try {
            writer = RSXMLWriter.getRSXMLWriter();
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSXMLWriter", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not create RSXMLWriter", (Throwable)e).toFault(new String[0]);
        }
        try {
            Ontology[] ontologies = ontologiesArray.getOntologiesArray();
            String schemasRootDirectory = DBManager.DBPATH + File.separator + ((GCUBEWSResourceKey)resource.getID()).getValue() + File.separator + "schemas" + File.separator;
            log.trace((Object)("The schemas for the model " + resource.getBaseOntologyName() + " are stored in the directory " + schemasRootDirectory));
            for (Ontology ontology : ontologies) {
                log.debug((Object)("Appending in the result set ontology with uri: " + ontology.getOntologyURI() + " from file with id " + ontology.getSchemaStorageID()));
                String path = schemasRootDirectory + ontology.getSchemaStorageID();
                String rdf = OntologyManager.stringFromInputStream(new FileInputStream(path));
                ResultElementGeneric ontologyRSElement = new ResultElementGeneric("0", "col", "1.0", rdf);
                RecordAttribute[] attrs = new RecordAttribute[]{new RecordAttribute("OntologyURI", ontology.getOntologyURI())};
                ontologyRSElement.setRecordAttributes(attrs);
                writer.addResults((ResultElementBase)ontologyRSElement);
            }
            writer.close();
            return writer.getRSLocator((RSResourceType)new RSResourceWSRFType(), OntologyManagementServiceContext.getContext().getScope()).getLocator();
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to create RS with ontologies", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to create RS with ontologies", (Throwable)e).toFault(new String[0]);
        }
    }

    private static String stringFromInputStream(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public AddEquivalencePropertyToIndividualResponse addEquivalencePropertyToIndividual(AddEquivalencePropertyToIndividual request) throws GCUBEFault {
        Individual predicate;
        Individual subject;
        OntologyResource resource;
        log.info((Object)"Adding Equivalence Property to individual...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource in context", (Throwable)e);
            throw new GCUBEUnrecoverableException("Instance service did not manage to find resource in context", (Throwable)e).toFault(new String[0]);
        }
        if (request == null || request.getSubject() == null || request.getSubject().getIndividualURI() == null || request.getSubject().getIndividualURI().trim().length() == 0 || request.getPredicate() == null || request.getPredicate().getIndividualURI() == null || request.getPredicate().getIndividualURI().trim().length() == 0 || request.getEquivalencePropertyType() == null || request.getEquivalencePropertyType().getValue() == null || request.getEquivalencePropertyType().getValue().trim().length() == 0) {
            log.error((Object)"Invalid request parameters");
            throw new GCUBEFault(new String[]{"Invalid request parameters"});
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        try {
            subject = model.getIndividual(request.getSubject().getIndividualURI());
        }
        catch (Exception e) {
            log.error((Object)("Could not search in the model for individual with uri " + request.getSubject().getIndividualURI()), (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not search in the model for individual with uri " + request.getSubject().getIndividualURI()});
        }
        if (subject == null) {
            if (!request.isCreateSubjectIfNotExist()) {
                log.error((Object)("Could not find in the model individual with uri " + request.getSubject().getIndividualURI()));
                throw new GCUBEFault(new String[]{"Could not find in the model individual with uri " + request.getSubject().getIndividualURI()});
            }
            OntClass thing = model.getOntClass(model.expandPrefix("owl:Thing"));
            subject = thing.createIndividual(request.getSubject().getIndividualURI());
            subject.addLabel(request.getSubject().getLabel(), null);
            if (subject == null) {
                log.error((Object)("Could not create subject with uri " + request.getSubject().getIndividualURI() + " in owl:Thing"));
                throw new GCUBEFault(new String[]{"Could not create subject with uri " + request.getSubject().getIndividualURI() + " in owl:Thing"});
            }
        }
        try {
            predicate = model.getIndividual(request.getPredicate().getIndividualURI());
        }
        catch (Exception e) {
            log.error((Object)("Could not search in the model for individual with uri " + request.getPredicate().getIndividualURI()), (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not search in the model for individual with uri " + request.getPredicate().getIndividualURI()});
        }
        if (predicate == null) {
            log.error((Object)("Could not find in the model individual with uri " + request.getPredicate().getIndividualURI()));
            throw new GCUBEFault(new String[]{"Could not find in the model individual with uri " + request.getPredicate().getIndividualURI()});
        }
        if (request.getEquivalencePropertyType().equals((Object)EquivalencePropertyType.sameAs)) {
            log.debug((Object)("Setting " + subject.getURI() + " sameAs " + predicate.getURI()));
            subject.addSameAs((Resource)predicate);
        } else if (request.getEquivalencePropertyType().equals((Object)EquivalencePropertyType.seeAlso)) {
            log.debug((Object)("Setting " + subject.getURI() + " seeAlso " + predicate.getURI()));
            subject.addSeeAlso((Resource)predicate);
        } else {
            log.error((Object)"Undefined EquivalencePropertyType sameAs/seeAlso only supported");
            throw new GCUBEFault(new String[]{"Undefined EquivalencePropertyType sameAs/seeAlso only supported"});
        }
        return new AddEquivalencePropertyToIndividualResponse();
    }

    public AddOntologyClassesToIndividualResponse addOntologyClassesToIndividual(AddOntologyClassesToIndividual request) throws GCUBEFault {
        Individual indi;
        OntologyResource resource;
        log.info((Object)"Adding types to individual...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource in context", (Throwable)e);
            throw new GCUBEUnrecoverableException("Instance service did not manage to find resource in context", (Throwable)e).toFault(new String[0]);
        }
        if (request == null || request.getIndividual() == null || request.getIndividual().getIndividualURI() == null || request.getIndividual().getIndividualURI().trim().length() == 0 || request.getOWLClassesArray() == null || request.getOWLClassesArray().length < 1) {
            log.error((Object)"Invalid request parameters");
            throw new GCUBEFault(new String[]{"Invalid request parameters"});
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        try {
            indi = model.getIndividual(request.getIndividual().getIndividualURI());
        }
        catch (Exception e) {
            log.error((Object)("Could not search in the model for individual with uri " + request.getIndividual().getIndividualURI()), (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not search in the model for individual with uri " + request.getIndividual().getIndividualURI()});
        }
        if (indi != null) {
            log.debug((Object)("Individual with URI " + request.getIndividual().getIndividualURI() + " exists in the model, no need to create it..."));
        }
        if (indi == null && !request.isCreateIndividualIfNotExist()) {
            log.error((Object)("Could not find in the model individual with uri " + request.getIndividual().getIndividualURI()));
            throw new GCUBEFault(new String[]{"Could not find in the model individual with uri " + request.getIndividual().getIndividualURI()});
        }
        for (OWLClass stubcls : request.getOWLClassesArray()) {
            OntClass cls;
            try {
                log.debug((Object)("Getting from model ontology class with uri " + stubcls.getClassURI()));
                cls = model.getOntClass(stubcls.getClassURI());
            }
            catch (Exception e) {
                log.error((Object)("Could not search in the model for class with uri " + stubcls.getClassURI()), (Throwable)e);
                throw new GCUBEUnrecoverableException("Could not search in the model for class with uri " + stubcls.getClassURI(), (Throwable)e).toFault(new String[0]);
            }
            if (cls == null) {
                log.error((Object)("Could not find class in the model with uri " + stubcls.getClassURI()));
                throw new GCUBEUnrecoverableException("Could not find class in the model with uri " + stubcls.getClassURI()).toFault(new String[0]);
            }
            if (indi == null) {
                try {
                    log.debug((Object)("Individual with uri " + request.getIndividual().getIndividualURI() + " does not exist in the model, creating it..."));
                    indi = cls.createIndividual(request.getIndividual().getIndividualURI());
                    indi.addLabel(request.getIndividual().getLabel(), null);
                    if (indi != null) continue;
                    log.error((Object)("Could not create individual with uri " + request.getIndividual().getIndividualURI() + ", null..."));
                    throw new Exception("Could not create individual with uri " + request.getIndividual().getIndividualURI());
                }
                catch (Exception e) {
                    log.error((Object)("Could not create individual with uri " + request.getIndividual().getIndividualURI()), (Throwable)e);
                    throw new GCUBEUnrecoverableException("Could not create individual with uri " + request.getIndividual().getIndividualURI(), (Throwable)e).toFault(new String[0]);
                }
            }
            try {
                log.debug((Object)("Adding to individual with uri " + indi.getURI() + " the type " + cls.getURI()));
                indi.addOntClass((Resource)cls);
            }
            catch (Exception e) {
                log.error((Object)("Could not add type " + stubcls.getClassURI()), (Throwable)e);
                throw new GCUBEUnrecoverableException("Could not add type " + stubcls.getClassURI(), (Throwable)e).toFault(new String[0]);
            }
        }
        return new AddOntologyClassesToIndividualResponse();
    }

    public AddOntologyClassesToGCubeIndividualResponse addOntologyClassesToGCubeIndividual(AddOntologyClassesToGCubeIndividual request) throws GCUBEFault {
        Individual indi;
        OntologyResource resource;
        log.info((Object)"Adding types to gcube individual...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource in context", (Throwable)e);
            throw new GCUBEUnrecoverableException("Instance service did not manage to find resource in context", (Throwable)e).toFault(new String[0]);
        }
        if (request == null || request.getIndividual() == null || request.getIndividual().getIndividualURI() == null || request.getIndividual().getIndividualURI().trim().length() == 0 || request.getOWLClassesArray() == null || request.getOWLClassesArray().length < 1 || request.getCollectionID() == null || request.getCollectionID().trim().length() == 0 || request.getObjectID() == null) {
            log.error((Object)"Invalid request parameters");
            throw new GCUBEFault(new String[]{"Invalid request parameters"});
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        try {
            indi = model.getIndividual(request.getIndividual().getIndividualURI());
        }
        catch (Exception e) {
            log.error((Object)("Could not search in the model for individual with uri " + request.getIndividual().getIndividualURI()), (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not search in the model for individual with uri " + request.getIndividual().getIndividualURI()});
        }
        if (indi != null) {
            log.debug((Object)("Individual with URI " + request.getIndividual().getIndividualURI() + " exists in the model, no need to create it..."));
        }
        if (indi == null && !request.isCreateIndividualIfNotExist()) {
            log.error((Object)("Could not find in the model individual with uri " + request.getIndividual().getIndividualURI()));
            throw new GCUBEFault(new String[]{"Could not find in the model individual with uri " + request.getIndividual().getIndividualURI()});
        }
        for (OWLClass stubcls : request.getOWLClassesArray()) {
            OntClass cls;
            try {
                log.debug((Object)("Getting from model ontology class with uri " + stubcls.getClassURI()));
                cls = model.getOntClass(stubcls.getClassURI());
            }
            catch (Exception e) {
                log.error((Object)("Could not search in the model for class with uri " + stubcls.getClassURI()), (Throwable)e);
                throw new GCUBEUnrecoverableException("Could not search in the model for class with uri " + stubcls.getClassURI(), (Throwable)e).toFault(new String[0]);
            }
            if (cls == null) {
                log.error((Object)("Could not find class in the model with uri " + stubcls.getClassURI()));
                throw new GCUBEUnrecoverableException("Could not find class in the model with uri " + stubcls.getClassURI()).toFault(new String[0]);
            }
            if (indi == null) {
                try {
                    log.debug((Object)("Individual with uri " + request.getIndividual().getIndividualURI() + " does not exist in the model, creating it..."));
                    indi = cls.createIndividual(request.getIndividual().getIndividualURI());
                    if (indi == null) {
                        log.error((Object)("Could not create individual with uri " + request.getIndividual().getIndividualURI() + ", null..."));
                        throw new Exception("Could not create individual with uri " + request.getIndividual().getIndividualURI());
                    }
                    indi.addLabel(request.getIndividual().getLabel(), null);
                    DatatypeProperty collectionIDProp = model.getDatatypeProperty(GCUBE_COLLECTION_PROPERTY_URI);
                    if (collectionIDProp == null) {
                        log.warn((Object)"Did not manage to find collection id property in the model, creating it now...");
                        collectionIDProp = model.createDatatypeProperty(GCUBE_COLLECTION_PROPERTY_URI);
                    }
                    indi.addProperty((Property)collectionIDProp, request.getCollectionID());
                    resource.putReferencedCollectionID(request.getCollectionID());
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Could not create individual with uri " + request.getIndividual().getIndividualURI()), (Throwable)e);
                    throw new GCUBEUnrecoverableException("Could not create individual with uri " + request.getIndividual().getIndividualURI(), (Throwable)e).toFault(new String[0]);
                }
            }
            try {
                log.debug((Object)("Adding to individual with uri " + indi.getURI() + " the type " + cls.getURI()));
                indi.addOntClass((Resource)cls);
            }
            catch (Exception e) {
                log.error((Object)("Could not add type " + stubcls.getClassURI()), (Throwable)e);
                throw new GCUBEUnrecoverableException("Could not add type " + stubcls.getClassURI(), (Throwable)e).toFault(new String[0]);
            }
        }
        return new AddOntologyClassesToGCubeIndividualResponse();
    }

    public RemoveOntologyClassFromIndividualResponse removeOntologyClassFromIndividual(RemoveOntologyClassFromIndividual request) throws GCUBEFault {
        OntClass ontClass;
        Individual indi;
        OntologyResource resource;
        log.info((Object)"Removing types from gcube individual...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource in context", (Throwable)e);
            throw new GCUBEUnrecoverableException("Instance service did not manage to find resource in context", (Throwable)e).toFault(new String[0]);
        }
        if (request == null || request.getIndividualURI() == null || request.getClassURI() == null || request.getIndividualURI().trim().length() == 0 || request.getClassURI().trim().length() == 0) {
            log.error((Object)"Invalid request parameters");
            throw new GCUBEFault(new String[]{"Invalid request parameters"});
        }
        String individualURI = request.getIndividualURI();
        String classURI = request.getClassURI();
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        try {
            indi = model.getIndividual(individualURI);
        }
        catch (Exception e) {
            log.error((Object)("Could not search in the model for individual with uri " + individualURI), (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not search in the model for individual with uri " + individualURI});
        }
        if (indi == null) {
            log.debug((Object)("Individual with URI " + individualURI + " does not exist in the model..."));
            throw new GCUBEFault(new String[]{"Individual with URI " + individualURI + " does not exist in the model"});
        }
        try {
            ontClass = model.getOntClass(classURI);
        }
        catch (Exception e) {
            log.error((Object)("Could not search in the model for class with uri " + classURI), (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not search in the model for class with uri " + classURI});
        }
        if (ontClass == null) {
            log.debug((Object)("Class with URI " + classURI + " does not exist in the model..."));
            throw new GCUBEFault(new String[]{"Class with URI " + classURI + " does not exist in the model"});
        }
        try {
            indi.removeOntClass((Resource)ontClass);
        }
        catch (Exception e) {
            log.error((Object)("Did not manage to remove class with uri " + classURI + " from individual " + individualURI));
            throw new GCUBEFault(new String[]{"Did not manage to remove class with uri " + classURI + " from individual " + individualURI});
        }
        log.debug((Object)("Class with uri " + classURI + " removed successfully from individual " + individualURI));
        return new RemoveOntologyClassFromIndividualResponse();
    }

    public CreateIndividualResponse createIndividual(CreateIndividual request) throws GCUBEFault {
        OntologyResource resource;
        log.info((Object)"Creating individual...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        if (request == null || request.getClassURI() == null || request.getIndividualName() == null) {
            log.error((Object)"Class uri or indiviudal name not set");
            throw new GCUBEFault(new String[]{"Class uri or indiviudal name not set"});
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        try {
            OntClass cls = model.getOntClass(request.getClassURI());
            Individual indi = cls.createIndividual(cls.getNameSpace() + request.getIndividualName());
            if (indi == null) {
                log.error((Object)("Individual with name " + request.getIndividualName() + " for ontology " + resource.getBaseOntologyURI() + " could not be created, null"));
                throw new Exception("Individual with name " + request.getIndividualName() + " for ontology " + resource.getBaseOntologyURI() + " could not be created, null");
            }
            CreateIndividualResponse response = new CreateIndividualResponse();
            response.setIndividualURI(indi.getURI());
            return response;
        }
        catch (Exception e) {
            log.error((Object)("Could not create new individual with name " + request.getIndividualName() + " for ontology " + resource.getBaseOntologyURI()), (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public ArrayOfOWLIndividuals getIndividuals(GetIndividuals request) throws GCUBEFault {
        OntologyResource resource;
        log.info((Object)"Getting individuals from model...");
        if (request == null || request.getOWLClassesArray() == null || request.getOWLClassesArray().length == 0) {
            log.error((Object)"No OWL classes are set to the request");
            throw new GCUBEFault(new String[]{"No OWL classes are set to the request"});
        }
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        boolean direct = request.isDirect();
        log.debug((Object)("Searching for individuals with direct=" + direct));
        ArrayOfOWLIndividuals response = new ArrayOfOWLIndividuals();
        ArrayList<OWLIndividual> individuals = new ArrayList<OWLIndividual>();
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        for (OWLClass owlcls : request.getOWLClassesArray()) {
            try {
                if (owlcls.getClassURI() == null) {
                    log.error((Object)"Class URI is null");
                    continue;
                }
                OntClass cls = model.getOntClass(owlcls.getClassURI());
                if (cls == null) {
                    log.error((Object)("Could not find class " + owlcls.getClassURI() + " in ontology " + resource.getBaseOntologyURI()));
                    throw new GCUBEFault(new String[]{"Could not find class " + owlcls.getClassURI() + " in ontology " + resource.getBaseOntologyURI()});
                }
                ExtendedIterator it = cls.listInstances(direct);
                boolean hasIndividuals = false;
                while (it.hasNext()) {
                    hasIndividuals = true;
                    Individual inst = (Individual)it.next();
                    String uri = inst.getURI();
                    String label = inst.getLabel(null);
                    OWLIndividual owlindi = new OWLIndividual();
                    if (direct) {
                        log.debug((Object)("Just searching for direct indivuals clsURI=" + owlcls.getClassURI()));
                        owlindi.setClassURI(owlcls.getClassURI());
                    } else {
                        ExtendedIterator clsit = inst.listOntClasses(true);
                        while (clsit.hasNext()) {
                            OntClass subcls = (OntClass)clsit.next();
                            if (subcls.equals(cls)) {
                                log.debug((Object)("Individual " + uri + " is direct instance of " + cls.getURI()));
                                owlindi.setClassURI(subcls.getURI());
                                break;
                            }
                            if (!subcls.hasSuperClass((Resource)cls)) continue;
                            log.debug((Object)("Searching for non-direct individuals clsURI=" + owlcls.getClassURI()));
                            owlindi.setClassURI(subcls.getURI());
                            break;
                        }
                        if (owlindi.getClassURI() == null) {
                            log.debug((Object)("Individual " + uri + " does not belong to any class or subclass of the range " + cls.getURI() + ", setting this..."));
                            owlindi.setClassURI(cls.getURI());
                        }
                    }
                    owlindi.setIndividualURI(uri);
                    owlindi.setLabel(label);
                    individuals.add(owlindi);
                    log.info((Object)("Individual found " + inst.getURI()));
                }
                if (hasIndividuals) continue;
                if (direct) {
                    log.debug((Object)("Class " + cls.getURI() + " does not have any Direct Individuals"));
                    continue;
                }
                log.debug((Object)("Class " + cls.getURI() + " does not have any Individuals"));
            }
            catch (Exception e) {
                log.error((Object)("Could not get individuals for ontology " + resource.getBaseOntologyURI() + " and class " + owlcls.getClassURI()), (Throwable)e);
            }
        }
        response.setOWLIndividualsArray(individuals.toArray(new OWLIndividual[individuals.size()]));
        return response;
    }

    public GetIndividualDescriptionResponse getIndividualDescription(OWLIndividual individual) throws GCUBEFault {
        OntologyResource resource;
        if (individual == null || individual.getIndividualURI() == null) {
            log.error((Object)"Invalid parameters in getIndividualDescription");
            throw new GCUBEFault(new String[]{"Invalid parameters in getIndividualDescription"});
        }
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        Individual indi = model.getIndividual(individual.getIndividualURI());
        if (indi == null) {
            log.error((Object)("Could not find individual with URI " + individual.getIndividualURI() + " in the model"));
            throw new GCUBEFault(new String[]{"Could not find individual with URI " + individual.getIndividualURI() + " in the model"});
        }
        individual.setLabel(indi.getLabel(null));
        GetIndividualDescriptionResponse response = new GetIndividualDescriptionResponse();
        response.setIndividual(individual);
        log.debug((Object)"Listing the classes that the individual belongs...");
        ExtendedIterator it = indi.listOntClasses(true);
        ArrayList<OWLClass> typesOfIndividual = new ArrayList<OWLClass>();
        while (it.hasNext()) {
            OntClass cls = (OntClass)it.next();
            OWLClass cls_stub = new OWLClass();
            log.debug((Object)("Type found: " + cls.getURI()));
            cls_stub.setClassURI(cls.getURI());
            typesOfIndividual.add(cls_stub);
        }
        response.setOWLClassesArray(typesOfIndividual.toArray(new OWLClass[typesOfIndividual.size()]));
        log.debug((Object)"Listing the sameAs individuals...");
        ArrayList<OWLIndividual> sameAsIndividuals = new ArrayList<OWLIndividual>();
        ExtendedIterator itsame = indi.listSameAs();
        while (itsame.hasNext()) {
            OntResource ontresource = (OntResource)itsame.next();
            if (ontresource.isIndividual()) {
                Individual sameAsIndi = ontresource.asIndividual();
                OWLIndividual sameAsIndi_stub = new OWLIndividual();
                log.debug((Object)("SameAs Individual found: " + sameAsIndi.getURI()));
                sameAsIndi_stub.setIndividualURI(sameAsIndi.getURI());
                sameAsIndi_stub.setLabel(sameAsIndi.getLabel(null));
                sameAsIndividuals.add(sameAsIndi_stub);
                continue;
            }
            log.error((Object)"Individual same with a resource that is not individual");
        }
        response.setSameAsIndividuals(sameAsIndividuals.toArray(new OWLIndividual[sameAsIndividuals.size()]));
        log.debug((Object)"Listing the seeAlso individuals...");
        ArrayList<OWLIndividual> seeAlsoIndividuals = new ArrayList<OWLIndividual>();
        ExtendedIterator italso = indi.listSeeAlso();
        while (italso.hasNext()) {
            OntResource ontresource = (OntResource)italso.next();
            if (ontresource.isIndividual()) {
                Individual seeAlsoIndi = ontresource.asIndividual();
                OWLIndividual seeAlsoIndi_stub = new OWLIndividual();
                log.debug((Object)("SeeAlso Individual found: " + seeAlsoIndi.getURI()));
                seeAlsoIndi_stub.setIndividualURI(seeAlsoIndi.getURI());
                seeAlsoIndi_stub.setLabel(seeAlsoIndi.getLabel(null));
                seeAlsoIndividuals.add(seeAlsoIndi_stub);
                continue;
            }
            log.error((Object)"Individual see also relationship with a resource that is not individual. Not an error?");
        }
        response.setSeeAlsoIndividuals(seeAlsoIndividuals.toArray(new OWLIndividual[seeAlsoIndividuals.size()]));
        return response;
    }

    public DeleteIndividualsResponse deleteIndividuals(ArrayOfOWLIndividuals request) throws GCUBEFault {
        OntologyResource resource;
        log.info((Object)"Deleting individuals...");
        if (request == null || request.getOWLIndividualsArray() == null || request.getOWLIndividualsArray().length == 0) {
            log.error((Object)"No Individual URIs set to delete");
            throw new GCUBEFault(new String[]{"No Individual URIs set to delete"});
        }
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        for (OWLIndividual individual : request.getOWLIndividualsArray()) {
            log.info((Object)("Going to delete individual with URI " + individual.getIndividualURI()));
            try {
                Individual indi = model.getIndividual(individual.getIndividualURI());
                if (indi == null) {
                    log.error((Object)("Could not find instance with URI " + individual.getIndividualURI() + " in ontology " + resource.getBaseOntologyURI() + " in order to delete it."));
                }
                indi.remove();
                log.debug((Object)("Instance with URI " + individual.getIndividualURI() + " deleted successfully from the ontology " + resource.getBaseOntologyURI()));
            }
            catch (Exception e) {
                log.error((Object)("Could not delete instance with URI " + individual.getIndividualURI() + " in ontology " + resource.getBaseOntologyURI()), (Throwable)e);
            }
        }
        return new DeleteIndividualsResponse();
    }

    public ArrayOfOWLPropertyValues getDeclaredPropertyValues(ArrayOfOWLIndividuals request) throws GCUBEFault {
        OntologyResource resource;
        log.info((Object)"Getting individuals from model...");
        if (request == null || request.getOWLIndividualsArray() == null || request.getOWLIndividualsArray().length == 0) {
            log.error((Object)"No OWL classes are set to the request");
            throw new GCUBEFault(new String[]{"No OWL classes are set to the request"});
        }
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        ArrayOfOWLPropertyValues response = new ArrayOfOWLPropertyValues();
        ArrayList<OWLPropertyValues> arrayOfValues = new ArrayList<OWLPropertyValues>();
        for (OWLIndividual owlindi : request.getOWLIndividualsArray()) {
            try {
                if (owlindi.getIndividualURI() == null) {
                    log.error((Object)("IndividualURI = " + owlindi.getIndividualURI() + " is not set"));
                    continue;
                }
                Individual indi = model.getIndividual(owlindi.getIndividualURI());
                if (indi == null) {
                    log.error((Object)("Could not find individual with uri " + owlindi.getIndividualURI() + " in the model, continueing..."));
                    continue;
                }
                log.debug((Object)("Checking individual " + indi.getURI()));
                ExtendedIterator it = indi.listOntClasses(true);
                HashSet<String> checkedPropertyURIs = new HashSet<String>();
                while (it.hasNext()) {
                    OntClass cls = (OntClass)it.next();
                    log.debug((Object)("Indivual is instance of class: " + cls.getURI()));
                    ExtendedIterator propit = cls.listDeclaredProperties();
                    while (propit.hasNext()) {
                        String val;
                        RDFNode node;
                        NodeIterator vit;
                        OntProperty prop = (OntProperty)propit.next();
                        if (checkedPropertyURIs.contains(prop.getURI()) || GCUBE_COLLECTION_PROPERTY_URI.equals(prop.getURI())) continue;
                        checkedPropertyURIs.add(prop.getURI());
                        OWLPropertyValues owlvalues = new OWLPropertyValues();
                        OWLProperty property = new OWLProperty();
                        if (prop.getDomain() != null) {
                            property.setDomain(prop.getDomain().getURI());
                        }
                        property.setPropertyURI(prop.getURI());
                        owlindi.setClassURI(cls.getURI());
                        owlvalues.setOWLIndividual(owlindi);
                        owlvalues.setOWLProperty(property);
                        ArrayList<String> values = new ArrayList<String>();
                        if (prop.isDatatypeProperty()) {
                            log.debug((Object)("DataType property found: " + prop.getURI()));
                            property.setType(OWLPropertyType.datatypeProperty);
                            if (prop.asDatatypeProperty().getRange() != null) {
                                property.setRange(prop.asDatatypeProperty().getRange().getURI());
                            }
                            vit = indi.listPropertyValues((Property)prop);
                            while (vit.hasNext()) {
                                node = (RDFNode)vit.next();
                                if (node.isLiteral()) {
                                    val = ((Literal)node).getString();
                                    log.debug((Object)("Literal value found: " + val));
                                    values.add(val);
                                    continue;
                                }
                                log.warn((Object)"Value in a datatype property found which is not a literal");
                            }
                        } else if (prop.isObjectProperty()) {
                            log.debug((Object)("Object property found: " + prop.getURI()));
                            property.setType(OWLPropertyType.objectProperty);
                            if (prop.asObjectProperty().getRange() != null) {
                                property.setRange(prop.asObjectProperty().getRange().getURI());
                            }
                            vit = indi.listPropertyValues((Property)prop);
                            while (vit.hasNext()) {
                                node = (RDFNode)vit.next();
                                if (node.isURIResource()) {
                                    log.debug((Object)("URIResource found: " + ((Resource)node).getURI()));
                                    val = ((Resource)node).getURI();
                                    values.add(val);
                                    continue;
                                }
                                log.debug((Object)"Value in an object property found which is not a URI Resource");
                            }
                        } else {
                            if (prop.isAnnotationProperty()) {
                                property.setType(OWLPropertyType.annotationProperty);
                            } else if (prop.isFunctionalProperty()) {
                                property.setType(OWLPropertyType.functionalProperty);
                            } else if (prop.isInverseFunctionalProperty()) {
                                property.setType(OWLPropertyType.inverseFunctionalProperty);
                            } else if (prop.isSymmetricProperty()) {
                                property.setType(OWLPropertyType.symmetricProperty);
                            } else if (prop.isTransitiveProperty()) {
                                property.setType(OWLPropertyType.transitiveProperty);
                            }
                            log.warn((Object)("Other type of property: " + prop.getURI()));
                        }
                        owlvalues.setValues(values.toArray(new String[values.size()]));
                        arrayOfValues.add(owlvalues);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not get values of the individual " + owlindi.getIndividualURI()), (Throwable)e);
            }
        }
        response.setOWLPropertyValuesArray(arrayOfValues.toArray(new OWLPropertyValues[arrayOfValues.size()]));
        return response;
    }

    public SetPropertyValuesResponse setPropertyValues(ArrayOfOWLPropertyValues request) throws GCUBEFault {
        OntologyResource resource;
        log.info((Object)"Getting individuals from model...");
        if (request == null || request.getOWLPropertyValuesArray() == null || request.getOWLPropertyValuesArray().length == 0) {
            log.error((Object)"No OWL classes are set to the request");
            throw new GCUBEFault(new String[]{"No OWL classes are set to the request"});
        }
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
        OntModel model = resource.getOntModel();
        for (OWLPropertyValues propvalue : request.getOWLPropertyValuesArray()) {
            try {
                if (propvalue.getOWLIndividual() == null) {
                    log.error((Object)"OWLIndividual is not set in this OWLPropertyValues object, getting next...");
                    continue;
                }
                if (propvalue.getOWLIndividual().getIndividualURI() == null || propvalue.getOWLProperty().getPropertyURI() == null) {
                    log.error((Object)("IndividualURI = " + propvalue.getOWLIndividual().getIndividualURI() + " or " + "PropertyURI = " + propvalue.getOWLProperty().getPropertyURI() + " is null..."));
                    continue;
                }
                log.debug((Object)("Setting to the individual " + propvalue.getOWLIndividual().getIndividualURI() + " the property " + propvalue.getOWLProperty().getPropertyURI()));
                Individual indi = model.getIndividual(propvalue.getOWLIndividual().getIndividualURI());
                if (indi == null) {
                    log.error((Object)("Could not get individual with uri " + propvalue.getOWLIndividual().getIndividualURI()));
                    continue;
                }
                OntProperty prop = model.getOntProperty(propvalue.getOWLProperty().getPropertyURI());
                if (prop == null) {
                    log.error((Object)("Could not find property with uri " + propvalue.getOWLIndividual().getIndividualURI()));
                    continue;
                }
                indi.setPropertyValue((Property)prop, null);
                if (prop.isObjectProperty()) {
                    for (String value : propvalue.getValues()) {
                        Individual object = model.getIndividual(value);
                        if (object != null) {
                            log.debug((Object)("Setting value " + value + " to the object property " + prop.getURI()));
                            indi.addProperty((Property)prop, (RDFNode)object);
                            continue;
                        }
                        log.error((Object)("Resource with URI " + value + " does not exist"));
                    }
                    continue;
                }
                if (!prop.isDatatypeProperty()) continue;
                for (String value : propvalue.getValues()) {
                    log.debug((Object)("Setting value " + value + " to the datatype property " + prop.getURI()));
                    indi.addProperty((Property)prop, value);
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not set values to the property " + propvalue.getOWLProperty().getPropertyURI()), (Throwable)e);
            }
        }
        return new SetPropertyValuesResponse();
    }

    public DestroyOntologyResponse destroyOntology(DestroyOntology request) {
        return new DestroyOntologyResponse();
    }

    private OntologyResource getResource() throws ResourceException {
        return (OntologyResource)OntologyManagerContext.getPortTypeContext().getWSHome().find();
    }

    public String listIndividuals(ListIndividuals request) throws GCUBEFault {
        RSXMLWriter writer;
        OntologyResource resource;
        log.info((Object)"Returning individuals from model...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        try {
            writer = RSXMLWriter.getRSXMLWriter();
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSXMLWriter", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not create RSXMLWriter", (Throwable)e).toFault(new String[0]);
        }
        try {
            log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
            OntModel model = resource.getOntModel();
            ExtendedIterator it = model.listIndividuals();
            while (it.hasNext()) {
                Individual indi = (Individual)it.next();
                ResultElementGeneric individualRSElement = new ResultElementGeneric("0", "col", "1.0", "<empty>e</empty>");
                ArrayList<RecordAttribute> attrslist = new ArrayList<RecordAttribute>();
                attrslist.add(new RecordAttribute("IndividualURI", indi.getURI()));
                String label = indi.getLabel(null);
                if (label != null && label.trim().length() > 0) {
                    attrslist.add(new RecordAttribute("Label", label));
                }
                ExtendedIterator clsit = indi.listOntClasses(true);
                while (clsit.hasNext()) {
                    OntClass cls = (OntClass)clsit.next();
                    attrslist.add(new RecordAttribute("ClassURI", cls.getURI()));
                }
                individualRSElement.setRecordAttributes(attrslist.toArray(new RecordAttribute[attrslist.size()]));
                writer.addResults((ResultElementBase)individualRSElement);
            }
            writer.close();
            return writer.getRSLocator((RSResourceType)new RSResourceWSRFType(), OntologyManagementServiceContext.getContext().getScope()).getLocator();
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to create RS with ontology individuals", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to create RS with ontology individuals", (Throwable)e).toFault(new String[0]);
        }
    }

    public ExportTaxonomyResponse exportTaxonomy(ExportTaxonomy request) throws GCUBEFault {
        OntologyResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        ArrayList<ShortToExpandedURIs> shortToExpandedList = new ArrayList<ShortToExpandedURIs>();
        ExportTaxonomyResponse response = new ExportTaxonomyResponse();
        try {
            log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
            OntModel model = resource.getOntModel();
            Map prefixMap = model.getNsPrefixMap();
            for (Map.Entry entry : prefixMap.entrySet()) {
                log.debug((Object)("Short form: " + (String)entry.getKey() + " --> " + (String)entry.getValue()));
                shortToExpandedList.add(new ShortToExpandedURIs((String)entry.getValue(), (String)entry.getKey()));
            }
            response.setShortToExpandedFormURIs(shortToExpandedList.toArray(new ShortToExpandedURIs[shortToExpandedList.size()]));
            String taxonomy = OntModelManager.getTaxonomy(((GCUBEWSResourceKey)resource.getID()).getValue());
            if (taxonomy == null) {
                log.debug((Object)("Trying to create taxonomy for model: " + resource.getBaseOntologyName()));
                taxonomy = TaxonomyUtils.createClassTree(model);
                log.debug((Object)"Taxonomy for model created successfully");
                OntModelManager.persistTaxonomy(((GCUBEWSResourceKey)resource.getID()).getValue(), taxonomy);
            }
            response.setTaxonomyTree(taxonomy);
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to create taxonomy of the ontology model", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to create taxonomy of the ontology model", (Throwable)e).toFault(new String[0]);
        }
    }

    public GetSubTaxonomyResponse getSubTaxonomy(GetSubTaxonomy request) throws GCUBEFault {
        OntologyResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        try {
            OntModel model = resource.getOntModel();
            OntClass parentOntClass = model.getOntClass(request.getParentClassURI());
            GetSubTaxonomyResponse response = new GetSubTaxonomyResponse();
            String taxonomy = TaxonomyUtils.createSubTaxonomyTree(model, parentOntClass);
            response.setSubTaxonomyTree(taxonomy);
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to create sub taxonomy tree", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to create sub taxonomy tree", (Throwable)e).toFault(new String[0]);
        }
    }

    public String search(String queryString) throws GCUBEFault {
        OntologyResource resource;
        log.debug((Object)("Request to execute query: " + queryString));
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Stateful service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        try {
            String resultVar;
            Query query;
            final RSXMLWriter writer = RSXMLWriter.getRSXMLWriter();
            log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
            final OntModel model = resource.getOntModel();
            try {
                query = QueryFactory.create((String)queryString);
                resultVar = query.getResultVars().get(0).toString().trim();
                log.trace((Object)("Result var of the query is: " + resultVar));
            }
            catch (Exception e2) {
                log.error((Object)"Invalid query received", (Throwable)e2);
                throw new Exception("Invalid query received", e2);
            }
            final DatatypeProperty collectionIDProp = model.getDatatypeProperty(GCUBE_COLLECTION_PROPERTY_URI);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        switch (query.getQueryType()) {
                            case 111: {
                                QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
                                ResultSet results = qe.execSelect();
                                String colid = "foo";
                                String rank = "1.0";
                                int resultsNum = 0;
                                while (results.hasNext()) {
                                    QuerySolution sol = results.nextSolution();
                                    Resource result = sol.getResource(resultVar);
                                    log.trace((Object)("Result found with uri: " + result.getURI()));
                                    if (result.getURI() == null) {
                                        log.trace((Object)"Nulll...");
                                        continue;
                                    }
                                    if (!result.getURI().startsWith(GCUBE_NS)) {
                                        log.trace((Object)("Result found with uri " + result.getURI() + " and namespace " + result.getNameSpace() + " which is not a gcube IO, continuing..."));
                                        continue;
                                    }
                                    if (!result.hasProperty((Property)collectionIDProp)) {
                                        log.trace((Object)"Result does not contain collection property");
                                        continue;
                                    }
                                    colid = result.getProperty((Property)collectionIDProp).getObject().toString().trim();
                                    log.trace((Object)("Result is contained in collection: " + colid));
                                    String objectID = result.getURI().split("#")[1];
                                    StringBuffer payloadbuf = new StringBuffer();
                                    payloadbuf.append("<Properties>");
                                    StmtIterator iter = result.listProperties();
                                    while (iter.hasNext()) {
                                        Statement stmt = iter.nextStatement();
                                        Property predicate = stmt.getPredicate();
                                        RDFNode object = stmt.getObject();
                                        log.trace((Object)("Property found in result: " + stmt.asTriple().toString()));
                                        payloadbuf.append("<Property>");
                                        payloadbuf.append("<Type>" + predicate.toString() + "</Type>");
                                        payloadbuf.append("<Value>" + object.toString() + "</Value>");
                                        payloadbuf.append("</Property>");
                                    }
                                    payloadbuf.append("</Properties>");
                                    writer.addResults((ResultElementBase)new ResultElementGeneric(objectID, colid, rank, payloadbuf.toString()));
                                    ++resultsNum;
                                }
                                qe.close();
                                log.debug((Object)("The final number of results is: " + resultsNum));
                                return;
                            }
                            default: {
                                System.out.println("Only select queries executed");
                                return;
                            }
                        }
                    }
                    catch (Exception e1) {
                        log.error((Object)"Thread did not manage to perform query", (Throwable)e1);
                        return;
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (Exception e) {
                            log.error((Object)"Did not manage to close the rs writer", (Throwable)e);
                        }
                    }
                }
            }.start();
            return writer.getRSLocator((RSResourceType)new RSResourceWSRFType(), OntologyManagementServiceContext.getContext().getScope()).getLocator();
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to perform query", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to perform query", (Throwable)e).toFault(new String[0]);
        }
    }

    public String getSearchFields(GetSearchFields request) throws GCUBEFault {
        OntologyResource resource;
        log.trace((Object)"Going to get the search fields...");
        try {
            resource = this.getResource();
        }
        catch (ResourceException e) {
            log.error((Object)"Instance service did not manage to find resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        try {
            log.debug((Object)("Getting ontology model for resource " + ((GCUBEWSResourceKey)resource.getID()).getValue()));
            OntModel model = resource.getOntModel();
            String searchFields = OntModelManager.getSearchFields(((GCUBEWSResourceKey)resource.getID()).getValue());
            if (searchFields == null) {
                log.debug((Object)("Trying to create search fields for model: " + resource.getBaseOntologyName()));
                searchFields = SearchFieldsUtils.createSearchFields(model);
                log.debug((Object)"Search fields for model created successfully");
                OntModelManager.persistSearchFields(((GCUBEWSResourceKey)resource.getID()).getValue(), searchFields);
            } else {
                log.debug((Object)"Search fields already created");
            }
            return searchFields;
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to create search fields of the ontology model", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to create search fields of the ontology model", (Throwable)e).toFault(new String[0]);
        }
    }
}

