/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.factory;

import com.hp.hpl.jena.ontology.OntModel;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.ontologymanagement.ontologymanagementservice.OntologyManagementServiceContext;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.DBManager;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntModelManager;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntologyManagerContext;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntologyResource;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfCollectionIDs;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOntologies;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOntologyDescriptions;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.GetAvailableOntologies;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.Ontology;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OntologyDescription;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OntologyDescriptionAndURL;

public class OntologyManagerFactory {
    private static GCUBELog log = new GCUBELog(OntologyManagerFactory.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public static void init() throws Exception {
        log.debug((Object)"Initializing Local DataBase in which OntModels will be persisted");
        try {
            log.debug((Object)("Persistent root is located at: " + OntologyManagementServiceContext.getContext().getPersistenceRoot().getAbsolutePath()));
            DBManager.init(OntologyManagementServiceContext.getContext().getPersistenceRoot().getAbsolutePath());
        }
        catch (Throwable e) {
            log.fatal((Object)"Did not manage to initialize database", e);
            throw new Exception("Did not manage to initialize database", e);
        }
    }

    public EndpointReferenceType importOntologyURL(OntologyDescriptionAndURL request) throws GCUBEFault {
        log.debug((Object)"ImportOntologyURLResponse method invoked...");
        if (request == null || request.getOntologyDescription() == null || request.getOntologyDescription().getOntologyName() == null || request.getOntologyDescription().getOntologyName().trim().length() == 0 || request.getOntologyDescription().getOntologyURI() == null || request.getOntologyDescription().getOntologyURI().trim().length() == 0) {
            log.error((Object)"Ontology Description not propertly set");
            throw new GCUBEFault(new String[]{"Ontology Description not propertly set"});
        }
        if (request.getOntologyURL() == null || request.getOntologyURL().trim().length() == 0) {
            log.error((Object)"Ontology URL not propertly set");
            throw new GCUBEFault(new String[]{"Ontology URL not propertly set"});
        }
        String ontologyURL = request.getOntologyURL();
        String baseOntologyURI = request.getOntologyDescription().getOntologyURI();
        String baseOntologyName = request.getOntologyDescription().getOntologyName();
        ISClient client = null;
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get ISClient Implementation", (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not get ISClient Implementation"});
        }
        GCUBEScope scope = OntologyManagementServiceContext.getContext().getScope();
        log.debug((Object)("Searching for resource in scope " + scope));
        List rpdocs = null;
        try {
            String filter = "$result/child::*[local-name()='BaseOntologyURI' and namespace-uri(.)='" + OntologyManagerContext.getPortTypeContext().getNamespace().trim() + "']/string() eq '" + baseOntologyURI.trim() + "'";
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addGenericCondition(filter);
            rpdocs = client.execute((ISQuery)gquery, scope);
        }
        catch (Exception e) {
            log.error((Object)("Failed to check if WS-Resource with uri " + baseOntologyURI.trim() + " already exist"), (Throwable)e);
            throw new GCUBEFault(new String[]{"Failed to check if WS-Resource with uri " + baseOntologyURI.trim() + " already exist"});
        }
        if (rpdocs.size() != 0) {
            throw new GCUBEFault(new String[]{"Ontology with uri " + baseOntologyURI.trim() + " already exists in scope " + scope});
        }
        log.info((Object)("Ontology with uri " + baseOntologyURI.trim() + " does not exist in scope " + scope));
        String resourceID = uuidGen.nextUUID();
        OntologyResource resource = null;
        EndpointReferenceType endpoint = null;
        try {
            log.debug((Object)"Going to get a URL object...");
            URL url = new URL(ontologyURL);
            URLConnection connection = url.openConnection();
            InputStream stream = connection.getInputStream();
            OntModel model = OntModelManager.createOntModel(resourceID, baseOntologyURI, stream);
            Map<String, String> ontologyToStorageIDMap = OntModelManager.persistSchemaOfOntModel(model, resourceID, baseOntologyURI);
            ArrayOfOntologies persistedOntologiesArray = new ArrayOfOntologies();
            ArrayList<Ontology> persistedOntologiesArrayList = new ArrayList<Ontology>();
            for (Map.Entry<String, String> persistedOntology : ontologyToStorageIDMap.entrySet()) {
                persistedOntologiesArrayList.add(new Ontology(persistedOntology.getKey(), persistedOntology.getValue()));
            }
            persistedOntologiesArray.setOntologiesArray(persistedOntologiesArrayList.toArray(new Ontology[persistedOntologiesArrayList.size()]));
            GCUBEStatefulPortTypeContext ptcxt = OntologyManagerContext.getPortTypeContext();
            ArrayOfCollectionIDs collectionIDs = new ArrayOfCollectionIDs();
            collectionIDs.setCollectionIDsArray(new String[0]);
            resource = (OntologyResource)ptcxt.getWSHome().create(ptcxt.makeKey(resourceID), new Object[]{baseOntologyName, baseOntologyURI, persistedOntologiesArray, collectionIDs});
            resource.setOntModel(model);
            resource.store();
            endpoint = resource.getEPR();
            log.debug((Object)("Managed to create resource " + endpoint.toString()));
            if (resource == null || endpoint == null) {
                log.error((Object)"Did not manage to create ontology resource");
                throw new Exception("Did not manage to create ontology resource");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Did not manage to create ontology model", e);
            throw new GCUBEUnrecoverableException("Did not manage to create ontology model", e).toFault(new String[0]);
        }
        return endpoint;
    }

    public ArrayOfOntologyDescriptions getAvailableOntologies(GetAvailableOntologies params) throws GCUBEFault {
        log.debug((Object)"GetAvailableOntologies method invoked...");
        ISClient client = null;
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get ISClient Implementation", (Throwable)e);
            throw new GCUBEFault(new String[]{"Could not get ISClient Implementation"});
        }
        GCUBEScope scope = OntologyManagementServiceContext.getContext().getScope();
        log.debug((Object)("Getting Available Ontologies in scope " + scope.toString()));
        try {
            ArrayList<OntologyDescription> ontologyDescriptions = new ArrayList<OntologyDescription>();
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "OntologyManagementService")});
            List rpdocs = client.execute((ISQuery)gquery, scope);
            if (rpdocs.size() == 0) {
                log.warn((Object)"There are no ontologies available...");
            } else {
                for (RPDocument doc : rpdocs) {
                    try {
                        String ontologyName = ((String)doc.evaluate("//*[local-name() = 'BaseOntologyName']/text()").get(0)).trim();
                        String ontologyURI = ((String)doc.evaluate("//*[local-name() = 'BaseOntologyURI']/text()").get(0)).trim();
                        log.debug((Object)("Ontology found: " + ontologyName + " - " + ontologyURI));
                        ontologyDescriptions.add(new OntologyDescription(ontologyName, ontologyURI));
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not evaluate ontology name and ontology uri, continuing...", (Throwable)e);
                    }
                }
            }
            ArrayOfOntologyDescriptions response = new ArrayOfOntologyDescriptions();
            response.setOntologyDescriptions(ontologyDescriptions.toArray(new OntologyDescription[ontologyDescriptions.size()]));
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get the WS-Resource", (Throwable)e);
            throw new GCUBEUnrecoverableException("Failed to get the WS-Resources", (Throwable)e).toFault(new String[0]);
        }
    }

    public EndpointReferenceType getOntologyManager(String ontologyURI) throws GCUBEFault {
        log.debug((Object)"GetOntologyManager method invoked...");
        ISClient client = null;
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get ISClient Implementation", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not get ISClient Implementation", (Throwable)e).toFault(new String[0]);
        }
        GCUBEScope scope = OntologyManagementServiceContext.getContext().getScope();
        log.debug((Object)("Searching for resource in scope " + scope.toString()));
        List rpdocs = null;
        try {
            String filter = "$result/child::*[local-name()='BaseOntologyURI' and namespace-uri(.)='" + OntologyManagerContext.getPortTypeContext().getNamespace().trim() + "']/string() eq '" + ontologyURI.trim() + "'";
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addGenericCondition(filter);
            rpdocs = client.execute((ISQuery)gquery, scope);
        }
        catch (Exception e) {
            log.error((Object)"Failed to get the WS-Resource", (Throwable)e);
            throw new GCUBEUnrecoverableException("Failed to get the WS-Resources", (Throwable)e).toFault(new String[0]);
        }
        if (rpdocs.size() == 0) {
            log.error((Object)("Ontology with uri " + ontologyURI + " does not exist in scope " + scope.toString()));
            throw new GCUBEFault(new String[]{"Ontology with uri " + ontologyURI + " does not exist in scope " + scope.toString()});
        }
        if (rpdocs.size() > 1) {
            log.warn((Object)("More than one WS-Resources exist for ontology with uri " + ontologyURI));
        }
        return ((RPDocument)rpdocs.get(0)).getEndpoint();
    }
}

