/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.manager;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.DBManager;
import org.gcube.ontologymanagement.ontologymanagementservice.manager.OntologyManager;

public class OntModelManager {
    private static GCUBELog log = new GCUBELog(OntModelManager.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    public static String taxonomyFileName = "OMSTaxonomy";
    public static String searchFieldsFileName = "OMSSearchFields";

    public static OntModel createOntModel(String resourceID, String baseOntologyURI, InputStream data) throws Exception {
        OntModel m;
        try {
            String dbName = resourceID;
            log.debug((Object)("Creating dbConnection with dbName(ResourceID) " + dbName));
            DBConnection conn = new DBConnection("jdbc:derby:" + dbName + ";create=true", "", "", "Derby");
            ModelMaker maker = ModelFactory.createModelRDBMaker((IDBConnection)conn);
            log.debug((Object)("Creating basemodel " + baseOntologyURI));
            Model basemodel = maker.createModel(baseOntologyURI, false);
            OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
            spec.setImportModelMaker(maker);
            log.debug((Object)"Creating the ontology model...");
            m = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)basemodel);
            if (data != null) {
                log.debug((Object)"Reading data...");
                m.read(data, baseOntologyURI);
                m.setNsPrefix(OntologyManager.GCUBE_NS_PREFIX, OntologyManager.GCUBE_NS);
            }
            if (m == null) {
                throw new Exception("Model wasn't created");
            }
            m.createDatatypeProperty(OntologyManager.GCUBE_NS + "CollectionID");
        }
        catch (Exception e) {
            log.error((Object)("Could not create model for the ontology with uri: " + baseOntologyURI), (Throwable)e);
            throw new Exception("Could not create model for the ontology with uri: " + baseOntologyURI);
        }
        return m;
    }

    public static Map<String, String> persistSchemaOfOntModel(OntModel model, String resourceID, String baseOntologyURI) throws Exception {
        HashMap<String, String> ontologyToStorageIDMap = new HashMap<String, String>();
        String schemasRootDirectory = DBManager.DBPATH + File.separator + resourceID + File.separator + "schemas" + File.separator;
        File schemasRootDirectoryFile = new File(schemasRootDirectory);
        if (!schemasRootDirectoryFile.exists()) {
            schemasRootDirectoryFile.mkdirs();
        }
        String fileID = uuidGen.nextUUID();
        String fileName = schemasRootDirectory + fileID;
        log.debug((Object)("Persisting base ontology with uri: " + baseOntologyURI + " and fileID: " + fileID));
        model.write((OutputStream)new FileOutputStream(fileName), "RDF/XML-ABBREV", baseOntologyURI);
        ontologyToStorageIDMap.put(baseOntologyURI, fileID);
        Set imported = model.listImportedOntologyURIs(true);
        for (String ontologyURI : imported) {
            fileID = uuidGen.nextUUID();
            fileName = schemasRootDirectory + fileID;
            log.debug((Object)("Persisting ontology with uri: " + ontologyURI + " and fileID: " + fileID));
            ontologyToStorageIDMap.put(ontologyURI, fileID);
            model.getImportedModel(ontologyURI).write((OutputStream)new FileOutputStream(fileName), "RDF/XML-ABBREV", ontologyURI);
        }
        return ontologyToStorageIDMap;
    }

    public static String getTaxonomy(String resourceID) {
        String taxonomyRootDirectory = DBManager.DBPATH + File.separator + resourceID + File.separator + "schemas" + File.separator;
        String currentTaxonomyFileName = taxonomyRootDirectory + taxonomyFileName;
        File currentTaxonomyFile = new File(currentTaxonomyFileName);
        if (!currentTaxonomyFile.exists()) {
            return null;
        }
        try {
            return OntModelManager.readFileAsString(currentTaxonomyFile);
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to read taxonomy file", (Throwable)e);
            return null;
        }
    }

    public static String getSearchFields(String resourceID) {
        String searchFieldsRootDirectory = DBManager.DBPATH + File.separator + resourceID + File.separator + "schemas" + File.separator;
        String currentSearchFieldsFileName = searchFieldsRootDirectory + searchFieldsFileName;
        File currentSearchFieldsFile = new File(currentSearchFieldsFileName);
        if (!currentSearchFieldsFile.exists()) {
            return null;
        }
        try {
            return OntModelManager.readFileAsString(currentSearchFieldsFile);
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to read search fields file", (Throwable)e);
            return null;
        }
    }

    public static void persistSearchFields(String resourceID, String searchFields) throws Exception {
        String searchFieldsRootDirectory = DBManager.DBPATH + File.separator + resourceID + File.separator + "schemas" + File.separator;
        File searchFieldsRootDirectoryFile = new File(searchFieldsRootDirectory);
        if (!searchFieldsRootDirectoryFile.exists()) {
            searchFieldsRootDirectoryFile.mkdirs();
        }
        String currentSearchFieldsFileName = searchFieldsRootDirectory + searchFieldsFileName;
        FileWriter writer = new FileWriter(currentSearchFieldsFileName);
        writer.write(searchFields);
        writer.flush();
        writer.close();
    }

    public static void persistTaxonomy(String resourceID, String taxonomy) throws Exception {
        String taxonomyRootDirectory = DBManager.DBPATH + File.separator + resourceID + File.separator + "schemas" + File.separator;
        File taxonomyRootDirectoryFile = new File(taxonomyRootDirectory);
        if (!taxonomyRootDirectoryFile.exists()) {
            taxonomyRootDirectoryFile.mkdirs();
        }
        String currentTaxonomyFileName = taxonomyRootDirectory + taxonomyFileName;
        FileWriter writer = new FileWriter(currentTaxonomyFileName);
        writer.write(taxonomy);
        writer.flush();
        writer.close();
    }

    private static String readFileAsString(File file) throws Exception {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

