/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.manager;

import java.io.File;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBELog;

public class DBManager {
    private static final String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String protocol = "jdbc:derby:";
    public static final String dbType = "Derby";
    public static String DBPATH = "/tmp/oms/DBs";
    private static final GCUBELog log = new GCUBELog(DBManager.class);

    public static void init(String dbPath) throws Exception {
        Properties p = System.getProperties();
        if (dbPath != null) {
            if (!dbPath.endsWith(File.separator)) {
                dbPath = dbPath + File.separator;
            }
            DBPATH = dbPath + "DBs";
        } else {
            DBPATH = System.getenv("GLOBUS_LOCATION") + "/etc/org.gcube.ontologymanagement.ontologymanagementservice/DBs";
        }
        log.info((Object)("Going to store the database into " + DBPATH));
        p.put("derby.system.home", DBPATH);
        DBManager.loadDriver();
    }

    private static void loadDriver() throws Exception {
        try {
            Class.forName(driver).newInstance();
            log.info((Object)"Loaded the appropriate driver");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Unable to load the JDBC driver org.apache.derby.jdbc.EmbeddedDriver. Please check your CLASSPATH ", (Throwable)e);
            throw new Exception("Cannot LOAD Database");
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to instantiate the JDBC driver org.apache.derby.jdbc.EmbeddedDriver", (Throwable)e);
            throw new Exception("Cannot LOAD Database");
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Not allowed to access the JDBC driver org.apache.derby.jdbc.EmbeddedDriver", (Throwable)e);
            throw new Exception("Cannot LOAD Database");
        }
    }
}

