/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.ontologymanagement.ontologymanagementservice.clients;

import java.rmi.Remote;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManagerImpl;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.ArrayOfOntologyDescriptions;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OntologyDescription;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OntologyDescriptionAndURL;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.OntologyManagerFactoryPortType;
import org.gcube.ontologymanagement.ontologymanagementservice.stubs.service.OntologyManagerFactoryServiceAddressingLocator;

public class OMSClient {
    public static void main(String[] args) throws Exception {
        GCUBEScopeManagerImpl manager = new GCUBEScopeManagerImpl();
        manager.setScope(GCUBEScope.getScope((String)"/gcube/devsec"));
        System.out.println("OntologyManagementService Client is running...");
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress(new AttributedURI("http://dl17.di.uoa.gr:9876/wsrf/services/gcube/ontologymanagement/ontologymanagementservice/OntologyManagerFactory"));
        OntologyManagerFactoryPortType omsf = new OntologyManagerFactoryServiceAddressingLocator().getOntologyManagerFactoryPortTypePort(endpoint);
        manager.prepareCall((Remote)omsf, "OntologyManagement", "OntologyManagementService", new GCUBEScope[0]);
        OntologyDescriptionAndURL request = new OntologyDescriptionAndURL();
        OntologyDescription ontologyDescription = new OntologyDescription();
        ontologyDescription.setOntologyName("MyOntology");
        ontologyDescription.setOntologyURI("http://www.owl-ontologies.com/Ontology1211548142.owl");
        request.setOntologyDescription(ontologyDescription);
        request.setOntologyURL("http://dl14.di.uoa.gr/OntologyAdminPortlet/html/MyOntology.owl");
        try {
            omsf.importOntologyURL(request);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            ArrayOfOntologyDescriptions descs = omsf.getAvailableOntologies(null);
            if (descs.getOntologyDescriptions() == null) {
                System.out.println("There are not any available ontologies");
            } else {
                for (OntologyDescription desc : descs.getOntologyDescriptions()) {
                    System.out.println(desc.getOntologyName() + " - " + desc.getOntologyURI());
                    try {
                        EndpointReferenceType mendpoint = omsf.getOntologyManager(desc.getOntologyURI());
                        System.out.println(mendpoint.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

