/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.producer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.monitoring.LocalMonitor;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.messaging.endpoints.BrokerEndpoints;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.messaging.common.producer.BrokerNotConfiguredInScopeException;

public class GCUBELocalProducer
extends LocalMonitor {
    private static long refreshTime = 1800L;
    private static long waitingTime = 60L;
    private static HashMap<GCUBEScope, ScheduledRetriever> brokerMap = new HashMap();
    private static HashMap<GCUBEScope, ArrayList<ActiveMQConnectionFactory>> connectionFactoryMap = null;
    private static HashMap<GCUBEScope, ArrayList<TopicConnection>> topicConnectionMap = null;
    private static HashMap<GCUBEScope, ArrayList<QueueConnection>> queueConnectionMap = null;
    public static GCUBEClientLog logger = null;
    static Properties resources = new Properties();

    public GCUBELocalProducer() {
        try {
            resources.load(GCUBELocalProducer.class.getResourceAsStream("/GCUBELocalProducerLogger.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger = new GCUBEClientLog(GCUBELocalProducer.class, new Properties[]{resources});
        try {
            GCUBELocalProducer.addScope(GCUBEScope.getScope((String)("/" + GHNContext.getContext().getGHN().getInfrastructure())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadProbes(Map<String, Class<? extends GCUBETestProbe>> map) {
        try {
            Properties query = new Properties();
            query.load(GCUBELocalProducer.class.getResourceAsStream("/probes.properties"));
            for (Object prop : query.keySet()) {
                try {
                    map.put((String)prop, Class.forName((String)query.get(prop)));
                }
                catch (Exception e) {
                    logger.error((Object)"Error loading probe class", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error loading probes configuration", (Throwable)e);
        }
    }

    public static ArrayList<TopicConnection> getTopicConnection(GCUBEScope scope) {
        ArrayList<TopicConnection> connection = topicConnectionMap.get(scope);
        if (connection == null) {
            logger.debug((Object)"CONNECTION MAP NULL");
        }
        return connection;
    }

    public static ArrayList<QueueConnection> getQueueConnection(GCUBEScope scope) {
        ArrayList<QueueConnection> connection = queueConnectionMap.get(scope);
        if (connection == null) {
            logger.debug((Object)"CONNECTION MAP NULL");
        }
        return connection;
    }

    public static synchronized void addScope(GCUBEScope scope) throws BrokerNotConfiguredInScopeException, Exception {
        if (!brokerMap.containsKey(scope)) {
            ScopeProvider.instance.set(scope.toString());
            ScheduledRetriever ret = BrokerEndpoints.getRetriever((long)waitingTime, (long)refreshTime);
            if (ret.getFailoverEndpoint() != null) {
                logger.info((Object)("JMS failover endpoint: " + ret.getFailoverEndpoint() + " for scope: " + scope.toString()));
                brokerMap.put(scope, ret);
            } else {
                throw new BrokerNotConfiguredInScopeException();
            }
        }
    }

    public static synchronized Set<GCUBEScope> getMonitoredScope() {
        return brokerMap.keySet();
    }

    public static synchronized void removeScope(GCUBEScope scope) {
        brokerMap.remove(scope);
    }

    public static synchronized void reloadConnection(GCUBEScope scope) {
        GCUBELocalProducer.stopConnections(scope);
        ArrayList<ActiveMQConnectionFactory> factoryList = new ArrayList<ActiveMQConnectionFactory>();
        ArrayList<TopicConnection> connectionList = new ArrayList<TopicConnection>();
        ArrayList<QueueConnection> queueConnectionList = new ArrayList<QueueConnection>();
        logger.debug((Object)"Reload JMS connections");
        ScheduledRetriever ret = brokerMap.get(scope);
        try {
            logger.info((Object)("JMS failover endpoint: " + ret.getFailoverEndpoint() + " for scope: " + scope.toString()));
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(ret.getFailoverEndpoint());
            factoryList.add(factory);
            TopicConnection connection = factory.createTopicConnection();
            connectionList.add(connection);
            connection.start();
            QueueConnection queueCon = factory.createQueueConnection();
            queueConnectionList.add(queueCon);
            queueCon.start();
        }
        catch (JMSException e1) {
            logger.error((Object)"Error creating Topic Connection", (Throwable)e1);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating Topic Connection", (Throwable)e);
        }
        topicConnectionMap.put(scope, connectionList);
        queueConnectionMap.put(scope, queueConnectionList);
        connectionFactoryMap.put(scope, factoryList);
    }

    public void run() {
        connectionFactoryMap = new HashMap();
        topicConnectionMap = new HashMap();
        queueConnectionMap = new HashMap();
        try {
            resources.load(GCUBELocalProducer.class.getResourceAsStream("/GCUBELocalProducerLogger.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger = new GCUBEClientLog(GCUBELocalProducer.class, new Properties[]{resources});
        for (GCUBEScope scope : brokerMap.keySet()) {
            logger.info((Object)("Broker Map, scope to monitor: " + scope.toString()));
            GCUBELocalProducer.reloadConnection(scope);
        }
        if (this.implementationMap == null) {
            this.implementationMap = Collections.synchronizedMap(new HashMap());
            this.loadProbes(this.implementationMap);
        }
        for (Class classProbe : this.implementationMap.values()) {
            try {
                GCUBETestProbe probe = (GCUBETestProbe)classProbe.newInstance();
                probe.setInterval(this.interval);
                logger.info((Object)("Initializing " + classProbe + " Probe"));
                probe.execute();
            }
            catch (Exception e) {
                logger.error((Object)("Error Initializing probe " + classProbe), (Throwable)e);
            }
        }
    }

    public static boolean checkStartScope(GCUBEScope scope) {
        boolean isStartScope = false;
        for (GCUBEScope scopeStart : GHNContext.getContext().getStartScopes()) {
            if (!scope.equals((Object)scopeStart) && !scope.isInfrastructure()) continue;
            isStartScope = true;
        }
        return isStartScope;
    }

    private static void stopConnections(GCUBEScope scope) {
        if (topicConnectionMap != null && topicConnectionMap.get(scope) != null) {
            for (TopicConnection topicConnection : topicConnectionMap.get(scope)) {
                try {
                    topicConnection.stop();
                    topicConnection.close();
                }
                catch (JMSException e) {
                    logger.error((Object)"Error stopping topicConnections", (Throwable)e);
                }
            }
        }
        if (queueConnectionMap != null && queueConnectionMap.get(scope) != null) {
            for (QueueConnection queueConnection : queueConnectionMap.get(scope)) {
                try {
                    queueConnection.stop();
                    queueConnection.close();
                }
                catch (JMSException e) {
                    logger.error((Object)"Error stopping queueConnections", (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        long interval = 1200L;
        String brokerURL = "tcp://ui.grid.research-infrastructures.eu:6166";
        GCUBEScope scope = GCUBEScope.getScope((String)"/gcube/devsec");
        if (args.length == 3) {
            brokerURL = args[0];
            interval = Long.parseLong(args[1]);
            scope = GCUBEScope.getScope((String)args[2]);
        }
        HashMap monitoredScopes = new HashMap();
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        try {
            eprs.add(new EndpointReferenceType(new Address(brokerURL)));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
        }
        monitoredScopes.put(scope, eprs);
        GCUBELocalProducer local = new GCUBELocalProducer();
        local.setBrokerMap(monitoredScopes);
        local.setInterval(interval);
        local.run();
    }
}

