/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.probes;

import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gcube.common.portal.PortalContext;
import org.gcube.messaging.accounting.portal.probes.ParseFilters;
import org.gcube.messaging.accounting.portal.probes.PortalAccounting;
import org.gcube.messaging.accounting.portal.probes.PortalAccountingProbe;
import org.gcube.messaging.common.messages.GCUBEMessage;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalAccountingProbe
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(PortalAccountingProbe.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ParseFilters filter = null;
        File[] files = this.getLogFileToParse();
        logger.debug("Executing Accounting portal probe");
        try {
            filter = new ParseFilters();
        }
        catch (Exception e) {
            logger.error("Error creating banned user filters file");
        }
        String scope = "/" + PortalContext.getConfiguration().getInfrastructureName();
        if (files != null) {
            for (File logFile : files) {
                try {
                    for (PortalAccountingMessage message : PortalAccounting.createAccoutingMessages((File)logFile, (ParseFilters)filter)) {
                        message.setTimeNow();
                        message.setScope(scope);
                        message.setSourceGHN(InetAddress.getLocalHost().getHostName());
                        message.createTopicName(scope);
                        Thread.sleep(1000L);
                        this.sendMessage((GCUBEMessage)message);
                    }
                }
                catch (Exception e) {
                    logger.error("Error Executing Accounting probe", (Throwable)e);
                }
                finally {
                    this.renameFile(logFile);
                }
            }
        } else {
            logger.warn("Log file  already processed");
        }
    }

    private File[] getLogFileToParse() {
        File logsLocationFolder = new File(PortalAccounting.logsLocation);
        return logsLocationFolder.listFiles((FilenameFilter)new AccessLogFilter(this, null));
    }

    private void renameFile(File file) {
        file.renameTo(new File(file.getAbsolutePath() + ".OK"));
    }

    public void sendMessage(GCUBEMessage message) {
        ActiveMQClient.getSingleton().sendMessageToQueue(message);
    }

    private static String getTodayLogFile() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return "accessLog" + dateFormat.format(date.getTime()) + ".log";
    }

    static /* synthetic */ String access$100() {
        return PortalAccountingProbe.getTodayLogFile();
    }
}

