/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;

public class Statistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long totalAVG;
    private double avg;
    private long temp;
    private long totalCalls;
    private long interval;
    private long origInterval;

    Statistics(long l) {
        this.interval = l;
        this.totalAVG = 0L;
        this.avg = 0.0;
        this.temp = 0L;
        this.totalCalls = 0L;
        this.origInterval = l;
    }

    public long getTotalCalls() {
        return this.totalCalls;
    }

    public double getAvg() {
        if (this.totalAVG == 0L) {
            return this.temp;
        }
        return this.avg;
    }

    public void setAvg(double d) {
        this.avg = d;
    }

    public void addAvg(long l) {
        this.temp += l;
        this.totalCalls += l;
        --this.interval;
        if (this.interval == 0L) {
            ++this.totalAVG;
            this.avg = (this.avg + (double)this.temp) / (double)this.totalAVG;
            this.interval = this.origInterval;
            this.temp = 0L;
        }
    }
}

