/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.logparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.gcube.common.accounting.node.logparser.LogEntry;
import org.gcube.common.accounting.node.util.DateInterval;
import org.gcube.common.accounting.node.util.Util;

public class RIInvocationParser {
    private String fileName;
    private static String invalidScope = "INVALID";
    private DateInterval interval;
    private ArrayList<LogEntry> entryList = new ArrayList();

    public RIInvocationParser() {
    }

    public RIInvocationParser(String string) {
        this.fileName = string;
        this.interval = new DateInterval(new Long(0L));
    }

    public RIInvocationParser(String string, DateInterval dateInterval) {
        this.fileName = string;
        this.interval = dateInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, ParseException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
            while ((string = bufferedReader.readLine()) != null) {
                LogEntry logEntry = this.parseLine(string);
                if (logEntry == null) continue;
                this.entryList.add(logEntry);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    private LogEntry parseLine(String string) throws ParseException {
        String string2;
        LogEntry logEntry = null;
        if (string.contains(EntryType.ENDCALL.type) && !string.contains(invalidScope) && this.interval.contains(Util.format.parse(string2 = string.substring(0, string.indexOf(",")))).booleanValue()) {
            logEntry = new LogEntry(EntryType.ENDCALL, string.substring(string.indexOf(EntryType.ENDCALL.type)), string2);
        }
        return logEntry;
    }

    public ArrayList<LogEntry> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(ArrayList<LogEntry> arrayList) {
        this.entryList = arrayList;
    }

    public static enum EntryType {
        ENDCALL("END CALL"),
        STARTCALL("START CALL");

        String type;

        private EntryType(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

