/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Util {
    private static GCUBELog log = new GCUBELog(Util.class);
    private static int SOCKET_CONNECT_TIMEOUT_MS = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEndpointReachable(EndpointReferenceType epr) {
        boolean result = false;
        if (epr == null) {
            log.info((Object)"returning false because EPR is null");
            return false;
        }
        AttributedURI address = epr.getAddress();
        if (address == null) {
            log.info((Object)"returning false because address in EPR is null");
            return false;
        }
        String host = address.getHost();
        int port = address.getPort();
        log.trace((Object)("is the host " + host + " in the port " + port + " reachable?"));
        Socket socket = null;
        try {
            socket = SocketFactory.getDefault().createSocket();
            InetSocketAddress socketAddress = new InetSocketAddress(host, port);
            socket.connect(socketAddress, SOCKET_CONNECT_TIMEOUT_MS);
            socket.close();
            result = true;
            log.trace((Object)("the Address is reachable " + address));
        }
        catch (Throwable t) {
            log.warn((Object)("Endpoint at " + host + ":" + port + " is not reachable, Exception"), t);
            result = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.warn((Object)"is not possible to close the socket");
                }
            }
        }
        log.trace((Object)("the Endpoint is reachable - " + result));
        return result;
    }
}

