/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.util.EPR;
import org.gcube.informationsystem.notifier.util.RegistrationEventHandler;

public class TopicMapping<PRODUCER extends EPR, CONSUMER extends EPR, RE extends RegistrationEventHandler<PRODUCER, CONSUMER>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final GCUBELog logger = new GCUBELog(TopicMapping.class);
    private RE registrationEventHandler;
    private List<PRODUCER> producerList = Collections.synchronizedList(new ArrayList());
    private List<CONSUMER> consumerList = Collections.synchronizedList(new ArrayList());
    private QName topic;

    public TopicMapping(QName topic) {
        this.topic = topic;
        logger.info((Object)("creating new TopicMapping for the topic " + topic.toString()));
    }

    public void setTopic(QName topic) {
        this.topic = topic;
    }

    public QName getTopic() {
        return this.topic;
    }

    public synchronized void setProducerList(List<PRODUCER> producerList) {
        this.producerList = producerList;
    }

    public synchronized List<PRODUCER> getProducerList() {
        return this.producerList;
    }

    public List<CONSUMER> getConsumerList() {
        return this.consumerList;
    }

    public synchronized void setConsumerList(List<CONSUMER> consumerList) {
        this.consumerList = consumerList;
    }

    public void setRegistrationEventHandler(RE registrationEventHandler) throws Exception {
        this.registrationEventHandler = registrationEventHandler;
    }

    public RE getRegistrationEventHandler() {
        return this.registrationEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addConsumer(CONSUMER consumer) throws Exception {
        List<CONSUMER> list = this.consumerList;
        synchronized (list) {
            if (!this.consumerList.contains(consumer)) {
                logger.debug((Object)"the consumer is not already registered");
                this.registrationEventHandler.onNewConsumer(consumer, this.producerList);
                this.consumerList.add(consumer);
            } else {
                logger.warn((Object)"the consumer is already registered for this topic");
            }
        }
    }

    public synchronized void removeConsumer(CONSUMER consumer) throws Exception {
        try {
            this.registrationEventHandler.onRemoveConsumer(consumer);
            logger.trace((Object)("has the consumer been removed correctly? " + this.consumerList.remove(consumer)));
        }
        catch (Exception e) {
            logger.warn((Object)"error removing subscription", (Throwable)e);
            e.printStackTrace();
        }
    }

    public synchronized void removeProducer(PRODUCER producer) throws Exception {
        this.registrationEventHandler.onRemoveProducer(producer);
        this.producerList.remove(producer);
        logger.debug((Object)("producer " + ((EPR)producer).getEpr() + " removed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addProducer(PRODUCER producer) throws Exception {
        List<PRODUCER> list = this.producerList;
        synchronized (list) {
            if (!this.producerList.contains(producer)) {
                logger.debug((Object)"the producer does not exist, adding it");
                this.registrationEventHandler.onNewProducer(producer, this.consumerList);
                logger.debug((Object)"producer created, trying to add it to the prodcuer List");
                this.producerList.add(producer);
            } else {
                logger.debug((Object)"trying to deleate the old subscription and creating a new one");
                int oldProducerIndex = this.producerList.indexOf(producer);
                EPR oldProducer = (EPR)this.producerList.get(oldProducerIndex);
                this.registrationEventHandler.onProducerExist(producer, (EPR)oldProducer, this.consumerList);
                this.producerList.remove(oldProducerIndex);
                this.producerList.add(producer);
            }
        }
    }

    public synchronized List<EndpointReferenceType> getProducers() {
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        for (EPR prod : this.producerList) {
            eprs.add(prod.getEpr());
        }
        return eprs;
    }

    public synchronized List<EndpointReferenceType> getConsumers() {
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        for (EPR cons : this.consumerList) {
            eprs.add(cons.getEpr());
        }
        return eprs;
    }

    public boolean equals(Object o) {
        TopicMapping tp = (TopicMapping)o;
        return tp.getTopic().equals(this.getTopic());
    }
}

