/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.postprocessing.update;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.AvailablePurgers;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.Purger;
import org.gcube.informationsystem.registry.impl.postprocessing.update.Updater;

public class GHNUpdater
implements Updater<GCUBEHostingNode> {
    protected final GCUBELog logger = new GCUBELog(GHNUpdater.class);

    @Override
    public void update(GCUBEResource resource, GCUBEScope scope) {
        if (!(resource instanceof GCUBEHostingNode)) {
            return;
        }
        GCUBEHostingNode node = (GCUBEHostingNode)resource;
        this.logger.trace((Object)("The gHN is currently in status " + node.getNodeDescription().getStatus().toString()));
        if (node.getNodeDescription().getStatus() == GHNContext.Status.DOWN || node.getNodeDescription().getStatus() == GHNContext.Status.FAILED) {
            this.logger.trace((Object)"Looking for purger for GHN");
            Purger<?> purger = AvailablePurgers.getPurger("GHN");
            if (purger != null) {
                try {
                    this.logger.debug((Object)"Applying purger for GHN");
                    purger.purge(node.getID(), scope);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error while removing the profiles related to the resource", (Throwable)e);
                }
            } else {
                this.logger.trace((Object)"No purger found");
            }
        }
    }

    @Override
    public String getName() {
        return "GHN";
    }
}

