/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.informationsystem.publisher.ISGenericPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.informationsystem.publisher.ISResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.generic.CollectorClient;
import org.gcube.common.informationsystem.publisher.impl.generic.SinkLoader;
import org.w3c.dom.Document;

public class GCUBEGenericPublisher
implements ISGenericPublisher {
    protected static final GCUBELog logger = new GCUBELog(ISGenericPublisher.class);
    private static Map<GCUBEScope, Set<EndpointReferenceType>> rpdSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private static Map<GCUBEScope, Set<EndpointReferenceType>> profileSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private static Map<GCUBEScope, Set<EndpointReferenceType>> daixSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();

    public void register(ISResource resource, GCUBEScope scope, Document metadata) throws ISPublisherException {
        ArrayList<ISResource> toRegister = new ArrayList<ISResource>();
        toRegister.add(resource);
        ArrayList<Document> toRegisterMetadata = new ArrayList<Document>();
        toRegisterMetadata.add(metadata);
        this.register(toRegister, resource.getCollection(), toRegisterMetadata, scope);
    }

    public void register(ISResource resource, GCUBEScope scope) throws ISPublisherException {
        this.register(resource, scope, null);
    }

    public void register(List<ISResource> resources, GCUBEScope scope) throws ISPublisherException {
        HashMap map = new HashMap();
        for (ISResource resource : resources) {
            if (!map.containsKey(resource.getCollection())) {
                map.put(resource.getCollection(), new ArrayList());
            }
            ((List)map.get(resource.getCollection())).add(resource);
        }
        for (String collection : map.keySet()) {
            this.register((List)map.get(collection), collection, null, scope);
        }
    }

    public void remove(ISResource resource, GCUBEScope scope) throws ISPublisherException {
        ArrayList<ISResource> toRemove = new ArrayList<ISResource>();
        toRemove.add(resource);
        this.remove(toRemove, resource.getCollection(), scope);
    }

    public void update(ISResource resource, GCUBEScope scope) throws ISPublisherException {
        this.register(resource, scope);
    }

    public void update(List<ISResource> resources, GCUBEScope scope) throws ISPublisherException {
        this.register(resources, scope);
    }

    public void remove(List<ISResource> resources, GCUBEScope scope) throws ISPublisherException {
        HashMap map = new HashMap();
        for (ISResource resource : resources) {
            if (!map.containsKey(resource.getCollection())) {
                map.put(resource.getCollection(), new ArrayList());
            }
            ((List)map.get(resource.getCollection())).add(resource);
        }
        for (String collection : map.keySet()) {
            this.remove((List)map.get(collection), collection, scope);
        }
    }

    private Set<EndpointReferenceType> getSinks(ISResource.ISRESOURCETYPE isresourcetype, GCUBEScope scope) throws ISPublisherException {
        switch (isresourcetype) {
            case PROFILE: {
                if (!profileSinks.containsKey(scope)) {
                    profileSinks.put(scope, SinkLoader.loadResourceSinks(scope));
                }
                return profileSinks.get(scope);
            }
            case RPD: {
                if (!rpdSinks.containsKey(scope)) {
                    rpdSinks.put(scope, SinkLoader.loadStateSinks(scope));
                }
                return rpdSinks.get(scope);
            }
            case WSDAIX: {
                if (!daixSinks.containsKey(scope)) {
                    daixSinks.put(scope, SinkLoader.loadWSDAIXSinks(scope));
                }
                return daixSinks.get(scope);
            }
        }
        throw new GCUBEPublisherException("Unable to find any IC instance to publish");
    }

    private void register(List<ISResource> resources, String collection, List<Document> metadata, GCUBEScope scope) throws ISPublisherException {
        Set<EndpointReferenceType> ICEprs = this.getSinks(resources.get(0).getType(), scope);
        String[] resourcesID = new String[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            resourcesID[i] = resources.get(i).getID();
        }
        Document[] documents = new Document[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            documents[i] = resources.get(i).getDocument();
        }
        for (EndpointReferenceType sink : ICEprs) {
            int attempts = 0;
            boolean registered = false;
            while (attempts++ < 3 && !registered) {
                try {
                    CollectorClient.addDocuments(sink, scope, new URI("gcube://unused"), new URI("gcube://" + collection), resourcesID, documents, metadata.toArray(new Document[metadata.size()]));
                    registered = true;
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to send the Resource to the IC instance in scope " + scope), (Throwable)e);
                }
            }
            if (registered) continue;
            throw new GCUBEPublisherException("Failed to send the Resource to the IC instance in scope " + scope);
        }
    }

    private void remove(List<ISResource> resources, String collection, GCUBEScope scope) throws ISPublisherException {
        Set<EndpointReferenceType> ICEprs = this.getSinks(resources.get(0).getType(), scope);
        String[] resourcesID = new String[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            resourcesID[i] = resources.get(i).getID();
        }
        for (EndpointReferenceType sink : ICEprs) {
            int attempts = 0;
            boolean unregistered = false;
            while (attempts++ < 3 && !unregistered) {
                try {
                    CollectorClient.removeDocuments(sink, scope, new URI("gcube://unused"), new URI("gcube://" + collection), resourcesID);
                    unregistered = true;
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to remove the Resource from the IC instance in scope " + scope), (Throwable)e);
                }
            }
            if (unregistered) continue;
            throw new GCUBEPublisherException("Failed to remove the Resources from the IC instance in scope " + scope);
        }
    }
}

