/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.notifier.ISNotifierException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.notification.impl.client.BrokerPool;
import org.gcube.common.informationsystem.notification.impl.handlers.CheckTopicRegistrationOperationHandler;
import org.gcube.common.informationsystem.notification.impl.handlers.RegisterTopicHandler;
import org.gcube.common.informationsystem.notification.impl.handlers.UnregisterTopicHandler;
import org.gcube.informationsystem.notifier.stubs.IsOngoingRequest;
import org.gcube.informationsystem.notifier.stubs.RegisterTopicMessage;
import org.gcube.informationsystem.notifier.stubs.TopicItem;
import org.globus.wsrf.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCUBENotifier
implements ISNotifier {
    private final GCUBELog logger = new GCUBELog((Object)this);

    public void unregisterISNotification(EndpointReferenceType endpointReferenceType, List<? extends Topic> list, GCUBESecurityManager gCUBESecurityManager, GCUBEScope ... gCUBEScopeArray) throws ISNotifierException {
        this.logger.trace((Object)"unregisterISNotification method");
        if (gCUBEScopeArray == null || gCUBEScopeArray.length == 0) {
            throw new ISNotifierExceptionImpl("no scopes are passed");
        }
        for (GCUBEScope gCUBEScope : gCUBEScopeArray) {
            try {
                RegisterTopicMessage registerTopicMessage = new RegisterTopicMessage();
                registerTopicMessage.setEndpointReference(endpointReferenceType);
                String[] stringArray = new String[list.size()];
                int n = 0;
                for (Topic topic : list) {
                    stringArray[n++] = topic.getName().toString();
                }
                registerTopicMessage.setVectorTopic(stringArray);
                UnregisterTopicHandler unregisterTopicHandler = new UnregisterTopicHandler(registerTopicMessage, gCUBEScope, gCUBESecurityManager);
                unregisterTopicHandler.run();
            }
            catch (Exception exception) {
                this.logger.warn((Object)("Error unregistering Topics for scope " + gCUBEScope), (Throwable)exception);
            }
        }
    }

    public void registerISNotification(EndpointReferenceType endpointReferenceType, List<? extends Topic> list, GCUBESecurityManager gCUBESecurityManager, GCUBEScope ... gCUBEScopeArray) throws ISNotifierException {
        this.logger.trace((Object)"registerISNotification method");
        if (gCUBEScopeArray == null || gCUBEScopeArray.length == 0) {
            throw new ISNotifierExceptionImpl("no scopes are passed");
        }
        long l = System.currentTimeMillis();
        for (GCUBEScope gCUBEScope : gCUBEScopeArray) {
            try {
                this.logger.debug((Object)("trying to register " + endpointReferenceType.toString() + " in scope " + gCUBEScope.toString()));
                RegisterTopicMessage registerTopicMessage = new RegisterTopicMessage();
                registerTopicMessage.setEndpointReference(endpointReferenceType);
                String[] stringArray = new String[list.size()];
                int n = 0;
                for (Topic topic : list) {
                    stringArray[n++] = topic.getName().toString();
                }
                registerTopicMessage.setVectorTopic(stringArray);
                RegisterTopicHandler registerTopicHandler = new RegisterTopicHandler(registerTopicMessage, gCUBEScope, gCUBESecurityManager);
                registerTopicHandler.run();
            }
            catch (Exception exception) {
                this.logger.warn((Object)("Error registering Topics for scope " + gCUBEScope), (Throwable)exception);
            }
        }
        long l2 = System.currentTimeMillis();
        this.logger.trace((Object)("registerISNotification finished in " + (l2 - l) + " ms"));
    }

    public <T extends ISNotifier.BaseNotificationConsumer> void registerToISNotification(T t, List<ISNotifier.GCUBENotificationTopic> list, GCUBESecurityManager gCUBESecurityManager, GCUBEScope ... gCUBEScopeArray) throws ISNotifierException {
        this.logger.trace((Object)"registerToISNotification method");
        if (gCUBEScopeArray == null || gCUBEScopeArray.length == 0) {
            throw new ISNotifierExceptionImpl("the scopes parameter is empty or null");
        }
        for (GCUBEScope gCUBEScope : gCUBEScopeArray) {
            BrokerPool brokerPool = BrokerPool.getBrokerPool(gCUBEScope);
            for (ISNotifier.GCUBENotificationTopic gCUBENotificationTopic : list) {
                brokerPool.registerTopic(gCUBENotificationTopic, t, gCUBESecurityManager);
            }
        }
        this.logger.trace((Object)"registerToISNotification finished");
    }

    public void unregisterFromISNotification(GCUBESecurityManager gCUBESecurityManager, List<ISNotifier.GCUBENotificationTopic> list, GCUBEScope ... gCUBEScopeArray) throws ISNotifierException {
        if (gCUBEScopeArray == null || gCUBEScopeArray.length == 0) {
            throw new ISNotifierExceptionImpl("no scopes are passed");
        }
        for (GCUBEScope gCUBEScope : gCUBEScopeArray) {
            BrokerPool brokerPool = BrokerPool.getBrokerPool(gCUBEScope);
            for (ISNotifier.GCUBENotificationTopic gCUBENotificationTopic : list) {
                brokerPool.unregisterTopic(gCUBENotificationTopic, gCUBESecurityManager);
            }
        }
    }

    public boolean[] isTopicRegistered(GCUBESecurityManager gCUBESecurityManager, GCUBEScope gCUBEScope, List<ISNotifier.TopicData> list) throws ISNotifierException {
        IsOngoingRequest isOngoingRequest = new IsOngoingRequest();
        ArrayList<TopicItem> arrayList = new ArrayList<TopicItem>();
        for (ISNotifier.TopicData topicData : list) {
            arrayList.add(new TopicItem(topicData.getEpr(), topicData.getTopic().toString()));
        }
        isOngoingRequest.setItemList(arrayList.toArray(new TopicItem[0]));
        CheckTopicRegistrationOperationHandler checkTopicRegistrationOperationHandler = new CheckTopicRegistrationOperationHandler(isOngoingRequest, gCUBEScope, gCUBESecurityManager);
        try {
            checkTopicRegistrationOperationHandler.run();
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error checking for the registration operation ", (Throwable)exception);
            throw new ISNotifierExceptionImpl("Error checking for the registration operation");
        }
        return (boolean[])checkTopicRegistrationOperationHandler.getReturnValue();
    }

    private class ISNotifierExceptionImpl
    extends ISNotifierException {
        private static final long serialVersionUID = 3451898024491226477L;

        public ISNotifierExceptionImpl(String string) {
            super(string);
        }
    }
}

