/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index;

import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.semantic.DataServer;

@Path(value="/dataserver")
public class DataServerServlet {
    private static final String defaultCallback = "smartfish_response";

    @GET
    @Path(value="/find")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response find(@QueryParam(value="term") String term, @QueryParam(value="op") String op, @QueryParam(value="target") List<String> target, @QueryParam(value="page") String page, @QueryParam(value="concept_filter") List<String> concept_filter, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg = DataServer.getInstance().find(term, op, target.toArray(new String[target.size()]), page, concept_filter.toArray(new String[concept_filter.size()]));
        Response.Status status = msg != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }

    @GET
    @Path(value="/entity")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response entity(@QueryParam(value="op") String op, @QueryParam(value="target") List<String> target, @QueryParam(value="lang") String lang, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg = DataServer.getInstance().entity(op, target.toArray(new String[target.size()]), lang);
        Response.Status status = msg != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }

    @GET
    @Path(value="/document")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response document(@QueryParam(value="op") String op, @QueryParam(value="doc") String doc, @QueryParam(value="target") List<String> target, @QueryParam(value="lang") String lang, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg = DataServer.getInstance().document(op, doc, target.toArray(new String[target.size()]), lang);
        Response.Status status = msg != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }

    @GET
    @Path(value="/gis")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response gis(@QueryParam(value="op") String op, @QueryParam(value="target") List<String> target, @QueryParam(value="lang") String lang, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg;
        if (lang != null && lang.trim().length() == 0) {
            lang = null;
        }
        Response.Status status = (msg = DataServer.getInstance().gis(op, target.toArray(new String[target.size()]), lang)) != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }

    @GET
    @Path(value="/infobox")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response infobox(@QueryParam(value="op") String op, @QueryParam(value="target") String target, @QueryParam(value="lang") String lang, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg;
        if (lang != null && lang.trim().length() == 0) {
            lang = null;
        }
        Response.Status status = (msg = DataServer.getInstance().infobox(op, target, lang)) != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }

    @GET
    @Path(value="/exp")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response exp(@QueryParam(value="country") List<String> country, @QueryParam(value="species") List<String> species, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg = DataServer.getInstance().exp(country.toArray(new String[country.size()]), species.toArray(new String[species.size()]));
        Response.Status status = msg != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response statistics(@QueryParam(value="op") String op, @QueryParam(value="target") List<String> target, @QueryParam(value="lang") String lang, @QueryParam(value="callback") @DefaultValue(value="smartfish_response") String callback) {
        String msg;
        if (lang != null && lang.trim().length() == 0) {
            lang = null;
        }
        Response.Status status = (msg = DataServer.getInstance().statistics(op, target.toArray(new String[target.size()]), lang)) != null ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)(callback + "(" + msg + ");")).build();
    }
}

