/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gcube.index.Index;
import org.gcube.index.entities.SearchResponse;
import org.gcube.index.exceptions.BadRequestException;
import org.gcube.index.exceptions.InternalServerErrorException;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.FLOD_EntityCollection;
import org.gcube.textextractor.entities.ExtractedEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataServer {
    private static DataServer instance;
    private ArrayList<String> entitiesURIs = new ArrayList();

    public static DataServer getInstance() {
        if (instance == null) {
            instance = new DataServer();
        }
        return instance;
    }

    private DataServer() {
        AnnotationBase.getInstance();
        FLOD_EntityCollection.getInstance();
    }

    public String find(String term, String op, String[] target, String page, String[] concept_filter) {
        if (op.equals("match")) {
            return this.match(term);
        }
        if (op.equals("search")) {
            return this.search(term, page, concept_filter);
        }
        if (op.equals("bysbj")) {
            return this.listDocumentsOfAnnotatedEntity(target, page);
        }
        if (op.equals("scope")) {
            return this.searchInScope(term, target, page, concept_filter);
        }
        return SearchResponse.emptyResponse((String)"bad operation name");
    }

    public String entity(String op, String[] target, String lang) {
        if (op.equals("list")) {
            return this.listEntitiesInAnnotationBase(target, lang);
        }
        if (op.equals("species_in_country")) {
            return this.listSpeciesInCountry(target, lang);
        }
        return SearchResponse.emptyResponse((String)"bad operation name");
    }

    public String document(String op, String doc, String[] target, String lang) {
        if (op.equals("annotation")) {
            return this.listEntitiesAnnotatingDocument(doc, target, lang);
        }
        return SearchResponse.emptyResponse((String)"bad operation name");
    }

    public String gis(String op, String[] target, String lang) {
        if (op.equals("metalayer_of_entity")) {
            return this.gisMetaLayerOfEntity(target);
        }
        if (op.equals("metalayer_of_doc")) {
            return this.gisMetaLayerOfEntitiesInDocument(target[0]);
        }
        return SearchResponse.emptyResponse((String)"bad operation name");
    }

    public String infobox(String op, String target, String lang) {
        if (op.equals("describe")) {
            return this.listFactsAboutEntity(target, lang);
        }
        return SearchResponse.emptyResponse((String)"bad operation name");
    }

    public String statistics(String op, String[] target, String lang) {
        if (op.equals("repository")) {
            return this.listPublicationPerAnnotation();
        }
        if (op.equals("tagcloud")) {
            return this.listPublicationPerAnnotation(target, lang);
        }
        return SearchResponse.emptyResponse((String)"bad operation name");
    }

    private String listPublicationPerAnnotation() {
        return AnnotationBase.getInstance().statPublicationPerAnnotation();
    }

    private String listPublicationPerAnnotation(String[] target, String lang) {
        return AnnotationBase.getInstance().statPublicationPerAnnotation(target, lang);
    }

    public String exp(String[] country, String[] species) {
        return this.listDocumentsWithCoOccurringEntities(country, species);
    }

    private String search(String term, String page, String[] concept_filter) {
        int p = "".equals(page) ? 0 : Integer.valueOf(page);
        return this.searchIndexedDocument(term, p, Collections.EMPTY_LIST, Arrays.asList(concept_filter));
    }

    private String searchInScope(String term, String[] target, String page, String[] concept_filter) {
        int p = "".equals(page) ? 0 : Integer.valueOf(page);
        return this.searchIndexedDocument(term, p, Arrays.asList(target), Arrays.asList(concept_filter));
    }

    private String match(String stringMatch) {
        return Index.getInstance().autocompleteTitle(stringMatch, null, Integer.valueOf(10), Integer.valueOf(0), Boolean.valueOf(true)).getEntity().toString();
    }

    private String getDocsByURI(List<String> docURIs) {
        try {
            return Index.getInstance().getDocsAPI(docURIs, Boolean.valueOf(true), Integer.valueOf(docURIs.size()), Integer.valueOf(0));
        }
        catch (InternalServerErrorException internalServerErrorException) {
            return null;
        }
    }

    private String searchIndexedDocument(String searchTerm, int page, List<String> searchInTheseFields, List<String> concept_filter) {
        int count = page != 0 ? 10 : 1000;
        int from = page != 0 ? (page - 1) * count : 0;
        try {
            return Index.getInstance().queryAPI(searchTerm, Integer.valueOf(count), Integer.valueOf(from), Boolean.valueOf(true), Boolean.valueOf(true), searchInTheseFields, concept_filter);
        }
        catch (BadRequestException e) {
        }
        catch (InternalServerErrorException e) {
            // empty catch block
        }
        return null;
    }

    private String listDocumentsOfAnnotatedEntity(String[] forFlodEntityUris, String page) {
        int start = !"".equals(page) ? (Integer.valueOf(page) - 1) * 10 : 0;
        List docURIs = AnnotationBase.getInstance().listDocuments(forFlodEntityUris);
        if (!"".equals(page)) {
            docURIs = docURIs.subList(start, Math.min(start + 9, docURIs.size()));
        }
        return this.getDocsByURI(docURIs);
    }

    public String listDocumentsWithCoOccurringEntities(String[] countryURIs, String[] speciesURIs) {
        ArrayList docURIs = new ArrayList();
        for (int i = 0; i < countryURIs.length; ++i) {
            String countryURI = countryURIs[i];
            List docs = AnnotationBase.getInstance().listDocumentsWithCoOccuringEntities(countryURI, speciesURIs);
            this.addIfnotThere(docURIs, docs);
        }
        return this.getDocsByURI(docURIs);
    }

    private String listEntitiesAnnotatingDocument(String documentURI, String[] propertyLocalName, String lang) {
        this.entitiesURIs.clear();
        for (int i = 0; i < propertyLocalName.length; ++i) {
            List response = AnnotationBase.getInstance().listEntitiesOfDocument(documentURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#" + propertyLocalName[i]);
            this.addIfnotThere(this.entitiesURIs, response);
        }
        String sparqlJson = FLOD_EntityCollection.getInstance().getLabel((List)this.entitiesURIs, lang);
        return SearchResponse.makeEntitiesListResponseWithLang((String)sparqlJson, (String)lang);
    }

    private String listEntitiesInAnnotationBase(String[] propertyLocalName, String lang) {
        this.entitiesURIs.clear();
        for (int i = 0; i < propertyLocalName.length; ++i) {
            List response = AnnotationBase.getInstance().listEntitiesOfProperty("http://www.fao.org/figis/onto/smartfish/annotation.owl#" + propertyLocalName[i]);
            this.addIfnotThere(this.entitiesURIs, response);
        }
        String sparqlJson = FLOD_EntityCollection.getInstance().getLabel((List)this.entitiesURIs, lang);
        return SearchResponse.makeEntitiesListResponseWithLang((String)sparqlJson, (String)lang);
    }

    private String listFactsAboutEntity(String target, String lang) {
        if (!target.startsWith("http")) {
            try {
                target = this.findEntityInQuery(target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FLOD_EntityCollection.getInstance().infobox(target, lang);
    }

    private String findEntityInQuery(String target) throws Exception {
        String sparqlJson = FLOD_EntityCollection.getInstance().getURI(new ExtractedEntity(target, ""), "http://www.fao.org/figis/flod/onto/flagstate.owl#FlagStateCode");
        String entityURI = FLOD_EntityCollection.getValueFromJson((String)sparqlJson, (String)"uri");
        if (entityURI.isEmpty()) {
            sparqlJson = FLOD_EntityCollection.getInstance().getURI(new ExtractedEntity(target, ""), "http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode");
            entityURI = FLOD_EntityCollection.getValueFromJson((String)sparqlJson, (String)"uri");
        }
        return entityURI;
    }

    private String listSpeciesInCountry(String[] countryURIs, String lang) {
        this.entitiesURIs.clear();
        for (int i = 0; i < countryURIs.length; ++i) {
            List response = AnnotationBase.getInstance().listSpeciesInCountry(countryURIs[i]);
            this.addIfnotThere(this.entitiesURIs, response);
        }
        String sparqlJson = FLOD_EntityCollection.getInstance().getLabel((List)this.entitiesURIs, lang);
        return SearchResponse.makeEntitiesListResponseWithLang((String)sparqlJson, (String)lang);
    }

    private String gisMetaLayerOfEntity(String[] gisEntityURIs) {
        this.entitiesURIs.clear();
        for (int i = 0; i < gisEntityURIs.length; ++i) {
            List response = AnnotationBase.getInstance().getMetaLayer(gisEntityURIs[i]);
            this.addIfnotThere(this.entitiesURIs, response);
        }
        return FLOD_EntityCollection.getInstance().describeEntity((List)this.entitiesURIs, "", true, null);
    }

    private String gisMetaLayerOfEntitiesInDocument(String docURI) {
        List species = AnnotationBase.getInstance().listEntitiesOfDocument(docURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#species");
        List countries = AnnotationBase.getInstance().listEntitiesOfDocument(docURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#country");
        species.addAll(countries);
        return this.gisMetaLayerOfEntity(species.toArray(new String[species.size()]));
    }

    private void addIfnotThere(ArrayList<String> toThisList, List<String> elementsFromThisList) {
        for (String newUri : elementsFromThisList) {
            if (toThisList.contains(newUri)) continue;
            toThisList.add(newUri);
        }
    }

    public static void main(String[] args) {
        String[] doc = new String[]{"http://smartfish.collection/wiofish/189"};
        String[] annotProperty = new String[]{"year"};
        String[] annotProperty2 = new String[]{"market"};
        String[] concept_filter = new String[]{"management", "country"};
        String[] concept_filter_country = new String[]{"country"};
        String[] concept_filter_empty = new String[]{};
        String[] countries = new String[]{"http://www.fao.org/figis/flod/entities/codedentity/f527d0db-0255-4893-b266-cf8a18b6e9ca"};
        String[] species = new String[]{"http://www.fao.org/figis/flod/entities/codedentity/86021df0-f907-478b-a677-98c079466b8f"};
        String[] annotatingEntities = new String[]{"http://www.fao.org/figis/flod/entities/codedentity/f527d0db-0255-4893-b266-cf8a18b6e9ca"};
        System.out.println(DataServer.getInstance().find("comoros", "search", null, "", concept_filter_empty));
    }
}

