/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.helpers;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.utils.Locators;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gcube.textextractor.helpers.IndexHelper;

public class RS2Feed {
    private RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("Rowset")})};
    private RecordWriter<GenericRecord> writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), this.defs, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, 1L, TimeUnit.DAYS);
    static String uri = new String();
    static Object sync = new Object();

    public void feedIndexPayload(String payload) throws IOException {
        GenericRecord rec = new GenericRecord();
        try {
            rec.setFields(new Field[]{new StringField(payload.toString())});
            int hours = 1;
            while (!this.writer.put((Record)rec, 1L, TimeUnit.HOURS)) {
                if (++hours <= 25) continue;
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void feedIndex(String filename) throws IOException {
        String strLine;
        StringBuilder payload = new StringBuilder();
        FileInputStream fstream = new FileInputStream(filename);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            payload.append(strLine);
            if (strLine.startsWith("</ROWSET>")) {
                GenericRecord rec = new GenericRecord();
                try {
                    rec.setFields(new Field[]{new StringField(payload.toString())});
                    int hours = 1;
                    while (!this.writer.put((Record)rec, 1L, TimeUnit.HOURS)) {
                        if (++hours <= 25) continue;
                        this.writer.close();
                        this.writer = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                payload = new StringBuilder();
                continue;
            }
            payload.append("\n");
        }
        br.close();
    }

    public String getOutput() {
        try {
            URI TCPLocator = Locators.localToTCP((URI)this.writer.getLocator());
            return TCPLocator.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig("jazzman.di.uoa.gr", new ArrayList(), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        String filename = "/home/alex/Smartfish/rowsets/new/all_rowsets.xml";
        String scope = "/gcube/devsec";
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RS2Feed rs2 = null;
                try {
                    rs2 = new RS2Feed();
                }
                catch (GRS2WriterException e) {
                    e.printStackTrace();
                }
                Object e = sync;
                synchronized (e) {
                    if (rs2 != null) {
                        uri = rs2.getOutput();
                        System.out.println(uri);
                    } else {
                        System.out.println("rs2 was null");
                    }
                    sync.notify();
                }
                if (rs2 != null) {
                    try {
                        rs2.feedIndex("/home/alex/Smartfish/rowsets/new/all_rowsets.xml");
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        System.exit(0);
                    }
                    finally {
                        rs2.close();
                    }
                }
            }
        }.start();
        Object object = sync;
        synchronized (object) {
            while (uri.isEmpty()) {
                sync.wait();
            }
        }
        boolean deleteRet = false;
        try {
            deleteRet = IndexHelper.delete("/gcube/devsec");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!deleteRet) {
            try {
                IndexHelper.destroy("/gcube/devsec");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IndexHelper.createCluster("/gcube/devsec", 2);
        }
        IndexHelper.feedIndex("/gcube/devsec", uri);
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

